/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.fluilds.network.TankPacket;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.HeartTileEntity;
import ipsis.woot.modules.factory.client.ClientFactorySetup;
import ipsis.woot.setup.NetworkChannel;
import ipsis.woot.util.TankPacketHandler;
import ipsis.woot.util.WootContainer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkDirection;

public class HeartContainer
extends WootContainer
implements TankPacketHandler {
    private HeartTileEntity tileEntity;
    private int progress = 0;
    private FluidStack inputFluid = FluidStack.EMPTY;
    private int cellType = 0;

    public HeartContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        super((ContainerType)FactorySetup.HEART_BLOCK_CONTAINER.get(), windowId);
        this.tileEntity = (HeartTileEntity)world.func_175625_s(pos);
        this.addListeners();
    }

    public BlockPos getPos() {
        return this.tileEntity.func_174877_v();
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        return HeartContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileEntity.func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)playerIn, (Block)((Block)FactorySetup.HEART_BLOCK.get()));
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.inputFluid.isFluidStackIdentical(this.tileEntity.getTankFluid())) {
            this.inputFluid = this.tileEntity.getTankFluid().copy();
            TankPacket tankPacket = new TankPacket(0, this.inputFluid);
            for (IContainerListener l : this.field_75149_d) {
                if (!(l instanceof ServerPlayerEntity)) continue;
                NetworkChannel.channel.sendTo((Object)tankPacket, ((ServerPlayerEntity)l).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgress() {
        return this.progress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCellType() {
        return this.cellType;
    }

    private void addListeners() {
        this.addShortListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return HeartContainer.this.tileEntity.getProgress();
            }

            public void func_221494_a(int i) {
                HeartContainer.this.progress = i;
            }
        });
        this.addIntegerListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return HeartContainer.this.tileEntity.getCellType();
            }

            public void func_221494_a(int i) {
                HeartContainer.this.cellType = i;
            }
        });
    }

    public HeartTileEntity getTileEntity() {
        return this.tileEntity;
    }

    public void handleStaticDataReply(ClientFactorySetup clientFactorySetup) {
        this.tileEntity.setClientFactorySetup(clientFactorySetup);
    }

    @Override
    public void handlePacket(TankPacket packet) {
        if (packet.tankId == 0) {
            this.inputFluid = packet.fluidStack;
        }
    }
}

