/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import ipsis.woot.crafting.FluidConvertorRecipeBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FluidConvertorRecipe
implements IRecipe<IInventory> {
    private final Ingredient catalyst;
    private final int catalystCount;
    private final FluidStack inputFluid;
    private final FluidStack outputFluid;
    private final int energy;
    private final ResourceLocation id;
    private final IRecipeType<?> type;
    public static final IRecipeType<FluidConvertorRecipe> FLUID_CONV_TYPE = IRecipeType.func_222147_a((String)"woot:fluidconvertor");
    private static List<ItemStack> validCatalysts = new ArrayList<ItemStack>();
    private static List<FluidStack> validInputs = new ArrayList<FluidStack>();
    private List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();

    public FluidConvertorRecipe(ResourceLocation id, Ingredient catalyst, int catalystCount, FluidStack fluidStack, FluidStack outputFluid, int energy) {
        this.id = id;
        this.catalyst = catalyst;
        this.catalystCount = catalystCount;
        this.inputFluid = fluidStack;
        this.outputFluid = outputFluid;
        this.type = FLUID_CONV_TYPE;
        this.energy = energy;
        this.inputs.add(Arrays.asList(catalyst.func_193365_a()));
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public int getCatalystCount() {
        return this.catalystCount;
    }

    public FluidStack getOutput() {
        return this.outputFluid.copy();
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public int getEnergy() {
        return this.energy;
    }

    public String toString() {
        return "FluidConvertorRecipe{catalyst=" + this.catalyst + ", catalystCount=" + this.catalystCount + ", inputFluid=" + this.inputFluid + ", outputFluid=" + this.outputFluid + ", energy=" + this.energy + '}';
    }

    public static void clearValidCatalysts() {
        validCatalysts.clear();
    }

    public static void addValidCatalyst(ItemStack itemStack) {
        validCatalysts.add(itemStack);
    }

    public static boolean isValidCatalyst(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        for (ItemStack i : validCatalysts) {
            if (!i.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void clearValidInputs() {
        validInputs.clear();
    }

    public static void addValidInput(FluidStack fluidStack) {
        validInputs.add(fluidStack);
    }

    public static boolean isValidInput(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return false;
        }
        for (FluidStack f : validInputs) {
            if (!f.isFluidEqual(fluidStack)) continue;
            return true;
        }
        return false;
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.catalyst.test(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return null;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return FluidConvertorRecipeBuilder.SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }
}

