/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import ipsis.woot.Woot;
import ipsis.woot.crafting.FactoryRecipe;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FluidStackHelper;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FactoryRecipeSerializer<T extends FactoryRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;

    public FactoryRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        FakeMob fakeMob = new FakeMob(JSONUtils.func_151219_a((JsonObject)json, (String)"mob", (String)""));
        NonNullList items = NonNullList.func_191196_a();
        NonNullList fluids = NonNullList.func_191196_a();
        NonNullList drops = NonNullList.func_191196_a();
        JsonArray itemArray = JSONUtils.func_151214_t((JsonObject)json, (String)"items");
        for (int i = 0; i < itemArray.size(); ++i) {
            ItemStack itemStack;
            if (!(itemArray.get(i) instanceof JsonObject) || (itemStack = ShapedRecipe.func_199798_a((JsonObject)((JsonObject)itemArray.get(i)))).func_190926_b()) continue;
            items.add((Object)itemStack);
        }
        JsonArray fluidArray = JSONUtils.func_151214_t((JsonObject)json, (String)"fluids");
        for (int i = 0; i < fluidArray.size(); ++i) {
            FluidStack fluidStack;
            if (!(fluidArray.get(i) instanceof JsonObject) || (fluidStack = FluidStackHelper.parse((JsonObject)fluidArray.get(i))).isEmpty()) continue;
            fluids.add((Object)fluidStack);
        }
        JsonArray dropArray = JSONUtils.func_151214_t((JsonObject)json, (String)"drops");
        for (int i = 0; i < dropArray.size(); ++i) {
            JsonPrimitive primitive;
            int j;
            JsonObject jsonObject;
            ItemStack itemStack;
            if (!(dropArray.get(i) instanceof JsonObject) || (itemStack = CraftingHelper.getItemStack((JsonObject)(jsonObject = (JsonObject)dropArray.get(i)), (boolean)true)).func_190926_b()) continue;
            FactoryRecipe.Drop drop = new FactoryRecipe.Drop(itemStack);
            JsonArray sizeArray = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)"sizes");
            JsonArray chanceArray = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)"chances");
            for (j = 0; j < sizeArray.size(); ++j) {
                if (!sizeArray.get(j).isJsonPrimitive() || !(primitive = sizeArray.get(j).getAsJsonPrimitive()).isNumber()) continue;
                Integer stackSize = sizeArray.get(j).getAsInt();
                if (j >= 4) continue;
                drop.stackSizes[j] = stackSize;
            }
            for (j = 0; j < chanceArray.size(); ++j) {
                if (!chanceArray.get(j).isJsonPrimitive() || !(primitive = sizeArray.get(j).getAsJsonPrimitive()).isNumber()) continue;
                Float chance = Float.valueOf(chanceArray.get(j).getAsFloat());
                if (j >= 4) continue;
                drop.dropChance[j] = MathHelper.func_76131_a((float)chance.floatValue(), (float)0.0f, (float)100.0f);
            }
            drops.add((Object)drop);
        }
        return this.factory.create(recipeId, fakeMob, (NonNullList<ItemStack>)items, (NonNullList<FluidStack>)fluids, (NonNullList<FactoryRecipe.Drop>)drops);
    }

    @Nullable
    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            FakeMob fakeMob = new FakeMob(buffer.func_218666_n());
            NonNullList items = NonNullList.func_191196_a();
            NonNullList fluids = NonNullList.func_191196_a();
            NonNullList drops = NonNullList.func_191196_a();
            int itemCount = buffer.readShort();
            for (int i = 0; i < itemCount; ++i) {
                items.add((Object)buffer.func_150791_c());
            }
            int fluidCount = buffer.readShort();
            for (int i = 0; i < fluidCount; ++i) {
                fluids.add((Object)buffer.readFluidStack());
            }
            return this.factory.create(recipeId, fakeMob, (NonNullList<ItemStack>)items, (NonNullList<FluidStack>)fluids, (NonNullList<FactoryRecipe.Drop>)drops);
        }
        catch (Exception e) {
            Woot.setup.getLogger().error("FactoryRecipeSerializer:read", (Throwable)e);
            throw e;
        }
    }

    public void write(PacketBuffer buffer, T recipe) {
        try {
            buffer.func_180714_a(((FactoryRecipe)recipe).getFakeMob().toString());
            buffer.writeShort(((FactoryRecipe)recipe).getItems().size());
            for (ItemStack itemStack : ((FactoryRecipe)recipe).getItems()) {
                buffer.func_150788_a(itemStack);
            }
            buffer.writeShort(((FactoryRecipe)recipe).getFluids().size());
            for (FluidStack fluidStack : ((FactoryRecipe)recipe).getFluids()) {
                buffer.writeFluidStack(fluidStack);
            }
        }
        catch (Exception e) {
            Woot.setup.getLogger().error("FactoryRecipeSerializer:write", (Throwable)e);
            throw e;
        }
    }

    public static interface IFactory<T extends FactoryRecipe> {
        public T create(ResourceLocation var1, FakeMob var2, NonNullList<ItemStack> var3, NonNullList<FluidStack> var4, NonNullList<FactoryRecipe.Drop> var5);
    }
}

