/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public class AnvilRecipeBuilder {
    private final Ingredient baseIngredient;
    private final NonNullList<Ingredient> ingredients;
    private final Item result;
    private int count;
    @ObjectHolder(value="woot:anvil")
    public static final IRecipeSerializer<IRecipe<?>> SERIALIZER = null;

    public AnvilRecipeBuilder(IItemProvider result, int count, Ingredient baseIngredient) {
        this.baseIngredient = baseIngredient;
        this.result = result.func_199767_j();
        this.count = count;
        this.ingredients = NonNullList.func_191196_a();
    }

    public static AnvilRecipeBuilder anvilRecipe(IItemProvider result, int count, Ingredient baseIngredient) {
        return new AnvilRecipeBuilder(result, count, baseIngredient);
    }

    public AnvilRecipeBuilder addIngredient(Ingredient ingredient) {
        this.ingredients.add((Object)ingredient);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> recipe, String name) {
        recipe.accept(new Result(new ResourceLocation("woot", "anvil/" + name), this.baseIngredient, this.result, this.count, this.ingredients));
    }

    public static class Result
    implements IFinishedRecipe {
        private final NonNullList<Ingredient> ingredients;
        private final Ingredient baseIngredient;
        private final Item result;
        private final int count;
        private final ResourceLocation id;

        public Result(ResourceLocation id, Ingredient baseIngredient, Item result, int count, NonNullList<Ingredient> ingredients) {
            this.id = id;
            this.baseIngredient = baseIngredient;
            this.result = result;
            this.count = count;
            this.ingredients = ingredients;
        }

        public void func_218610_a(JsonObject json) {
            json.add("base", this.baseIngredient.func_200304_c());
            JsonArray array = new JsonArray();
            for (Ingredient i : this.ingredients) {
                array.add(i.func_200304_c());
            }
            json.add("ingredients", (JsonElement)array);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

