/*
 * Decompiled with CFR 0.152.
 */
package net.witcher_rpg.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.api.loot.LootConfig;
import net.witcher_rpg.item.armor.Armors;
import net.witcher_rpg.item.weapon.WeaponsRegister;

public class Default {
    public static final ItemConfig itemConfig = new ItemConfig();
    public static final LootConfig lootConfig;

    @SafeVarargs
    private static <T> List<T> joinLists(List<T> ... lists) {
        return Arrays.stream(lists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static {
        for (Armor.Entry armorSet : Armors.entries) {
            Default.itemConfig.armor_sets.put(armorSet.name(), armorSet.defaults());
        }
        for (Weapon.Entry weapon : WeaponsRegister.entries) {
            Default.itemConfig.weapons.put(weapon.name(), weapon.defaults());
        }
        lootConfig = new LootConfig();
        String weapons_epic = "weapons_epic";
        Default.lootConfig.item_groups.put("weapons_epic", new LootConfig.ItemGroup(List.of(WeaponsRegister.ultimatum.id().toString(), WeaponsRegister.winters_blade.id().toString()), 1).chance(0.15f));
        String weapons_legend = "weapons_legend";
        Default.lootConfig.item_groups.put("weapons_legend", new LootConfig.ItemGroup(List.of(WeaponsRegister.aerondight.id().toString()), 1).chance(0.1f));
        List.of("minecraft:chests/end_city_treasure", "minecraft:chests/bastion_treasure", "minecraft:chests/ancient_city", "minecraft:chests/stronghold_library").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("weapons_epic", "weapons_legend")));
    }
}

