/*
 * Decompiled with CFR 0.152.
 */
package mod.grimmauld.windowlogging;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mod.grimmauld.windowlogging.WindowInABlockModel;
import mod.grimmauld.windowlogging.WindowInABlockTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WindowInABlockBlock
extends PaneBlock {
    public WindowInABlockBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_226896_b_());
    }

    private static void addBlockHitEffects(ParticleManager manager, BlockPos pos, BlockRayTraceResult target, BlockState blockstate, ClientWorld world) {
        VoxelShape shape = blockstate.func_196954_c((IBlockReader)world, pos);
        if (shape.func_197766_b()) {
            return;
        }
        Direction side = target.func_216354_b();
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        AxisAlignedBB axisalignedbb = shape.func_197752_a();
        double d0 = (double)i + manager.field_78875_d.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
        double d1 = (double)j + manager.field_78875_d.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
        double d2 = (double)k + manager.field_78875_d.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
        if (side == Direction.DOWN) {
            d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
        }
        if (side == Direction.UP) {
            d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
        }
        if (side == Direction.NORTH) {
            d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
        }
        if (side == Direction.SOUTH) {
            d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
        }
        if (side == Direction.WEST) {
            d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
        }
        if (side == Direction.EAST) {
            d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
        }
        manager.func_78873_a(new DiggingParticle(world, d0, d1, d2, 0.0, 0.0, 0.0, blockstate).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WindowInABlockTileEntity();
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (player == null) {
            return super.removedByPlayer(state, world, pos, null, willHarvest, fluid);
        }
        Vector3d start = player.func_174824_e(1.0f);
        ModifiableAttributeInstance reachDistanceAttribute = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (reachDistanceAttribute == null) {
            return super.removedByPlayer(state, world, pos, null, willHarvest, fluid);
        }
        Vector3d end = start.func_178787_e(player.func_70040_Z().func_186678_a(reachDistanceAttribute.func_111126_e()));
        BlockRayTraceResult target = world.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        WindowInABlockTileEntity tileEntity = this.getTileEntity((IBlockReader)world, pos);
        if (tileEntity == null) {
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        BlockState windowBlock = tileEntity.getWindowBlock();
        CompoundNBT partialBlockTileData = tileEntity.getPartialBlockTileData();
        for (AxisAlignedBB bb : windowBlock.func_196954_c((IBlockReader)world, pos).func_197756_d()) {
            TileEntity te;
            if (!bb.func_186662_g(0.1).func_72318_a(target.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) continue;
            windowBlock.func_177230_c().func_176208_a(world, pos, windowBlock, player);
            if (!player.func_184812_l_()) {
                Block.func_220054_a((BlockState)windowBlock, (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
            BlockState partialBlock = tileEntity.getPartialBlock();
            world.func_175656_a(pos, partialBlock);
            for (Direction d : Direction.values()) {
                BlockPos offset = pos.func_177972_a(d);
                BlockState otherState = world.func_180495_p(offset);
                partialBlock = partialBlock.func_196956_a(d, otherState, (IWorld)world, pos, offset);
                world.func_184138_a(offset, otherState, otherState, 2);
            }
            if (partialBlock != world.func_180495_p(pos)) {
                world.func_175656_a(pos, partialBlock);
            }
            if (world.func_180495_p(pos).hasTileEntity() && (te = world.func_175625_s(pos)) != null) {
                te.deserializeNBT(partialBlockTileData);
                te.func_70296_d();
            }
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getSurroundingBlockState(reader, pos).func_200131_a(reader, pos);
    }

    public boolean collisionExtendsVertically(BlockState state, IBlockReader world, BlockPos pos, Entity collidingEntity) {
        return this.getSurroundingBlockState(world, pos).collisionExtendsVertically(world, pos, collidingEntity);
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return this.getSurroundingBlockState(worldIn, pos).func_185903_a(player, worldIn, pos);
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return this.getSurroundingBlockState(world, pos).getExplosionResistance(world, pos, explosion);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        BlockState window = this.getWindowBlockState(world, pos);
        for (AxisAlignedBB bb : window.func_196954_c(world, pos).func_197756_d()) {
            if (!bb.func_186662_g(0.1).func_72318_a(target.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) continue;
            return window.getPickBlock(target, world, pos, player);
        }
        BlockState surrounding = this.getSurroundingBlockState(world, pos);
        return surrounding.getPickBlock(target, world, pos, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (!(tileentity instanceof WindowInABlockTileEntity)) {
            return Collections.emptyList();
        }
        WindowInABlockTileEntity te = (WindowInABlockTileEntity)tileentity;
        TileEntity partialTE = te.getPartialBlockTileEntityIfPresent();
        if (partialTE != null) {
            builder.func_216015_a(LootParameters.field_216288_h, (Object)partialTE);
        }
        List drops = te.getPartialBlock().func_215693_a(builder);
        builder.func_216015_a(LootParameters.field_216288_h, (Object)tileentity);
        drops.addAll(te.getWindowBlock().func_215693_a(builder));
        return drops;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape1 = this.getSurroundingBlockState(worldIn, pos).func_215700_a(worldIn, pos, context);
        VoxelShape shape2 = this.getWindowBlockState(worldIn, pos).func_215700_a(worldIn, pos, context);
        return VoxelShapes.func_197872_a((VoxelShape)shape1, (VoxelShape)shape2);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        WindowInABlockTileEntity te = this.getTileEntity((IBlockReader)worldIn, currentPos);
        if (te == null) {
            return stateIn;
        }
        te.setWindowBlock(te.getWindowBlock().func_196956_a(facing, facingState, worldIn, currentPos, facingPos));
        BlockState blockState = te.getPartialBlock().func_196956_a(facing, facingState, worldIn, currentPos, facingPos);
        if (blockState.func_177230_c() instanceof FourWayBlock) {
            for (BooleanProperty side : Arrays.asList(FourWayBlock.field_196411_b, FourWayBlock.field_196409_a, FourWayBlock.field_196413_c, FourWayBlock.field_196414_y)) {
                blockState = (BlockState)blockState.func_206870_a((Property)side, (Comparable)Boolean.valueOf(false));
            }
            te.setPartialBlock(blockState);
        }
        te.requestModelDataUpdate();
        return stateIn;
    }

    public BlockState getSurroundingBlockState(IBlockReader reader, BlockPos pos) {
        WindowInABlockTileEntity te = this.getTileEntity(reader, pos);
        if (te != null) {
            return te.getPartialBlock();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public BlockState getWindowBlockState(IBlockReader reader, BlockPos pos) {
        WindowInABlockTileEntity te = this.getTileEntity(reader, pos);
        if (te != null) {
            return te.getWindowBlock();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    @Nullable
    private WindowInABlockTileEntity getTileEntity(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof WindowInABlockTileEntity) {
            return (WindowInABlockTileEntity)te;
        }
        return null;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        WindowInABlockTileEntity te = this.getTileEntity((IBlockReader)world, pos);
        return super.getSoundType(te != null ? te.getPartialBlock() : state, world, pos, entity);
    }

    public boolean addLandingEffects(BlockState state1, ServerWorld world, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        WindowInABlockTileEntity te = this.getTileEntity((IBlockReader)world, pos);
        if (te != null) {
            te.getWindowBlock().addLandingEffects(world, pos, state2, entity, numberOfParticles / 2);
            return te.getPartialBlock().addLandingEffects(world, pos, state2, entity, numberOfParticles / 2);
        }
        return false;
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        WindowInABlockTileEntity te = this.getTileEntity((IBlockReader)world, pos);
        if (te != null) {
            te.getWindowBlock().addRunningEffects(world, pos, entity);
            return te.getPartialBlock().addRunningEffects(world, pos, entity);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        WindowInABlockTileEntity te = this.getTileEntity((IBlockReader)world, pos);
        if (te != null) {
            te.getWindowBlock().addDestroyEffects(world, pos, manager);
            manager.func_180533_a(pos, te.getWindowBlock());
            return te.getPartialBlock().addDestroyEffects(world, pos, manager);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target.func_216346_c() != RayTraceResult.Type.BLOCK || !(target instanceof BlockRayTraceResult) || !(world instanceof ClientWorld)) {
            return false;
        }
        BlockPos pos = ((BlockRayTraceResult)target).func_216350_a();
        WindowInABlockTileEntity te = this.getTileEntity((IBlockReader)world, pos);
        if (te != null) {
            te.getWindowBlock().addHitEffects(world, target, manager);
            WindowInABlockBlock.addBlockHitEffects(manager, pos, (BlockRayTraceResult)target, te.getWindowBlock(), (ClientWorld)world);
            return te.getPartialBlock().addHitEffects(world, target, manager);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBakedModel createModel(IBakedModel original) {
        return new WindowInABlockModel(original);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        WindowInABlockTileEntity te = this.getTileEntity(world, pos);
        if (te != null) {
            BlockState partialState = te.getPartialBlock();
            partialState.func_177230_c().getLightValue(partialState, world, pos);
        }
        return 0;
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        WindowInABlockTileEntity te = this.getTileEntity((IBlockReader)world, pos);
        if (te != null) {
            BlockState windowState = te.getWindowBlock();
            return windowState.func_177230_c().getBeaconColorMultiplier(windowState, world, pos, beaconPos);
        }
        return super.getBeaconColorMultiplier(state, world, pos, beaconPos);
    }
}

