/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.function.Supplier;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.container.ModContainers;
import net.blay09.mods.waystones.container.WaystoneSettingsContainer;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class RequestEditWaystoneMessage {
    private final IWaystone waystone;
    private final INamedContainerProvider containerProvider = new INamedContainerProvider(){

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent("container.waystones.waystone_settings");
        }

        public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            return new WaystoneSettingsContainer(ModContainers.waystoneSettings, RequestEditWaystoneMessage.this.waystone, i);
        }
    };

    public RequestEditWaystoneMessage(IWaystone waystone) {
        this.waystone = waystone;
    }

    public static void encode(RequestEditWaystoneMessage message, PacketBuffer buf) {
        buf.func_179252_a(message.waystone.getWaystoneUid());
    }

    public static RequestEditWaystoneMessage decode(PacketBuffer buf) {
        WaystoneProxy waystone = new WaystoneProxy(buf.func_179253_g());
        return new RequestEditWaystoneMessage(waystone);
    }

    public static void handle(RequestEditWaystoneMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            WaystoneEditPermissions permissions = PlayerWaystoneManager.mayEditWaystone((PlayerEntity)player, player.field_70170_p, message.waystone);
            if (permissions != WaystoneEditPermissions.ALLOW) {
                return;
            }
            BlockPos pos = message.waystone.getPos();
            if (player.func_70092_e((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f)) > 64.0) {
                return;
            }
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)message.containerProvider, it -> Waystone.write(it, message.waystone));
        });
        context.setPacketHandled(true);
    }
}

