/*
 * Decompiled with CFR 0.152.
 */
package com.SpectrumFATM.vortexmanipulators.network;

import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.helper.LandingSystem;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.world.dimensions.TDimensions;

public class PacketTemporalShift {
    private Random random = new Random();

    public PacketTemporalShift(PacketBuffer buf) {
    }

    public PacketTemporalShift() {
    }

    public void toBytes(PacketBuffer buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity sender = ctx.get().getSender();
        sender.field_70170_p.func_184134_a(sender.func_226277_ct_(), sender.func_226278_cu_(), sender.func_226281_cx_(), (SoundEvent)TSounds.SONIC_BROKEN.get(), SoundCategory.AMBIENT, 1.0f, 1.0f, true);
        sender.func_184611_a(sender.func_184600_cs(), ItemStack.field_190927_a);
        BlockPos randomCoords = this.generateCoordinates(sender);
        RegistryKey<World> randomWorld = this.getRandomWorldKey(sender);
        BlockPos destination = LandingSystem.getTopBlock((World)sender.func_184102_h().func_71218_a(randomWorld), (BlockPos)randomCoords);
        sender.getCapability(Capabilities.PLAYER_DATA).ifPresent(playerCap -> {
            playerCap.setDestination(new SpaceTimeCoord(randomWorld, destination));
            playerCap.calcDisplacement(sender.func_233580_cy_(), destination);
        });
        WorldHelper.teleportEntities((Entity)sender, (ServerWorld)sender.field_70170_p.func_73046_m().func_71218_a(TDimensions.VORTEX_DIM), (BlockPos)new BlockPos(0.0, 3000.0, 0.0), (float)0.0f, (float)90.0f);
        int chance = this.random.nextInt(10);
        if (chance == 0) {
            sender.func_70097_a(DamageSource.field_76377_j, 16.0f);
        }
    }

    public BlockPos generateCoordinates(ServerPlayerEntity sender) {
        int positiveNegative = this.random.nextInt(2);
        double x = positiveNegative == 1 ? sender.func_226277_ct_() + (double)this.random.nextInt(10000) : sender.func_226277_ct_() - (double)this.random.nextInt(10000);
        positiveNegative = this.random.nextInt(2);
        double z = positiveNegative == 1 ? sender.func_226281_cx_() + (double)this.random.nextInt(10000) : sender.func_226281_cx_() - (double)this.random.nextInt(10000);
        return new BlockPos(x, 64.0, z);
    }

    public RegistryKey<World> getRandomWorldKey(ServerPlayerEntity sender) {
        Iterable serverWorld = sender.func_184102_h().func_212370_w();
        ArrayList worlds = new ArrayList();
        serverWorld.forEach(world -> {
            if (WorldHelper.getAllValidDimensions().contains(world)) {
                worlds.add(world);
            }
        });
        int randomIndex = this.random.nextInt(worlds.size() - 1);
        while (((ServerWorld)worlds.get(randomIndex)).func_234923_W_().func_240901_a_().toString().equals("minecraft:the_end") || ((ServerWorld)worlds.get(randomIndex)).func_234923_W_().func_240901_a_().toString().equals("minecraft:the_nether")) {
            randomIndex = this.random.nextInt(worlds.size() - 1);
        }
        return WorldHelper.getWorldKeyFromRL((ResourceLocation)((ServerWorld)worlds.get(randomIndex)).func_234923_W_().func_240901_a_());
    }
}

