/*
 * Decompiled with CFR 0.152.
 */
package com.SpectrumFATM.vortexmanipulators.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.tardis.mod.helper.TextHelper;

public class PacketLocator {
    private String structure;

    public PacketLocator(PacketBuffer buf) {
        this.structure = buf.func_218666_n();
    }

    public PacketLocator(String structure) {
        this.structure = structure;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.structure);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        BlockPos location;
        ServerPlayerEntity sender = ctx.get().getSender();
        Structure selectedStructure = (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(new ResourceLocation(this.structure));
        if (selectedStructure == null) {
            sender.func_146105_b((ITextComponent)TextHelper.createVortexManipMessage((IFormattableTextComponent)new StringTextComponent("Error! Unable to locate this structure.")), false);
        }
        if ((location = sender.func_71121_q().func_241117_a_(selectedStructure, new BlockPos(sender.func_226277_ct_(), sender.func_226278_cu_(), sender.func_226281_cx_()), 100, false)) != null) {
            sender.func_146105_b((ITextComponent)TextHelper.createVortexManipMessage((IFormattableTextComponent)new StringTextComponent("Located at the following coordinates: " + location.func_177958_n() + " ~ " + location.func_177952_p())), false);
        } else {
            sender.func_146105_b((ITextComponent)TextHelper.createVortexManipMessage((IFormattableTextComponent)new StringTextComponent("Error! Unable to locate this structure.")), false);
        }
    }
}

