/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.recipe;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.valkyrieofnight.vlib.core.io.datapack.JsonDataLoader;
import com.valkyrieofnight.vlib.core.io.json.JsonUtils;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializerRegistry;
import com.valkyrieofnight.vlib.registry.recipe.AbstractRecipeRegistry;
import com.valkyrieofnight.vlib.registry.recipe.RecipeOverride;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipe;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipeRegistry;
import java.lang.reflect.Type;

public abstract class VLRecipeSerializer<RECIPE extends VLRecipe, REGISTRY extends VLRecipeRegistry<RECIPE>>
extends JsonDataLoader<RECIPE, REGISTRY>
implements JsonDeserializer<RECIPE> {
    public VLRecipeSerializer(REGISTRY registry) {
        super(((AbstractRecipeRegistry)registry).getModID(), ((AbstractRecipeRegistry)registry).getRegistryName(), ((AbstractRecipeRegistry)registry).getRecipeClass(), registry);
        this.fileExtension = ".json";
        this.gson = JsonUtils.createTypedGsonBuilder(ProviderDeserializerRegistry.getInstance().getAllAsArray()).registerTypeAdapter(TypeToken.get(((AbstractRecipeRegistry)registry).getRecipeClass()).getType(), (Object)this).create();
    }

    public RECIPE deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        RECIPE r;
        if (json == null) {
            return null;
        }
        RecipeOverride override = RecipeOverride.NONE;
        if (json.isJsonObject()) {
            JsonObject o = (JsonObject)json;
            override = RecipeOverride.getFromName(JsonUtils.getAsStringOrDefault(o, "override", "none"));
        }
        if ((r = override == RecipeOverride.DISABLE ? this.createBlankDisableRecipe() : this.deserializeRecipe(json, typeOfT, context)) != null) {
            ((VLRecipe)r).setRecipeOverride(override);
        }
        return r;
    }

    public abstract RECIPE deserializeRecipe(JsonElement var1, Type var2, JsonDeserializationContext var3) throws JsonParseException;

    protected abstract RECIPE createBlankDisableRecipe();
}

