/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.provider.deserializers.statement;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.valkyrieofnight.vlib.core.io.json.JsonUtils;
import com.valkyrieofnight.vlib.core.util.logic.operators.RelationalOperator;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializer;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializerRegistry;
import com.valkyrieofnight.vlib.registry.provider.statement.Comparator;
import com.valkyrieofnight.vlib.registry.provider.statement.IfElseProvider;
import java.lang.reflect.Type;

public class IfElseProviderDeserializers {
    private static final String LEFT_IDENTIFIER = "left";
    private static final String RIGHT_IDENTIFIER = "right";
    private static final String OPERATOR_IDENTIFIER = "operator";
    private static final String TRUE_IDENTIFIER = "true";
    private static final String FALSE_IDENTIFIER = "false";
    public static final ProviderDeserializer<IfElseProvider.Boolean> BOOLEAN = new ProviderDeserializer<IfElseProvider.Boolean>(IfElseProvider.Boolean.class, "if_else:boolean"){

        public IfElseProvider.Boolean deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.Boolean(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.Byte> BYTE = new ProviderDeserializer<IfElseProvider.Byte>(IfElseProvider.Byte.class, "if_else:byte"){

        public IfElseProvider.Byte deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.Byte(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.Short> SHORT = new ProviderDeserializer<IfElseProvider.Short>(IfElseProvider.Short.class, "if_else:short"){

        public IfElseProvider.Short deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.Short(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.Int> INT = new ProviderDeserializer<IfElseProvider.Int>(IfElseProvider.Int.class, "if_else:int"){

        public IfElseProvider.Int deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.Int(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.Long> LONG = new ProviderDeserializer<IfElseProvider.Long>(IfElseProvider.Long.class, "if_else:long"){

        public IfElseProvider.Long deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.Long(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.Float> FLOAT = new ProviderDeserializer<IfElseProvider.Float>(IfElseProvider.Float.class, "if_else:float"){

        public IfElseProvider.Float deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.Float(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.Double> DOUBLE = new ProviderDeserializer<IfElseProvider.Double>(IfElseProvider.Double.class, "if_else:double"){

        public IfElseProvider.Double deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.Double(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.Char> CHAR = new ProviderDeserializer<IfElseProvider.Char>(IfElseProvider.Char.class, "if_else:char"){

        public IfElseProvider.Char deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.Char(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.String> STRING = new ProviderDeserializer<IfElseProvider.String>(IfElseProvider.String.class, "if_else:string"){

        public IfElseProvider.String deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.String(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.Item> ITEM = new ProviderDeserializer<IfElseProvider.Item>(IfElseProvider.Item.class, "if_else:item"){

        public IfElseProvider.Item deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.Item(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.Fluid> FLUID = new ProviderDeserializer<IfElseProvider.Fluid>(IfElseProvider.Fluid.class, "if_else:fluid"){

        public IfElseProvider.Fluid deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.Fluid(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.ItemStack> ITEMSTACK = new ProviderDeserializer<IfElseProvider.ItemStack>(IfElseProvider.ItemStack.class, "if_else:itemstack"){

        public IfElseProvider.ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.ItemStack(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.FluidStack> FLUIDSTACK = new ProviderDeserializer<IfElseProvider.FluidStack>(IfElseProvider.FluidStack.class, "if_else:fluidstack"){

        public IfElseProvider.FluidStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.FluidStack(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.CompoundNBT> NBT = new ProviderDeserializer<IfElseProvider.CompoundNBT>(IfElseProvider.CompoundNBT.class, "if_else:nbt"){

        public IfElseProvider.CompoundNBT deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.CompoundNBT(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.ItemTag> ITEM_TAG = new ProviderDeserializer<IfElseProvider.ItemTag>(IfElseProvider.ItemTag.class, "if_else:item_tag"){

        public IfElseProvider.ItemTag deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.ItemTag(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.BlockTag> BLOCK_TAG = new ProviderDeserializer<IfElseProvider.BlockTag>(IfElseProvider.BlockTag.class, "if_else:block_tag"){

        public IfElseProvider.BlockTag deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.BlockTag(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final ProviderDeserializer<IfElseProvider.FluidTag> FLUID_TAG = new ProviderDeserializer<IfElseProvider.FluidTag>(IfElseProvider.FluidTag.class, "if_else:fluid_tag"){

        public IfElseProvider.FluidTag deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject() && IfElseProviderDeserializers.hasAllRequired((JsonObject)json)) {
                JsonObject jo = (JsonObject)json;
                String operator = JsonUtils.getAsString(jo.get(IfElseProviderDeserializers.OPERATOR_IDENTIFIER));
                JsonObject ol = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.LEFT_IDENTIFIER);
                JsonObject or = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.RIGHT_IDENTIFIER);
                JsonObject ot = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.TRUE_IDENTIFIER);
                JsonObject of = JsonUtils.getAsJsonObject(jo, IfElseProviderDeserializers.FALSE_IDENTIFIER);
                try {
                    RelationalOperator ro = RelationalOperator.getFromString(operator);
                    String returnDataType = DeserializerUtils.getReturnDataType(this.getTypeIdentifier());
                    Type tl = DeserializerUtils.getDeserializerTypeFromObject(ol);
                    Type tr = DeserializerUtils.getDeserializerTypeFromObject(or);
                    Type tt = DeserializerUtils.getDeserializerTypeFromObject(ot);
                    Type tf = DeserializerUtils.getDeserializerTypeFromObject(of);
                    String ldt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tl);
                    String rdt = ProviderDeserializerRegistry.getInstance().getDataReturnType(tr);
                    if (!ldt.equals(rdt)) {
                        throw new JsonParseException("IfElse has mismatched test data types: " + ldt + " != " + rdt);
                    }
                    if (!ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tt, returnDataType) || !ProviderDeserializerRegistry.getInstance().isCompatibleDeserializer(tf, returnDataType)) {
                        throw new JsonParseException("IfElse has mismatched return data types: Required: " + returnDataType);
                    }
                    Comparator comparator = Comparator.getFromID(ldt);
                    Provider pl = (Provider)context.deserialize((JsonElement)ol, tl);
                    Provider pr = (Provider)context.deserialize((JsonElement)or, tr);
                    Provider pt = (Provider)context.deserialize((JsonElement)ot, tt);
                    Provider pf = (Provider)context.deserialize((JsonElement)of, tf);
                    return new IfElseProvider.FluidTag(comparator, pl, ro, pr, pt, pf);
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }
    };

    private static boolean hasAllRequired(JsonObject jo) {
        return jo.has(LEFT_IDENTIFIER) && jo.has(RIGHT_IDENTIFIER) && jo.has(OPERATOR_IDENTIFIER) && jo.has(TRUE_IDENTIFIER) && jo.has(FALSE_IDENTIFIER);
    }
}

