/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.provider.deserializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.valkyrieofnight.vlib.core.io.json.JsonUtils;
import com.valkyrieofnight.vlib.core.obj.base.IProvideID;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Function2a;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.ingredient.block.BlockIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.block.BlockProviderIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.block.BlockTagIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.fluid.FluidIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.fluid.FluidProviderIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.fluid.FluidStackIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.fluid.FluidStackProviderIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.fluid.FluidTagIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.item.ItemIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.item.ItemProviderIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.item.ItemStackIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.item.ItemStackProviderIngredient;
import com.valkyrieofnight.vlib.registry.ingredient.item.ItemTagIngredient;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializer;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializerRegistry;
import com.valkyrieofnight.vlib.registry.provider.value.RawValueProvider;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;

public class DeserializerUtils {
    public static Type getDeserializerTypeFromObject(JsonObject obj) throws Exception {
        Set all = obj.entrySet();
        for (Map.Entry me : all) {
            String str = (String)me.getKey();
            if (!ProviderDeserializerRegistry.getInstance().hasDeserializer(str)) continue;
            return ProviderDeserializerRegistry.getInstance().getType(str);
        }
        throw new Exception("Could not find type for Deserializer Type");
    }

    public static String getReturnDataType(String type) throws Exception {
        String[] split;
        if (!StringUtils.isNullOrEmpty(type) && (split = type.split(":")).length > 1) {
            return split[1];
        }
        throw new Exception("No data type found from type: " + type);
    }

    public static String getTypeIdentifierFromProvider(Provider<?> provider) {
        if (provider == null) {
            return null;
        }
        return ProviderDeserializerRegistry.getInstance().getTypeIdentifier(provider.getClass());
    }

    public static void writeProviderToPacket(Provider<?> provider, PacketBuffer buffer) {
        buffer.func_180714_a(DeserializerUtils.getTypeIdentifierFromProvider(provider));
        provider.writePacketData(buffer);
    }

    public static Provider readProviderFromPacket(PacketBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        ProviderDeserializer ppd = ProviderDeserializerRegistry.getInstance().getFromType(buffer.func_218666_n());
        return ppd != null ? (Provider)ppd.createFromPacket(buffer) : null;
    }

    public static Ingredient<ItemStack> getAnyItemIngredient(JsonObject jo, JsonDeserializationContext context) {
        return DeserializerUtils.getLimitedItemIngredient(jo, context, DeserializerUtils::getRawItemIngredient, DeserializerUtils::getProviderItemIngredient);
    }

    public static Ingredient<ItemStack> getRawItemIngredient(JsonObject jo, JsonDeserializationContext context) {
        return DeserializerUtils.getLimitedItemIngredient(jo, context, DeserializerUtils::getItemIngredient, DeserializerUtils::getItemStackIngredient, DeserializerUtils::getItemTagIngredient);
    }

    public static Ingredient<ItemStack> getLimitedItemIngredient(JsonObject jo, JsonDeserializationContext context, Function2a<JsonObject, JsonDeserializationContext, Ingredient<ItemStack>> ... getters) {
        for (Function2a<JsonObject, JsonDeserializationContext, Ingredient<ItemStack>> getter : getters) {
            Ingredient<ItemStack> ingredient = getter.execute(jo, context);
            if (ingredient == null) continue;
            return ingredient;
        }
        return null;
    }

    public static Ingredient<ItemStack> getProviderItemIngredient(JsonObject jo, JsonDeserializationContext context) {
        return DeserializerUtils.getLimitedItemIngredient(jo, context, DeserializerUtils::getItemProviderIngredient, DeserializerUtils::getItemStackProviderIngredient);
    }

    public static ItemIngredient getItemIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            String typeIdentifier = "raw:item";
            Type t = ProviderDeserializerRegistry.getInstance().getType(typeIdentifier);
            if (t == null) {
                return null;
            }
            Provider provider = (Provider)context.deserialize((JsonElement)jo, t);
            int count = JsonUtils.getAsIntOrDefault(jo, "count", 1);
            if (provider != null && provider.isValid()) {
                return new ItemIngredient((Item)provider.request(null), count);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ItemStackIngredient getItemStackIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            String typeIdentifier = "raw:itemstack";
            Type t = ProviderDeserializerRegistry.getInstance().getType(typeIdentifier);
            if (t == null) {
                return null;
            }
            Provider provider = (Provider)context.deserialize((JsonElement)jo, t);
            boolean matchNBT = JsonUtils.getAsBooleanOrDefault(jo, "match_nbt", false);
            int count = JsonUtils.getAsIntOrDefault(jo, "count", 1);
            if (provider != null && provider.isValid()) {
                return new ItemStackIngredient((ItemStack)provider.request(null), count, matchNBT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ItemProviderIngredient getItemProviderIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            Type t = DeserializerUtils.getDeserializerTypeFromObject(jo);
            if (t == null) {
                return null;
            }
            Provider provider = t != null ? (Provider)context.deserialize((JsonElement)jo, t) : null;
            RawValueProvider.Int count = null;
            try {
                count = DeserializerUtils.getProvider(jo, "count", "int", context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (provider != null) {
                return new ItemProviderIngredient(provider, count != null ? count : new RawValueProvider.Int(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ItemTagIngredient getItemTagIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            String typeIdentifier = "raw:item_tag";
            Type t = ProviderDeserializerRegistry.getInstance().getType(typeIdentifier);
            if (t == null) {
                return null;
            }
            Provider provider = t != null ? (Provider)context.deserialize((JsonElement)jo, t) : null;
            int count = JsonUtils.getAsIntOrDefault(jo, "count", 1);
            if (provider instanceof IProvideID && ((IProvideID)((Object)provider)).getID() != null) {
                JsonObject so = JsonUtils.getAsJsonObject(jo, "selector");
                if (so != null) {
                    String type = JsonUtils.getAsStringOrDefault(so, "type", "all");
                    String[] props = JsonUtils.getAsStringArrayOrDefault(so, "values", new String[0]);
                    if (props.length > 0) {
                        return new ItemTagIngredient(((IProvideID)((Object)provider)).getID(), count, Ingredient.TagIngredientType.getFromNameOrDefault(type, Ingredient.TagIngredientType.ALL), props);
                    }
                    return new ItemTagIngredient(((IProvideID)((Object)provider)).getID(), count, Ingredient.TagIngredientType.getFromNameOrDefault(type, Ingredient.TagIngredientType.ALL));
                }
                return new ItemTagIngredient(((IProvideID)((Object)provider)).getID(), count, Ingredient.TagIngredientType.ALL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ItemStackProviderIngredient getItemStackProviderIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            Type t = DeserializerUtils.getDeserializerTypeFromObject(jo);
            if (t == null) {
                return null;
            }
            Provider provider = t != null ? (Provider)context.deserialize((JsonElement)jo, t) : null;
            RawValueProvider.Int count = DeserializerUtils.getProvider(jo, "count", "int", context);
            boolean matchNBT = JsonUtils.getAsBooleanOrDefault(jo, "match_nbt", false);
            if (provider != null && provider.isValid()) {
                return new ItemStackProviderIngredient(provider, count != null ? count : new RawValueProvider.Int(1), matchNBT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Ingredient<FluidStack> getAnyFluidIngredient(JsonObject jo, JsonDeserializationContext context) {
        return DeserializerUtils.getLimitedFluidIngredient(jo, context, DeserializerUtils::getRawFluidIngredient, DeserializerUtils::getProviderFluidIngredient);
    }

    public static Ingredient<FluidStack> getRawFluidIngredient(JsonObject jo, JsonDeserializationContext context) {
        return DeserializerUtils.getLimitedFluidIngredient(jo, context, DeserializerUtils::getFluidIngredient, DeserializerUtils::getFluidStackIngredient, DeserializerUtils::getFluidTagIngredient);
    }

    public static Ingredient<FluidStack> getProviderFluidIngredient(JsonObject jo, JsonDeserializationContext context) {
        return DeserializerUtils.getLimitedFluidIngredient(jo, context, DeserializerUtils::getFluidProviderIngredient, DeserializerUtils::getFluidStackProviderIngredient);
    }

    public static Ingredient<FluidStack> getLimitedFluidIngredient(JsonObject jo, JsonDeserializationContext context, Function2a<JsonObject, JsonDeserializationContext, Ingredient<FluidStack>> ... getters) {
        for (Function2a<JsonObject, JsonDeserializationContext, Ingredient<FluidStack>> getter : getters) {
            Ingredient<FluidStack> ingredient = getter.execute(jo, context);
            if (ingredient == null) continue;
            return ingredient;
        }
        return null;
    }

    public static FluidIngredient getFluidIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            String typeID = "raw:fluid";
            Type t = ProviderDeserializerRegistry.getInstance().getType(typeID);
            if (t == null) {
                return null;
            }
            Provider provider = (Provider)context.deserialize((JsonElement)jo, t);
            int amount = JsonUtils.getAsIntOrDefault(jo, "amount", 1);
            if (provider != null && provider.isValid()) {
                return new FluidIngredient((Fluid)provider.request(null), amount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static FluidTagIngredient getFluidTagIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            String typeIdentifier = "raw:fluid_tag";
            Type t = ProviderDeserializerRegistry.getInstance().getType(typeIdentifier);
            if (t == null) {
                return null;
            }
            Provider provider = t != null ? (Provider)context.deserialize((JsonElement)jo, t) : null;
            int amount = JsonUtils.getAsIntOrDefault(jo, "amount", 1);
            if (provider instanceof IProvideID && ((IProvideID)((Object)provider)).getID() != null) {
                JsonObject so = JsonUtils.getAsJsonObject(jo, "selector");
                if (so != null) {
                    String type = JsonUtils.getAsStringOrDefault(so, "type", "all");
                    String[] props = JsonUtils.getAsStringArrayOrDefault(so, "values", new String[0]);
                    if (props.length > 0) {
                        return new FluidTagIngredient(((IProvideID)((Object)provider)).getID(), amount, Ingredient.TagIngredientType.getFromNameOrDefault(type, Ingredient.TagIngredientType.ALL), props);
                    }
                    return new FluidTagIngredient(((IProvideID)((Object)provider)).getID(), amount, Ingredient.TagIngredientType.getFromNameOrDefault(type, Ingredient.TagIngredientType.ALL));
                }
                return new FluidTagIngredient(((IProvideID)((Object)provider)).getID(), amount, Ingredient.TagIngredientType.ALL);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static FluidStackIngredient getFluidStackIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            String typeIdentifier = "raw:fluidstack";
            Type t = ProviderDeserializerRegistry.getInstance().getType(typeIdentifier);
            if (t == null) {
                return null;
            }
            Provider provider = (Provider)context.deserialize((JsonElement)jo, t);
            boolean matchNBT = JsonUtils.getAsBooleanOrDefault(jo, "match_nbt", false);
            int amount = JsonUtils.getAsIntOrDefault(jo, "amount", 1);
            if (provider != null && provider.isValid()) {
                return new FluidStackIngredient((FluidStack)provider.request(null), amount, matchNBT);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static FluidProviderIngredient getFluidProviderIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            Type t = DeserializerUtils.getDeserializerTypeFromObject(jo);
            Provider provider = t != null ? (Provider)context.deserialize((JsonElement)jo, t) : null;
            RawValueProvider.Int amount = DeserializerUtils.getProvider(jo, "amount", "int", context);
            if (provider != null && provider.isValid()) {
                return new FluidProviderIngredient(provider, amount != null ? amount : new RawValueProvider.Int(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Ingredient<Block> getRawBlockIngredient(JsonObject jo, JsonDeserializationContext context) {
        return DeserializerUtils.getLimitedBlockIngredient(jo, context, DeserializerUtils::getBlockIngredient, DeserializerUtils::getBlockTagIngredient);
    }

    public static Ingredient<Block> getLimitedBlockIngredient(JsonObject jo, JsonDeserializationContext context, Function2a<JsonObject, JsonDeserializationContext, Ingredient<Block>> ... getters) {
        for (Function2a<JsonObject, JsonDeserializationContext, Ingredient<Block>> getter : getters) {
            Ingredient<Block> ingredient = getter.execute(jo, context);
            if (ingredient == null) continue;
            return ingredient;
        }
        return null;
    }

    public static BlockIngredient getBlockIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            String typeIdentifier = "raw:block";
            Type t = ProviderDeserializerRegistry.getInstance().getType(typeIdentifier);
            if (t == null) {
                return null;
            }
            Provider provider = (Provider)context.deserialize((JsonElement)jo, t);
            if (provider != null && provider.isValid()) {
                return new BlockIngredient((Block)provider.request(null));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static BlockTagIngredient getBlockTagIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            JsonObject so;
            String typeIdentifier = "raw:block_tag";
            Type t = ProviderDeserializerRegistry.getInstance().getType(typeIdentifier);
            if (t == null) {
                return null;
            }
            Provider provider = t != null ? (Provider)context.deserialize((JsonElement)jo, t) : null;
            String selector = JsonUtils.getAsStringOrDefault(jo, "selector", "first");
            if (provider instanceof IProvideID && ((IProvideID)((Object)provider)).getID() != null && (so = JsonUtils.getAsJsonObject(jo, "selector")) != null) {
                String type = JsonUtils.getAsStringOrDefault(so, "type", "first");
                String[] props = JsonUtils.getAsStringArrayOrDefault(so, "values", new String[0]);
                if (props.length > 0) {
                    return new BlockTagIngredient(((IProvideID)((Object)provider)).getID(), Ingredient.TagIngredientType.getFromNameOrDefault(type, Ingredient.TagIngredientType.FIRST), props);
                }
                return new BlockTagIngredient(((IProvideID)((Object)provider)).getID(), Ingredient.TagIngredientType.getFromNameOrDefault(type, Ingredient.TagIngredientType.FIRST));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static BlockProviderIngredient getBlockProviderIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            Provider provider;
            Type t = DeserializerUtils.getDeserializerTypeFromObject(jo);
            if (t == null) {
                return null;
            }
            Provider provider2 = provider = t != null ? (Provider)context.deserialize((JsonElement)jo, t) : null;
            if (provider != null) {
                return new BlockProviderIngredient(provider);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static FluidStackProviderIngredient getFluidStackProviderIngredient(JsonObject jo, JsonDeserializationContext context) {
        try {
            Type t = DeserializerUtils.getDeserializerTypeFromObject(jo);
            Provider provider = t != null ? (Provider)context.deserialize((JsonElement)jo, t) : null;
            RawValueProvider.Int amount = null;
            try {
                amount = DeserializerUtils.getProvider(jo, "amount", "int", context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean matchNBT = JsonUtils.getAsBooleanOrDefault(jo, "match_nbt", false);
            return provider == null ? null : new FluidStackProviderIngredient(provider, amount != null ? amount : new RawValueProvider.Int(1), matchNBT);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> Provider<T> getProvider(JsonObject jo, String dataType, JsonDeserializationContext context) {
        try {
            Type t = DeserializerUtils.getDeserializerTypeFromObject(jo);
            String dt = ProviderDeserializerRegistry.getInstance().getDataReturnType(t);
            if (!StringUtils.isNullOrEmpty(dt) && dataType.equals(dt)) {
                return t != null ? (Provider)context.deserialize((JsonElement)jo, t) : null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Provider<?> getProvider(JsonObject jo, String child, String dataType, JsonDeserializationContext context) {
        JsonObject joc = JsonUtils.getAsJsonObject(jo, child);
        try {
            Type t = DeserializerUtils.getDeserializerTypeFromObject(joc);
            String dt = ProviderDeserializerRegistry.getInstance().getDataReturnType(t);
            if (!StringUtils.isNullOrEmpty(dt) && dataType.equals(dt)) {
                return t != null ? (Provider)context.deserialize((JsonElement)joc, t) : null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

