/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.integration.jei;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.client.ClientUtil;
import com.valkyrieofnight.vlib.integration.jei.category.VLJEIRecipeCategory;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionDataContainerHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.util.ResourceLocation;

public class VLJEIRecipeManager
implements IRecipeManagerPlugin {
    protected ConditionContainerProvider ccp;
    protected Map<ResourceLocation, VLJEIRecipeCategory> categoryMap = Maps.newHashMap();
    protected List<VLJEIRecipeCategory> categories = Lists.newArrayList();

    public VLJEIRecipeManager() {
        this.ccp = ConditionDataContainerHandler.getInstance().getProvider(ClientUtil::getCurrentDim, ClientUtil::getPlayerID);
    }

    public void addCategory(VLJEIRecipeCategory recipeCategory) {
        if (recipeCategory == null || this.categoryMap.containsKey(recipeCategory.getUid())) {
            return;
        }
        this.categoryMap.put(recipeCategory.getUid(), recipeCategory);
        this.categories.add(recipeCategory);
    }

    public final <V> List<ResourceLocation> getRecipeCategoryUids(IFocus<V> iFocus) {
        ArrayList cats = Lists.newArrayList();
        if (iFocus.getMode() == IFocus.Mode.INPUT || iFocus.getMode() == null) {
            for (VLJEIRecipeCategory cat : this.categories) {
                if (!cat.getRegistry().hasRecipeWithInput(cat.getRegistryID(), this.ccp, iFocus.getValue())) continue;
                cats.add(cat.getUid());
            }
        } else {
            for (VLJEIRecipeCategory cat : this.categories) {
                if (!cat.getRegistry().hasRecipeWithOutput(cat.getRegistryID(), this.ccp, iFocus.getValue())) continue;
                cats.add(cat.getUid());
            }
        }
        return cats;
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> iRecipeCategory, IFocus<V> iFocus) {
        if (this.categoryMap.containsKey(iRecipeCategory.getUid())) {
            VLJEIRecipeCategory cat = (VLJEIRecipeCategory)iRecipeCategory;
            List recipes = iFocus.getMode() == IFocus.Mode.INPUT || iFocus.getMode() == null ? (List)cat.getRegistry().getRecipesWithInput(cat.getRegistryID(), this.ccp, iFocus.getValue()) : (List)cat.getRegistry().getRecipesWithOutput(cat.getRegistryID(), this.ccp, iFocus.getValue());
            if (recipes != null && recipes.size() > 0) {
                return recipes;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public final <T> List<T> getRecipes(IRecipeCategory<T> iRecipeCategory) {
        List recipes;
        if (this.categoryMap.containsKey(iRecipeCategory.getUid()) && (recipes = ((VLJEIRecipeCategory)iRecipeCategory).getAllRecipes()) != null && recipes.size() > 0) {
            return recipes;
        }
        return Collections.EMPTY_LIST;
    }
}

