/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.integration.forge.energy;

import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.integration.forge.energy.IVLEnergyStorage;
import net.minecraft.nbt.CompoundNBT;

public class VLMaxTransferBattery
implements IVLEnergyStorage {
    protected final IOMode mode;
    protected int capacity;
    protected int stored = 0;

    public VLMaxTransferBattery(int capacity, IOMode mode) {
        this.capacity = capacity;
        this.mode = mode;
    }

    @Override
    public IOMode getIOMode() {
        return this.mode;
    }

    @Override
    public int receiveEnergyForced(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.stored, Math.min(this.capacity, maxReceive));
        if (!simulate) {
            this.stored += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int extractEnergyForced(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.stored, Math.min(this.capacity, maxExtract));
        if (!simulate) {
            this.stored -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.stored;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public CompoundNBT serializeNBT() {
        return NBTBuilder.create().putInt("capacity", this.capacity).putInt("stored", this.stored).build();
    }

    @Override
    public void deserializeNBT(CompoundNBT compoundNBT) {
        if (compoundNBT.func_74764_b("capacity")) {
            this.capacity = compoundNBT.func_74762_e("capacity");
        }
        if (compoundNBT.func_74764_b("stored")) {
            this.stored = compoundNBT.func_74762_e("stored");
        }
    }

    public int getEnergyRoom() {
        return this.capacity - this.stored;
    }
}

