/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.math;

import net.minecraft.util.Direction;

public enum XYZDirection {
    POS_X(0, 3, Direction.EAST),
    POS_Y(1, 4, Direction.UP),
    POS_Z(2, 5, Direction.SOUTH),
    NEG_X(3, 0, Direction.WEST),
    NEG_Y(4, 1, Direction.DOWN),
    NEG_Z(5, 2, Direction.NORTH);

    private final int id;
    private final int idOpposite;
    private final Direction direction;
    private static final XYZDirection[] ALL;

    private XYZDirection(int id, int opposite, Direction direction) {
        this.id = id;
        this.idOpposite = opposite;
        this.direction = direction;
    }

    public XYZDirection getOpposite() {
        return XYZDirection.getByID(this.idOpposite);
    }

    public int getID() {
        return this.id;
    }

    public Direction getAsDirection() {
        return this.direction;
    }

    public static XYZDirection getByID(int id) {
        return ALL[id % ALL.length];
    }

    public static XYZDirection getFromDirection(Direction direction) {
        for (XYZDirection xyz : ALL) {
            if (xyz.direction != direction) continue;
            return xyz;
        }
        return POS_X;
    }

    static {
        ALL = new XYZDirection[]{POS_X, POS_Y, POS_Z, NEG_X, NEG_Y, NEG_Z};
    }
}

