/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.math;

import java.util.List;
import java.util.Random;
import net.minecraft.util.Util;

public class WeightedRandom {
    public static int getTotalWeight(List<? extends Item> collection) {
        int i = 0;
        int k = collection.size();
        for (int j = 0; j < k; ++j) {
            Item item = collection.get(j);
            i += item.getWeight();
        }
        return i;
    }

    public static <T extends Item> T getRandomItem(Random random, List<T> collection, int totalWeight) {
        if (totalWeight <= 0) {
            throw (IllegalArgumentException)Util.func_229757_c_((Throwable)new IllegalArgumentException());
        }
        int i = random.nextInt(totalWeight);
        return WeightedRandom.getRandomItem(collection, i);
    }

    public static <T extends Item> T getRandomItem(List<T> collection, int weight) {
        int j = collection.size();
        for (int i = 0; i < j; ++i) {
            Item t = (Item)collection.get(i);
            if ((weight -= t.getWeight()) >= 0) continue;
            return (T)t;
        }
        return (T)((Item)null);
    }

    public static <T extends Item> T getRandomItem(Random random, List<T> collection) {
        return WeightedRandom.getRandomItem(random, collection, WeightedRandom.getTotalWeight(collection));
    }

    public static abstract class Item {
        public abstract int getWeight();
    }
}

