/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.math;

public final class IntRange {
    public static final IntRange EMPTY = new IntRange(-1, -1);
    private final int start;
    private final int end;

    public IntRange(int start, int end) {
        if (start > end) {
            this.start = end;
            this.end = start;
            throw new RuntimeException("Start and End values had to be flipped because Start value was larger than the end value");
        }
        this.start = start;
        this.end = end;
    }

    public boolean isInRange(int n) {
        return n >= this.start && n < this.end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getPosition(int i) {
        return i - this.start;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public String toString() {
        return "(" + this.start + "-" + this.end + ")";
    }
}

