/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.math;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import java.util.Map;
import net.minecraft.util.Direction;

public class FacingUtils {
    private static Map<RelativeDirection, Direction> NORTH = Maps.newHashMap();
    private static Map<RelativeDirection, Direction> SOUTH;
    private static Map<RelativeDirection, Direction> EAST;
    private static Map<RelativeDirection, Direction> WEST;
    private static Map<Direction, Map<RelativeDirection, Direction>> HORIZONTALS;
    private static Map<Direction, Direction[]> FACING_PERPENDICULARS;

    public static Direction getHorizontalRelative(Direction facing, RelativeDirection relativeDirection) {
        Map<RelativeDirection, Direction> dm = HORIZONTALS.containsKey(facing) ? HORIZONTALS.get(facing) : null;
        return dm != null ? dm.get((Object)relativeDirection) : null;
    }

    public static RelativeDirection getRelativeFrom(Direction facing, Direction other) {
        Map<RelativeDirection, Direction> dm;
        if (other == Direction.DOWN) {
            return RelativeDirection.DOWN;
        }
        if (other == Direction.UP) {
            return RelativeDirection.UP;
        }
        Map<RelativeDirection, Direction> map = dm = HORIZONTALS.containsKey(facing) ? HORIZONTALS.get(facing) : null;
        if (dm != null) {
            for (RelativeDirection rd : dm.keySet()) {
                Direction d = dm.get((Object)rd);
                if (other != d) continue;
                return rd;
            }
        }
        return null;
    }

    public static Direction[] getPerpendiculars(@NotNull Direction direction) {
        return FACING_PERPENDICULARS.get(direction);
    }

    static {
        NORTH.put(RelativeDirection.UP, Direction.UP);
        NORTH.put(RelativeDirection.DOWN, Direction.DOWN);
        NORTH.put(RelativeDirection.LEFT, Direction.WEST);
        NORTH.put(RelativeDirection.RIGHT, Direction.EAST);
        NORTH.put(RelativeDirection.FORWARD, Direction.NORTH);
        NORTH.put(RelativeDirection.BACKWARD, Direction.SOUTH);
        SOUTH = Maps.newHashMap();
        SOUTH.put(RelativeDirection.UP, Direction.UP);
        SOUTH.put(RelativeDirection.DOWN, Direction.DOWN);
        SOUTH.put(RelativeDirection.LEFT, Direction.EAST);
        SOUTH.put(RelativeDirection.RIGHT, Direction.WEST);
        SOUTH.put(RelativeDirection.FORWARD, Direction.SOUTH);
        SOUTH.put(RelativeDirection.BACKWARD, Direction.NORTH);
        EAST = Maps.newHashMap();
        EAST.put(RelativeDirection.UP, Direction.UP);
        EAST.put(RelativeDirection.DOWN, Direction.DOWN);
        EAST.put(RelativeDirection.LEFT, Direction.NORTH);
        EAST.put(RelativeDirection.RIGHT, Direction.SOUTH);
        EAST.put(RelativeDirection.FORWARD, Direction.EAST);
        EAST.put(RelativeDirection.BACKWARD, Direction.WEST);
        WEST = Maps.newHashMap();
        WEST.put(RelativeDirection.UP, Direction.UP);
        WEST.put(RelativeDirection.DOWN, Direction.DOWN);
        WEST.put(RelativeDirection.LEFT, Direction.SOUTH);
        WEST.put(RelativeDirection.RIGHT, Direction.NORTH);
        WEST.put(RelativeDirection.FORWARD, Direction.WEST);
        WEST.put(RelativeDirection.BACKWARD, Direction.EAST);
        HORIZONTALS = Maps.newHashMap();
        HORIZONTALS.put(Direction.NORTH, NORTH);
        HORIZONTALS.put(Direction.SOUTH, SOUTH);
        HORIZONTALS.put(Direction.EAST, EAST);
        HORIZONTALS.put(Direction.WEST, WEST);
        FACING_PERPENDICULARS = Maps.newHashMap();
        Direction[] UP_DOWN = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        Direction[] EAST_WEST = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH};
        Direction[] NORTH_SOUTH = new Direction[]{Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST};
        FACING_PERPENDICULARS.put(Direction.DOWN, UP_DOWN);
        FACING_PERPENDICULARS.put(Direction.UP, UP_DOWN);
        FACING_PERPENDICULARS.put(Direction.NORTH, NORTH_SOUTH);
        FACING_PERPENDICULARS.put(Direction.SOUTH, NORTH_SOUTH);
        FACING_PERPENDICULARS.put(Direction.WEST, EAST_WEST);
        FACING_PERPENDICULARS.put(Direction.EAST, EAST_WEST);
    }
}

