/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiSizable;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import net.minecraft.client.gui.screen.Screen;

public final class GuiSizableBox
extends GuiSizable {
    protected GuiSizableBox(VLID tex, int unitCornerX, int unitCornerY, int unitMiddleX, int unitMiddleY, boolean middleRepeatable, int textureWidth, int textureHeight) {
        super(tex, unitCornerX, unitCornerY, unitMiddleX, unitMiddleY, middleRepeatable, textureWidth, textureHeight);
    }

    @Override
    public void render(IElementContainer gui, MatrixStack matrixStack, Color4 color, int x, int y, int w, int h) {
        GuiUtils.bindTexture(this.getResourceLocation());
        int middleW = w - 2 * this.getUnitCornerX();
        int middleH = h - 2 * this.getUnitCornerY();
        int x0 = x;
        int x1 = x + this.getUnitCornerX();
        int x2 = x + (w - this.getUnitCornerX());
        int y0 = y;
        int y1 = y + this.getUnitCornerY();
        int y2 = y + (h - this.getUnitCornerY());
        Screen guic = gui.getGui();
        GuiTexture topl = this.getGuiTexture(GuiSizable.SizableLocation.TOP_LEFT);
        GuiUtils.drawTexturedRect(matrixStack, color, x0, y0, (float)topl.startX, (float)topl.startY, topl.width, topl.height, topl.getTexW(), topl.getTexH());
        GuiTexture topr = this.getGuiTexture(GuiSizable.SizableLocation.TOP_RIGHT);
        GuiUtils.drawTexturedRect(matrixStack, color, x2, y0, (float)topr.startX, (float)topr.startY, topr.width, topr.height, topr.getTexW(), topr.getTexH());
        GuiTexture botl = this.getGuiTexture(GuiSizable.SizableLocation.BOT_LEFT);
        GuiUtils.drawTexturedRect(matrixStack, color, x0, y2, (float)botl.startX, (float)botl.startY, botl.width, botl.height, botl.getTexW(), botl.getTexH());
        GuiTexture botr = this.getGuiTexture(GuiSizable.SizableLocation.BOT_RIGHT);
        GuiUtils.drawTexturedRect(matrixStack, color, x2, y2, (float)botr.startX, (float)botr.startY, botr.width, botr.height, botr.getTexW(), botr.getTexH());
        if (this.getMiddleRepeatable()) {
            this.drawRepeatedMiddle(matrixStack, color, middleW, middleH, y0, y1, y2, x0, x1, x2);
        } else {
            this.drawStretchedMiddle(matrixStack, color, middleW, middleH, y0, y1, y2, x0, x1, x2);
        }
    }

    private void drawRepeatedMiddle(MatrixStack matrixStack, Color4 color, int middleW, int middleH, int tsy, int msy, int bsy, int lsx, int msx, int rsx) {
        GuiTexture topm = this.getGuiTexture(GuiSizable.SizableLocation.TOP_MID);
        GuiUtils.drawTexturedRectRepeat(matrixStack, color, msx, tsy, topm.startX, topm.startY, topm.width, topm.height, middleW, this.getUnitCornerY(), topm.getTexW(), topm.getTexH());
        GuiTexture midl = this.getGuiTexture(GuiSizable.SizableLocation.MID_LEFT);
        GuiUtils.drawTexturedRectRepeat(matrixStack, color, lsx, msy, midl.startX, midl.startY, midl.width, midl.height, this.getUnitCornerX(), middleH, midl.getTexW(), midl.getTexH());
        GuiTexture midm = this.getGuiTexture(GuiSizable.SizableLocation.MID);
        GuiUtils.drawTexturedRectRepeat(matrixStack, color, msx, msy, midm.startX, midm.startY, midm.width, midm.height, middleW, middleH, midm.getTexW(), midm.getTexH());
        GuiTexture midr = this.getGuiTexture(GuiSizable.SizableLocation.MID_RIGHT);
        GuiUtils.drawTexturedRectRepeat(matrixStack, color, rsx, msy, midr.startX, midr.startY, midr.width, midr.height, this.getUnitCornerX(), middleH, midr.getTexW(), midr.getTexH());
        GuiTexture botm = this.getGuiTexture(GuiSizable.SizableLocation.BOT_MID);
        GuiUtils.drawTexturedRectRepeat(matrixStack, color, msx, bsy, botm.startX, botm.startY, botm.width, botm.height, middleW, this.getUnitCornerY(), botm.getTexW(), botm.getTexH());
    }

    private void drawStretchedMiddle(MatrixStack matrixStack, Color4 color, int middleW, int middleH, int tsy, int msy, int bsy, int lsx, int msx, int rsx) {
        GuiTexture topm = this.getGuiTexture(GuiSizable.SizableLocation.TOP_MID);
        GuiUtils.drawTexturedRect(matrixStack, color, msx, tsy, topm.startX, topm.startY, topm.width, topm.height, middleW, this.getUnitCornerY(), topm.getTexW(), topm.getTexH());
        GuiTexture midl = this.getGuiTexture(GuiSizable.SizableLocation.MID_LEFT);
        GuiUtils.drawTexturedRect(matrixStack, color, lsx, msy, midl.startX, midl.startY, midl.width, midl.height, this.getUnitCornerX(), middleH, midl.getTexW(), midl.getTexH());
        GuiTexture midm = this.getGuiTexture(GuiSizable.SizableLocation.MID);
        GuiUtils.drawTexturedRect(matrixStack, color, msx, msy, midm.startX, midm.startY, midm.width, midm.height, middleW, middleH, midm.getTexW(), midm.getTexH());
        GuiTexture midr = this.getGuiTexture(GuiSizable.SizableLocation.MID_RIGHT);
        GuiUtils.drawTexturedRect(matrixStack, color, rsx, msy, midr.startX, midr.startY, midr.width, midr.height, this.getUnitCornerX(), middleH, midr.getTexW(), midr.getTexH());
        GuiTexture botm = this.getGuiTexture(GuiSizable.SizableLocation.BOT_MID);
        GuiUtils.drawTexturedRect(matrixStack, color, msx, bsy, botm.startX, botm.startY, botm.width, botm.height, middleW, this.getUnitCornerY(), botm.getTexW(), botm.getTexH());
    }

    public static GuiSizableBox create(VLID loc, int x, int y, int uw, int uh) {
        return GuiSizableBox.addParts(new GuiSizableBox(loc, uw, uh, uw, uh, false, 256, 256), x, y);
    }

    public static GuiSizableBox create(VLID loc, int x, int y, int uw, int uh, int textureWidth, int textureHeight) {
        return GuiSizableBox.addParts(new GuiSizableBox(loc, uw, uh, uw, uh, false, textureWidth, textureHeight), x, y);
    }

    public static GuiSizableBox create(VLID loc, int textureX, int textureY, int unitCornerX, int unitCornerY, int unitMiddleX, int unitMiddleY, boolean middleRepeatable) {
        return GuiSizableBox.addParts(new GuiSizableBox(loc, unitCornerX, unitCornerY, unitMiddleX, unitMiddleY, middleRepeatable, 256, 256), textureX, textureY);
    }

    public static GuiSizableBox create(VLID loc, int textureX, int textureY, int unitCornerX, int unitCornerY, int unitMiddleX, int unitMiddleY, boolean middleRepeatable, int textureWidth, int textureHeight) {
        return GuiSizableBox.addParts(new GuiSizableBox(loc, unitCornerX, unitCornerY, unitMiddleX, unitMiddleY, middleRepeatable, textureWidth, textureHeight), textureX, textureY);
    }

    private static GuiSizableBox addParts(GuiSizableBox sizableBox, int textureX, int textureY) {
        VLID loc = sizableBox.getResourceLocation();
        int x0 = textureX;
        int x1 = x0 + sizableBox.getUnitCornerX();
        int x2 = x1 + sizableBox.getUnitMiddleX();
        int x3 = x2 + sizableBox.getUnitCornerX();
        int y0 = textureY;
        int y1 = y0 + sizableBox.getUnitCornerY();
        int y2 = y1 + sizableBox.getUnitMiddleY();
        int y3 = y2 + sizableBox.getUnitCornerY();
        int tw = sizableBox.textureWidth;
        int th = sizableBox.textureHeight;
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.TOP_LEFT, new GuiTexture(loc, x0, y0, x1, y1, tw, th));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.TOP_MID, new GuiTexture(loc, x1, y0, x2, y1, tw, th));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.TOP_RIGHT, new GuiTexture(loc, x2, y0, x3, y1, tw, th));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.MID_LEFT, new GuiTexture(loc, x0, y1, x1, y2, tw, th));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.MID, new GuiTexture(loc, x1, y1, x2, y2, tw, th));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.MID_RIGHT, new GuiTexture(loc, x2, y1, x3, y2, tw, th));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.BOT_LEFT, new GuiTexture(loc, x0, y2, x1, y3, tw, th));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.BOT_MID, new GuiTexture(loc, x1, y2, x2, y3, tw, th));
        sizableBox.setGuiTexture(GuiSizable.SizableLocation.BOT_RIGHT, new GuiTexture(loc, x2, y2, x3, y3, tw, th));
        return sizableBox;
    }

    public static enum BoxLocation {
        TOP_LEFT(0, 0),
        TOP_MID(0, 1),
        TOP_RIGHT(0, 2),
        MID_LEFT(1, 0),
        MID(1, 1),
        MID_RIGHT(1, 2),
        BOT_LEFT(2, 0),
        BOT_MID(2, 1),
        BOT_RIGHT(2, 2);

        public int x;
        public int y;

        private BoxLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

