/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.renderer.RenderUtils;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementThemeListener;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.container.InputSlot;
import com.valkyrieofnight.vlib.core.ui.container.ModifierSlot;
import com.valkyrieofnight.vlib.core.ui.container.OutputSlot;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.nbt.CompoundNBT;

public class SlotsArrayElement
extends VLElement
implements IElementDraw,
IElementThemeListener {
    protected AssetID slot;
    protected AssetID slotInput;
    protected AssetID slotOutput;
    protected AssetID slotUpgrade;
    protected GuiTexture slotTex;
    protected GuiTexture slotInputTex;
    protected GuiTexture slotOutputTex;
    protected GuiTexture slotUpgradeTex;
    protected Container container;

    public SlotsArrayElement(String id, Container container, AssetID slot) {
        super(id);
        this.container = container;
        this.slot = slot;
        this.slotInput = slot;
        this.slotOutput = slot;
        this.slotUpgrade = slot;
    }

    @Override
    public void load(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public int getSizeX() {
        int sx = Integer.MAX_VALUE;
        int lx = 0;
        for (Slot slot : this.container.field_75151_b) {
            if (slot.field_75223_e < sx) {
                sx = slot.field_75223_e;
                continue;
            }
            if (slot.field_75223_e <= lx) continue;
            lx = slot.field_75223_e;
        }
        return lx - sx;
    }

    @Override
    public int getSizeY() {
        int sy = Integer.MAX_VALUE;
        int ly = 0;
        for (Slot slot : this.container.field_75151_b) {
            if (slot.field_75221_f < sy) {
                sy = slot.field_75221_f;
                continue;
            }
            if (slot.field_75221_f <= ly) continue;
            ly = slot.field_75221_f;
        }
        return ly - sy;
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        RenderUtils.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        for (Slot s : this.container.field_75151_b) {
            int x = this.getActualX() + s.field_75223_e - 1;
            int y = this.getActualY() + s.field_75221_f - 1;
            IElementContainer container = this.getContainer();
            if (s instanceof InputSlot) {
                GuiUtils.renderTexture((AbstractGui)this.getContainer().getGui(), matrixStack, this.slotInputTex, container, x, y);
                continue;
            }
            if (s instanceof OutputSlot) {
                GuiUtils.renderTexture((AbstractGui)this.getContainer().getGui(), matrixStack, this.slotOutputTex, container, x, y);
                continue;
            }
            if (s instanceof ModifierSlot) {
                GuiUtils.renderTexture((AbstractGui)this.getContainer().getGui(), matrixStack, this.slotUpgradeTex, container, x, y);
                continue;
            }
            GuiUtils.renderTexture((AbstractGui)this.getContainer().getGui(), matrixStack, this.slotTex, container, x, y);
        }
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mouseX, double mouseY) {
    }

    @Override
    public void onThemeChanged(Theme current) {
        this.slotTex = current.getTexture(this.slot);
        this.slotInputTex = current.getTexture(this.slotInput);
        this.slotOutputTex = current.getTexture(this.slotOutput);
        this.slotUpgradeTex = current.getTexture(this.slotUpgrade);
    }
}

