/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.container.scroll;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.box.SizablePanelElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.FixedContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.ScissorContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.ElementPosition;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.scroll.ScrollBarElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.Alignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;

public abstract class HScrollContainerElement
extends FixedContainerElement {
    private ScrollBarElement scrollBar;
    private SizablePanelElement background;
    private ScissorContainerElement container;
    private AssetID scrollTab;
    private AssetID scrollTabDisabled;
    private int scrollSpeed = 10;
    private ElementPosition scrollTabSize;
    private int spacing;

    public HScrollContainerElement(String id, int xSize, int ySize, int scrollTabWidth, int scrollTabHeight, AssetID scrollBox, AssetID scrollBoxDisabled, int containerScrollbarSpacing) {
        super(id, xSize, ySize);
        this.scrollTab = scrollBox;
        this.scrollTabDisabled = scrollBoxDisabled;
        this.scrollTabSize = new ElementPosition(scrollTabWidth, scrollTabHeight);
        this.spacing = containerScrollbarSpacing;
    }

    @Override
    public void addElements() {
        this.container = new ScissorContainerElement("container", this.getSizeX() - this.spacing - this.scrollTabSize.getX(), this.getSizeY()){

            @Override
            public void addElements() {
                HScrollContainerElement.this.addElementsInContainer();
            }

            @Override
            public void addElement(IElement ele, int x, int y) {
                super.addElement(ele, x, y);
                if (ele != null) {
                    int t = x + ele.getSizeX();
                    if (this.getXScrollMax() < t) {
                        this.setScrollMax(t, 0);
                    }
                }
            }
        };
        this.scrollBar = new ScrollBarElement("scrollbar", this.scrollTabSize.getX(), this.scrollTabSize.getY(), this.scrollTab, this.scrollTabDisabled, Alignment.HORIZONTAL, this::getSizeX, this.container::getXScrollMax, this.container::getXScroll, this::getScrollSpeed, this.container::onScrollHorizontal);
        super.addElement(this.container, 0, 0);
        super.addElement(this.scrollBar, 0, this.getSizeY() - this.scrollTabSize.getY());
    }

    @Override
    public void addElement(IElement ele, int x, int y) {
        this.container.addElement(ele, x, y);
    }

    private int getScrollSpeed() {
        return this.scrollSpeed;
    }

    public abstract void addElementsInContainer();
}

