/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.tileentity.module;

import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.tick.LongTickCounter;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.SidedTickerModule;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action1a;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Function1a;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class LongTrackerModule
extends SidedTickerModule {
    protected volatile LongTickCounter counter = new LongTickCounter();
    protected volatile Provider<Boolean> canStartProcess;
    protected volatile Function1a<Long, Long> validateProcessable;
    protected volatile Provider<Boolean> canCompleteProcess;
    protected volatile Action onProcessStarted;
    protected volatile Action1a<Long> onProcessTicks;
    protected volatile Action onIdleTick;
    protected volatile Action onComplete;
    protected volatile Provider<Long> getMaxTickRate;
    protected volatile Provider<Long> getProcessDuration;
    protected volatile Function1a<SaveDataType, Boolean> validSaveDataTypes;

    protected LongTrackerModule() {
    }

    @Override
    public void serverTick() {
        if (!this.counter.hasStarted() && !this.counter.isComplete()) {
            this.startNewProcess();
        }
        if (this.counter.hasStarted()) {
            long ticks = this.counter.clampTicks(this.getMaxTickRate.request());
            if ((ticks = this.validateProcessable.execute(ticks).longValue()) > 0L) {
                this.counter.tick(ticks);
                this.onProcessTicks.execute(ticks);
            } else {
                this.onIdleTick.execute();
            }
        }
        if (this.counter.isComplete() && this.canCompleteProcess.request().booleanValue()) {
            this.counter.reset(0L);
            this.onComplete.execute();
        }
    }

    @Override
    public void clientTick() {
    }

    @Override
    public void commonTick() {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        if (this.validSaveDataTypes.execute(type).booleanValue()) {
            nbt.func_218657_a("counter", (INBT)this.counter.serializeNBT());
        }
        return super.save(nbt, type);
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        if (this.validSaveDataTypes.execute(type).booleanValue() && nbt.func_74764_b("counter")) {
            this.counter.deserializeNBT(nbt.func_74775_l("counter"));
        }
        super.load(nbt, type);
    }

    private void startNewProcess() {
        if (this.canStartProcess.request().booleanValue()) {
            this.onProcessStarted.execute();
            this.counter.reset(this.getProcessDuration.request());
            this.counter.start();
        }
    }

    public void reset() {
        this.counter.reset(0L);
    }

    public boolean hasStarted() {
        return this.counter.hasStarted();
    }

    public long getCurrentDuration() {
        return this.counter.getDuration();
    }

    public long getCurrentProgress() {
        return this.counter.getProgress();
    }

    public float getProgressScale() {
        return (float)this.getCurrentProgress() / (float)this.getCurrentDuration();
    }

    public static abstract class AbstractBuilder<MODULE extends LongTrackerModule, BUILDER extends AbstractBuilder<MODULE, BUILDER>>
    extends SidedTickerModule.AbstractBuilder<MODULE, BUILDER> {
        protected volatile Provider<Boolean> canStartProcess;
        protected volatile Function1a<Long, Long> validateProcessable;
        protected volatile Provider<Boolean> canCompleteProcess;
        protected volatile Action onProcessStarted;
        protected volatile Action1a<Long> onProcessTicks;
        protected volatile Action onIdleTick;
        protected volatile Action onComplete;
        protected volatile Provider<Long> getMaxTickRate;
        protected volatile Provider<Long> getProcessDuration;
        protected volatile Function1a<SaveDataType, Boolean> validSaveDataTypes;

        protected AbstractBuilder() {
        }

        @Override
        protected MODULE addInternals(MODULE module) {
            ((LongTrackerModule)module).canStartProcess = this.canStartProcess != null ? this.canStartProcess : () -> true;
            ((LongTrackerModule)module).validateProcessable = this.validateProcessable != null ? this.validateProcessable : t -> t;
            ((LongTrackerModule)module).canCompleteProcess = this.canCompleteProcess != null ? this.canCompleteProcess : () -> true;
            ((LongTrackerModule)module).onProcessStarted = this.onProcessStarted != null ? this.onProcessStarted : () -> {};
            ((LongTrackerModule)module).onProcessTicks = this.onProcessTicks != null ? this.onProcessTicks : i -> {};
            ((LongTrackerModule)module).onIdleTick = this.onIdleTick != null ? this.onIdleTick : () -> {};
            ((LongTrackerModule)module).onComplete = this.onComplete != null ? this.onComplete : () -> {};
            ((LongTrackerModule)module).getMaxTickRate = this.getMaxTickRate != null ? this.getMaxTickRate : () -> 1L;
            Function1a<SaveDataType, Boolean> function1a = ((LongTrackerModule)module).validSaveDataTypes = this.validSaveDataTypes != null ? this.validSaveDataTypes : sdt -> true;
            if (this.getProcessDuration == null) {
                throw new NullPointerException("Process Duration cannot be null inside TrackerModule");
            }
            ((LongTrackerModule)module).getProcessDuration = this.getProcessDuration;
            return (MODULE)((LongTrackerModule)super.addInternals(module));
        }

        public BUILDER canStartProcess(Provider<Boolean> provider) {
            this.canStartProcess = provider;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER checkAndValidateProcessable(Function1a<Long, Long> function) {
            this.validateProcessable = function;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER canCompleteProcess(Provider<Boolean> provider) {
            this.canCompleteProcess = provider;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER onProcessStarted(Action action) {
            this.onProcessStarted = action;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER onProcessTick(Action1a<Long> action) {
            this.onProcessTicks = action;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER onIdleTick(Action action) {
            this.onIdleTick = action;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER onComplete(Action action) {
            this.onComplete = action;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER maxTickRate(Provider<Long> provider) {
            this.getMaxTickRate = provider;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER processDuration(Provider<Long> provider) {
            this.getProcessDuration = provider;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }

        public BUILDER validSaveDataType(Function1a<SaveDataType, Boolean> function) {
            this.validSaveDataTypes = function;
            return (BUILDER)((AbstractBuilder)this.thisBuilder());
        }
    }

    public static final class Builder
    extends AbstractBuilder<LongTrackerModule, Builder> {
        protected Builder() {
        }

        @Override
        protected LongTrackerModule newModule() {
            return new LongTrackerModule();
        }

        @Override
        public Builder thisBuilder() {
            return this;
        }
    }
}

