/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.tileentity.machine;

import com.valkyrieofnight.vlib.core.obj.container.config.ISidedConfigurable;
import com.valkyrieofnight.vlib.core.obj.container.config.SidedConfigPacket;
import com.valkyrieofnight.vlib.core.obj.container.config.SidedConfigWL;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IInventoryProvider;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLInventory;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLSerializableInventory;
import com.valkyrieofnight.vlib.core.obj.container.rateconfig.IHasRateConfigSideMenu;
import com.valkyrieofnight.vlib.core.obj.container.rateconfig.RateConfigPacket;
import com.valkyrieofnight.vlib.core.obj.tileentity.VLModularLockableTile;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IHorizontalFacingInventory;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IReceivePacketFromClient;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.network.BaseTilePacket;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionDataContainerHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;

public abstract class VLSidedItemMachine
extends VLModularLockableTile
implements ISidedConfigurable,
IHorizontalFacingInventory,
IReceivePacketFromClient,
IInventoryProvider {
    protected final ConditionContainerProvider conditionProvider = ConditionDataContainerHandler.getInstance().getProvider(() -> this.func_145831_w().func_230315_m_(), this::getPlacedBy);
    protected SidedConfigWL inventoryConfig;
    private int tick = 0;

    public VLSidedItemMachine(TileEntityType<?> blockEntityType_1) {
        super(blockEntityType_1);
    }

    public ConditionContainerProvider getConditionProvider() {
        return this.conditionProvider;
    }

    @Override
    protected void setupInventory(IVLSerializableInventory ... inventories) {
        this.setupInventory(new RelativeDirection[0], inventories);
    }

    protected void setupInventory(RelativeDirection[] disabled, IVLSerializableInventory ... inventories) {
        super.setupInventory(inventories);
        this.inventoryConfig = new SidedConfigWL("inv", disabled, this.inventory.getSlotModes());
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        if (this.inventoryConfig != null) {
            nbt.func_218657_a("slot_config_" + this.inventoryConfig.getName(), (INBT)this.inventoryConfig.serializeNBT());
        }
        if (this instanceof IHasRateConfigSideMenu) {
            nbt.func_218657_a("rate_config_data", (INBT)((IHasRateConfigSideMenu)((Object)this)).saveRateConfigs());
        }
        return super.save(nbt, type);
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        if (nbt.func_74764_b("slot_config_" + this.inventoryConfig.getName())) {
            CompoundNBT sci = nbt.func_74775_l("slot_config_" + this.inventoryConfig.getName());
            this.inventoryConfig.deserializeNBT(sci);
        }
        if (this instanceof IHasRateConfigSideMenu) {
            CompoundNBT configNBT = (CompoundNBT)nbt.func_74781_a("rate_config_data");
            ((IHasRateConfigSideMenu)((Object)this)).loadRateConfigs(configNBT);
        }
        super.load(nbt, type);
    }

    @Override
    public void receiveData(BaseTilePacket packet) {
        if (packet instanceof SidedConfigPacket) {
            SidedConfigPacket iscp = (SidedConfigPacket)packet;
            CompoundNBT data = iscp.getData();
            this.inventoryConfig.debug();
            this.inventoryConfig.deserializeNBT(data.func_74775_l(this.inventoryConfig.getName()));
            this.func_70296_d();
        }
        if (packet instanceof RateConfigPacket && this instanceof IHasRateConfigSideMenu) {
            CompoundNBT configNBT = ((RateConfigPacket)packet).getData();
            ((IHasRateConfigSideMenu)((Object)this)).loadRateConfigs(configNBT);
        }
    }

    @Override
    public int[] getSlotsForRelativeDirection(RelativeDirection direction) {
        return this.inventoryConfig.getEnabledSlotsForDirection(direction);
    }

    @Override
    public boolean canInsertItem(ItemStack stack, int slot, @Nullable RelativeDirection direction) {
        return this.inventoryConfig.canInsert(slot, direction) && this.inventory.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(ItemStack stack, int slot, RelativeDirection direction) {
        return this.inventoryConfig.canExtract(slot, direction);
    }

    @Override
    public int getMaxStackSize(int slot) {
        return this.inventory.getMaxStackSize(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    @Override
    public Optional<SidedConfigWL> getSidedConfigCopy(ISidedConfigurable.ConfigType type) {
        if (type == ISidedConfigurable.ConfigType.ITEM && this.inventoryConfig != null) {
            return Optional.of(this.inventoryConfig.copy());
        }
        return Optional.empty();
    }

    @Override
    public IVLInventory getInventoryFromSlot(int slot) {
        return this.inventory.getInventoryFromSlot(slot);
    }

    @Override
    public IOMode getSlotMode(int slot) {
        return this.inventory.getSlotMode(slot);
    }

    @Override
    public List<IOMode> getSlotModes() {
        return this.inventory.getSlotModes();
    }
}

