/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.tileentity.base.tick;

import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import net.minecraft.nbt.CompoundNBT;

public class TickCounter
implements INBTSerializer {
    private int tickTotal = 0;
    private int tickProgress = 0;

    public void reset(int duration) {
        this.tickTotal = duration + 1;
        this.tickProgress = 0;
    }

    public void start() {
        if (this.tickProgress <= 0) {
            this.tick();
        }
    }

    public boolean hasStarted() {
        return this.tickProgress >= 1 && !this.isComplete();
    }

    public boolean isComplete() {
        return this.tickProgress >= this.tickTotal;
    }

    public void tick() {
        ++this.tickProgress;
    }

    public void tick(int tickAmount) {
        this.tickProgress += tickAmount;
    }

    public int getTicksRemaining() {
        return this.tickTotal - this.tickProgress;
    }

    public int getTicksOvershot() {
        return Math.max(this.tickProgress - this.tickTotal, 0);
    }

    public int getDuration() {
        return this.tickTotal - 1;
    }

    public int getProgress() {
        if (this.tickProgress == 0) {
            return 0;
        }
        return this.tickProgress - 1;
    }

    public int clampTicks(int attemptingTickAmmount) {
        return Math.min(attemptingTickAmmount, this.getTicksRemaining());
    }

    @Override
    public CompoundNBT serializeNBT() {
        return NBTBuilder.create().putInt("tick_total", this.tickTotal).putInt("tick_progress", this.tickProgress).build();
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt != null) {
            this.tickTotal = nbt.func_74762_e("tick_total");
            this.tickProgress = nbt.func_74762_e("tick_progress");
        }
    }
}

