/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.container.rateconfig;

import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public interface IConfigurableIORate {
    public String getID();

    public List<Capability<?>> getCapabilities();

    public boolean isCapabilitySupported(Capability<?> var1);

    public <T> LazyOptional<T> getCapabilityHandler(Capability<T> var1);

    public boolean isInputModeSupported();

    public boolean isOutputModeSupported();

    default public boolean isModeSupported(IOMode mode) {
        switch (mode) {
            case IN: {
                return this.isInputModeSupported();
            }
            case OUT: {
                return this.isOutputModeSupported();
            }
        }
        return false;
    }

    public IOMode getIOMode();

    public void setCurrentIOMode(IOMode var1);

    default public void toggleCurrentMode() {
        this.setCurrentIOMode(this.getIOMode() == IOMode.IN ? IOMode.OUT : IOMode.IN);
    }

    default public int getRate() {
        return this.getRate(this.getIOMode());
    }

    default public int getRate(IOMode mode) {
        switch (mode) {
            case OUT: {
                return this.getOutputRate();
            }
            case IN: {
                return this.getInputRate();
            }
        }
        return 0;
    }

    public int getInputRate();

    public int getOutputRate();

    public int getMinInputRate();

    public int getMinOutputRate();

    public int getMaxInputRate();

    public int getMaxOutputRate();

    default public void setRate(int rate) {
        this.setRate(this.getIOMode(), rate);
    }

    default public void setRate(IOMode mode, int rate) {
        switch (mode) {
            case OUT: {
                this.setOutputRate(rate);
                break;
            }
            case IN: {
                this.setInputRate(rate);
            }
        }
    }

    public void setInputRate(int var1);

    public void setOutputRate(int var1);

    default public void decreaseRate(int amount) {
        this.setRate(this.getIOMode(), Math.max(this.getRate() - amount, 0));
    }

    default public void decreaseRate(IOMode mode, int amount) {
        this.setRate(mode, Math.max(this.getRate(mode) - amount, 0));
    }

    default public void increaseRate(int amount) {
        this.setRate(this.getIOMode(), Math.min(amount + this.getRate(), this.getMaxRate()));
    }

    default public void increaseRate(IOMode mode, int amount) {
        this.setRate(mode, Math.min(amount + this.getRate(mode), this.getMaxRate(mode)));
    }

    default public int getMaxRate() {
        return this.getMaxRate(this.getIOMode());
    }

    default public int getMaxRate(IOMode mode) {
        switch (mode) {
            case OUT: {
                return this.getMaxOutputRate();
            }
            case IN: {
                return this.getMaxInputRate();
            }
        }
        return 0;
    }

    default public boolean isRateMax() {
        return this.isRateMax(this.getIOMode());
    }

    default public boolean isRateMax(IOMode mode) {
        return this.getRate(mode) == this.getMaxRate(mode);
    }

    default public void saveRateConfigData(CompoundNBT nbt) {
        nbt.func_218657_a("rate_config_nbt", (INBT)this.serializeConfigNBT());
    }

    default public CompoundNBT serializeConfigNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(this.getID() + "_mode", this.getIOMode().ordinal());
        nbt.func_74768_a(this.getID() + "_input_rate", this.getInputRate());
        nbt.func_74768_a(this.getID() + "_output_rate", this.getOutputRate());
        return nbt;
    }

    default public void deserializeConfigNBT(CompoundNBT nbt) {
        this.setCurrentIOMode(IOMode.values()[nbt.func_74762_e(this.getID() + "_mode")]);
        this.setInputRate(nbt.func_74762_e(this.getID() + "_input_rate"));
        this.setOutputRate(nbt.func_74762_e(this.getID() + "_output_rate"));
    }
}

