/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config.property;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.properties.PropBoolean;
import com.valkyrieofnight.vlib.core.io.json.config.property.properties.PropByte;
import com.valkyrieofnight.vlib.core.io.json.config.property.properties.PropChar;
import com.valkyrieofnight.vlib.core.io.json.config.property.properties.PropDouble;
import com.valkyrieofnight.vlib.core.io.json.config.property.properties.PropFloat;
import com.valkyrieofnight.vlib.core.io.json.config.property.properties.PropInt;
import com.valkyrieofnight.vlib.core.io.json.config.property.properties.PropLong;
import com.valkyrieofnight.vlib.core.io.json.config.property.properties.PropMap;
import com.valkyrieofnight.vlib.core.io.json.config.property.properties.PropShort;
import com.valkyrieofnight.vlib.core.io.json.config.property.properties.PropString;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import java.util.Map;

public class PropParserRegistry {
    protected Map<String, PropParserBase> PARCERS = Maps.newConcurrentMap();
    private static PropParserRegistry GLOBAL = new PropParserRegistry();

    public static void registerGlobal(PropParserBase parser) {
        try {
            GLOBAL.register(parser);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PropParserRegistry getGlobalInstance() {
        return GLOBAL;
    }

    public PropParserBase getParser(String prefix) {
        if (StringUtils.isNullOrEmpty(prefix)) {
            return null;
        }
        return this.PARCERS.get(prefix);
    }

    public void register(PropParserBase parser) throws Exception {
        if (parser == null) {
            throw new NullPointerException();
        }
        if (StringUtils.isNullOrEmpty(parser.getPrefix())) {
            throw new NullPointerException("prefix must not be null");
        }
        if (parser.getPrefix().contains(":")) {
            throw new Exception("Invalid format of prefix. Must not contain any colon charaters");
        }
        if (this.PARCERS.containsKey(parser.getPrefix())) {
            throw new Exception("PropParserRegistry already contains parcer with prefix: " + parser.getPrefix());
        }
        this.PARCERS.put(parser.prefix, parser);
    }

    static {
        PropParserRegistry.registerGlobal(PropByte.PARSER);
        PropParserRegistry.registerGlobal(PropChar.PARSER);
        PropParserRegistry.registerGlobal(PropShort.PARSER);
        PropParserRegistry.registerGlobal(PropInt.PARSER);
        PropParserRegistry.registerGlobal(PropLong.PARSER);
        PropParserRegistry.registerGlobal(PropFloat.PARSER);
        PropParserRegistry.registerGlobal(PropDouble.PARSER);
        PropParserRegistry.registerGlobal(PropBoolean.PARSER);
        PropParserRegistry.registerGlobal(PropString.PARSER);
        PropParserRegistry.registerGlobal(PropMap.PARSER);
    }
}

