/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.valkyrieofnight.vlib.core.io.json.ITypedDeserializer;
import java.util.Map;
import java.util.Set;

public class JsonUtils {
    public static GsonBuilder createTypedGsonBuilder(ITypedDeserializer ... deserializers) {
        GsonBuilder gb = new GsonBuilder();
        for (ITypedDeserializer td : deserializers) {
            if (td == null) continue;
            gb.registerTypeAdapter(td.getType(), (Object)td);
        }
        return gb;
    }

    public static Set<Map.Entry<String, JsonElement>> getChildren(JsonObject jo) {
        return jo.entrySet();
    }

    public static JsonObject getAsJsonObject(JsonObject parent, String child) {
        JsonElement je;
        if (parent.has(child) && (je = parent.get(child)) instanceof JsonObject) {
            return je.getAsJsonObject();
        }
        return null;
    }

    public static JsonObject getAsJsonObject(JsonElement je) {
        return je.isJsonObject() ? (JsonObject)je : null;
    }

    public static String getAsString(JsonElement je) {
        return je.isJsonPrimitive() && je.getAsJsonPrimitive().isString() ? je.getAsString() : null;
    }

    public static String getAsString(JsonObject parent, String child) {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsString(je);
        }
        return null;
    }

    public static String getAsStringOrDefault(JsonObject parent, String child, String def) {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsString(je);
        }
        return def;
    }

    public static JsonArray getAsArray(JsonElement je) {
        return je.isJsonArray() ? (JsonArray)je : null;
    }

    public static JsonArray getAsArray(JsonObject parent, String child) {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsArray(je);
        }
        return null;
    }

    public static boolean getAsBoolean(JsonElement je) throws JsonParseException {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isBoolean()) {
            return je.getAsBoolean();
        }
        throw new JsonParseException("Cannot get JsonElement as boolean: " + je.toString());
    }

    public static boolean getAsBoolean(JsonObject parent, String child) throws JsonParseException {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsBoolean(je);
        }
        throw new JsonParseException("Cannot get boolean from parent object with key: " + child);
    }

    public static boolean getAsBooleanOrDefault(JsonElement je, boolean def) {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isBoolean()) {
            return je.getAsBoolean();
        }
        return def;
    }

    public static boolean getAsBooleanOrDefault(JsonObject parent, String child, boolean def) {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsBooleanOrDefault(je, def);
        }
        return def;
    }

    public static byte getAsByte(JsonElement je) throws JsonParseException {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsByte();
        }
        throw new JsonParseException("Cannot get JsonElement as byte: " + je.toString());
    }

    public static byte getAsByte(JsonObject parent, String child) throws JsonParseException {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsByte(je);
        }
        throw new JsonParseException("Cannot get byte from parent object with key: " + child);
    }

    public static byte getAsByteOrDefault(JsonElement je, byte def) {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsByte();
        }
        return def;
    }

    public static byte getAsByteOrDefault(JsonObject parent, String child, byte def) {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsByteOrDefault(je, def);
        }
        return def;
    }

    public static short getAsShort(JsonElement je) throws JsonParseException {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsShort();
        }
        throw new JsonParseException("Cannot get JsonElement as short: " + je.toString());
    }

    public static short getAsShort(JsonObject parent, String child) throws JsonParseException {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsShort(je);
        }
        throw new JsonParseException("Cannot get short from parent object with key: " + child);
    }

    public static short getAsShortOrDefault(JsonElement je, short def) {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsShort();
        }
        return def;
    }

    public static short getAsShortOrDefault(JsonObject parent, String child, short def) {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsShortOrDefault(je, def);
        }
        return def;
    }

    public static int getAsInt(JsonElement je) throws JsonParseException {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsInt();
        }
        throw new JsonParseException("Cannot get JsonElement as int: " + je.toString());
    }

    public static int getAsInt(JsonObject parent, String child) throws JsonParseException {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsInt(je);
        }
        throw new JsonParseException("Cannot get int from parent object with key: " + child);
    }

    public static int getAsIntOrDefault(JsonElement je, int def) {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsInt();
        }
        return def;
    }

    public static int getAsIntOrDefault(JsonObject parent, String child, int def) {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsIntOrDefault(je, def);
        }
        return def;
    }

    public static long getAsLong(JsonElement je) throws JsonParseException {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsLong();
        }
        throw new JsonParseException("Cannot get JsonElement as long: " + je.toString());
    }

    public static long getAsLong(JsonObject parent, String child) throws JsonParseException {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsLong(je);
        }
        throw new JsonParseException("Cannot get long from parent object with key: " + child);
    }

    public static long getAsLongOrDefault(JsonElement je, long def) {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsLong();
        }
        return def;
    }

    public static long getAsLongOrDefault(JsonObject parent, String child, long def) {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsLongOrDefault(je, def);
        }
        return def;
    }

    public static float getAsFloat(JsonElement je) throws JsonParseException {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsFloat();
        }
        throw new JsonParseException("Cannot get JsonElement as float: " + je.toString());
    }

    public static float getAsFloat(JsonObject parent, String child) throws JsonParseException {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsFloat(je);
        }
        throw new JsonParseException("Cannot get float from parent object with key: " + child);
    }

    public static float getAsFloatOrDefault(JsonElement je, float def) {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsFloat();
        }
        return def;
    }

    public static float getAsFloatOrDefault(JsonObject parent, String child, float def) {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsFloatOrDefault(je, def);
        }
        return def;
    }

    public static double getAsDouble(JsonElement je) throws JsonParseException {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsDouble();
        }
        throw new JsonParseException("Cannot get JsonElement as double: " + je.toString());
    }

    public static double getAsDouble(JsonObject parent, String child) throws JsonParseException {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsDouble(je);
        }
        throw new JsonParseException("Cannot get double from parent object with key: " + child);
    }

    public static double getAsDoubleOrDefault(JsonElement je, double def) {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsDouble();
        }
        return def;
    }

    public static double getAsDoubleOrDefault(JsonObject parent, String child, double def) {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsDoubleOrDefault(je, def);
        }
        return def;
    }

    public static char getAsChar(JsonElement je) throws JsonParseException {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsCharacter();
        }
        throw new JsonParseException("Cannot get JsonElement as char: " + je.toString());
    }

    public static char getAsChar(JsonObject parent, String child) throws JsonParseException {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsChar(je);
        }
        throw new JsonParseException("Cannot get char from parent object with key: " + child);
    }

    public static char getAsCharOrDefault(JsonElement je, char def) {
        if (je.isJsonPrimitive() && je.getAsJsonPrimitive().isNumber()) {
            return je.getAsJsonPrimitive().getAsCharacter();
        }
        return def;
    }

    public static char getAsCharOrDefault(JsonObject parent, String child, char def) {
        if (parent.has(child)) {
            JsonElement je = parent.get(child);
            return JsonUtils.getAsCharOrDefault(je, def);
        }
        return def;
    }

    public static String[] getAsStringArray(JsonElement je) throws JsonParseException {
        String[] arr = JsonUtils.getAsStringArrayOrDefault(je, null);
        if (arr != null) {
            return arr;
        }
        throw new JsonParseException("Cannot get JsonElement as String[]: " + je.toString());
    }

    public static String[] getAsStringArray(JsonObject parent, String child) throws JsonParseException {
        if (parent.has(child)) {
            return JsonUtils.getAsStringArray(parent.get(child));
        }
        throw new JsonParseException("Cannot get String[] from parent object with key: " + child);
    }

    public static String[] getAsStringArrayOrDefault(JsonElement je, String[] def) {
        if (je.isJsonArray()) {
            JsonArray ja = je.getAsJsonArray();
            String[] ret = new String[ja.size()];
            for (int i = 0; i < ja.size(); ++i) {
                ret[i] = ja.get(i).getAsString();
            }
            return ret;
        }
        return def;
    }

    public static String[] getAsStringArrayOrDefault(JsonObject parent, String child, String[] def) {
        if (parent.has(child)) {
            return JsonUtils.getAsStringArrayOrDefault(parent.get(child), def);
        }
        return def;
    }
}

