/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class ItemIngredient
extends Ingredient {
    private final int amount;

    public static ItemIngredient fromItems(int amount, IItemProvider ... items) {
        return new ItemIngredient(amount, Arrays.stream(items).map(item -> new Ingredient.SingleItemList(new ItemStack(item))));
    }

    public static ItemIngredient fromStacks(int amount, ItemStack ... stacks) {
        return new ItemIngredient(amount, Arrays.stream(stacks).map(stack -> new Ingredient.SingleItemList(stack)));
    }

    public static ItemIngredient fromTag(int amount, Tag<Item> tag) {
        return new ItemIngredient(amount, Stream.of(new Ingredient.TagList(tag)));
    }

    protected ItemIngredient(int amount, Stream<? extends Ingredient.IItemList> stream) {
        super(stream);
        this.amount = amount;
    }

    public boolean test(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.field_199807_b.length == 0) {
            return stack.func_190926_b();
        }
        this.func_199806_d();
        for (ItemStack itemstack : this.field_193371_b) {
            if (itemstack.func_77973_b() != stack.func_77973_b()) continue;
            return stack.func_190916_E() >= this.amount;
        }
        return false;
    }

    public int getAmount() {
        return this.amount;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        jsonObject.addProperty("amount", (Number)this.amount);
        jsonObject.add("items", super.func_200304_c());
        return jsonObject;
    }

    public static class Serializer
    implements IIngredientSerializer<ItemIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public ItemIngredient parse(JsonObject jsonObject) {
            if (!jsonObject.has("amount") || !jsonObject.has("items")) {
                throw new JsonSyntaxException("Expected amount and items");
            }
            int amount = JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"amount");
            JsonElement ingredientJsonElement = jsonObject.get("items");
            if (ingredientJsonElement.isJsonObject()) {
                return new ItemIngredient(amount, Stream.of(Ingredient.func_199803_a((JsonObject)ingredientJsonElement.getAsJsonObject())));
            }
            if (ingredientJsonElement.isJsonArray()) {
                JsonArray jsonArray = ingredientJsonElement.getAsJsonArray();
                if (jsonArray.size() == 0) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                return new ItemIngredient(amount, StreamSupport.stream(jsonArray.spliterator(), false).map(jsonArrayElement -> Ingredient.func_199803_a((JsonObject)JSONUtils.func_151210_l((JsonElement)jsonArrayElement, (String)"item"))));
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }

        public ItemIngredient parse(PacketBuffer buffer) {
            int amount = buffer.readInt();
            int length = buffer.func_150792_a();
            return new ItemIngredient(amount, Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(length));
        }

        public void write(PacketBuffer buffer, ItemIngredient ingredient) {
            ItemStack[] items = ingredient.func_193365_a();
            buffer.writeInt(ingredient.amount);
            buffer.func_150787_b(items.length);
            for (ItemStack stack : items) {
                buffer.func_150788_a(stack);
            }
        }
    }
}

