/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import info.u_team.u_team_core.util.RenderUtil;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public abstract class ScrollableList<T extends AbstractList.AbstractListEntry<T>>
extends ExtendedList<T> {
    protected int sideDistance;
    protected boolean shouldUseScissor;
    protected boolean shouldRenderTransparentBorder;
    protected float transparentBorderSize;

    public ScrollableList(int x, int y, int width, int height, int slotHeight, int sideDistance) {
        super(Minecraft.func_71410_x(), 0, 0, 0, 0, slotHeight);
        this.updateSettings(x, y, width, height);
        this.sideDistance = sideDistance;
        this.transparentBorderSize = 4.0f;
    }

    public ScrollableList(int width, int height, int top, int bottom, int left, int right, int slotHeight, int sideDistance) {
        super(Minecraft.func_71410_x(), 0, 0, 0, 0, slotHeight);
        this.updateSettings(width, height, top, bottom, left, right);
        this.sideDistance = sideDistance;
        this.transparentBorderSize = 4.0f;
    }

    public void updateSettings(int x, int y, int width, int height) {
        this.updateSettings(width, this.field_230668_b_.func_228018_at_().func_198087_p(), y, y + height, x, x + width);
    }

    public void updateSettings(int width, int height, int top, int bottom, int left, int right) {
        this.field_230670_d_ = width;
        this.field_230671_e_ = height;
        this.field_230672_i_ = top;
        this.field_230673_j_ = bottom;
        this.field_230675_l_ = left;
        this.field_230674_k_ = right;
    }

    public int getSideDistance() {
        return this.sideDistance;
    }

    public void setSideDistance(int sideDistance) {
        this.sideDistance = sideDistance;
    }

    public boolean isShouldUseScissor() {
        return this.shouldUseScissor;
    }

    public void setShouldUseScissor(boolean shouldUseScissor) {
        this.shouldUseScissor = shouldUseScissor;
    }

    public boolean isShouldRenderTransparentBorder() {
        return this.shouldRenderTransparentBorder;
    }

    public void setShouldRenderTransparentBorder(boolean shouldRenderTransparentBorder) {
        this.shouldRenderTransparentBorder = shouldRenderTransparentBorder;
    }

    public float getTransparentBorderSize() {
        return this.transparentBorderSize;
    }

    public void setTransparentBorderSize(float transparentBorderSize) {
        this.transparentBorderSize = transparentBorderSize;
    }

    public int func_230949_c_() {
        return this.field_230670_d_ - this.sideDistance;
    }

    protected int func_230952_d_() {
        return this.field_230675_l_ + this.field_230670_d_ - 5;
    }

    protected void func_238478_a_(MatrixStack matrixStack, int rowLeft, int scrollAmount, int mouseX, int mouseY, float partialTicks) {
        if (this.shouldUseScissor) {
            MainWindow window = this.field_230668_b_.func_228018_at_();
            double scaleFactor = window.func_198100_s();
            int nativeX = MathHelper.func_76143_f((double)((double)this.field_230675_l_ * scaleFactor));
            int nativeY = MathHelper.func_76143_f((double)((double)this.field_230672_i_ * scaleFactor));
            int nativeWidth = MathHelper.func_76143_f((double)((double)(this.field_230674_k_ - this.field_230675_l_) * scaleFactor));
            int nativeHeight = MathHelper.func_76143_f((double)((double)(this.field_230673_j_ - this.field_230672_i_) * scaleFactor));
            RenderUtil.enableScissor(nativeX, window.func_198083_n() - (nativeY + nativeHeight), nativeWidth, nativeHeight);
            super.func_238478_a_(matrixStack, rowLeft, scrollAmount, mouseX, mouseY, partialTicks);
            RenderUtil.disableScissor();
        } else {
            super.func_238478_a_(matrixStack, rowLeft, scrollAmount, mouseX, mouseY, partialTicks);
        }
        if (this.shouldRenderTransparentBorder) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            RenderUtil.enableBlend();
            RenderUtil.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
            RenderUtil.shadeModel(7425);
            RenderUtil.disableTexture();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_225582_a_((double)this.field_230675_l_, (double)((float)this.field_230672_i_ + this.transparentBorderSize), 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
            buffer.func_225582_a_((double)this.field_230674_k_, (double)((float)this.field_230672_i_ + this.transparentBorderSize), 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
            buffer.func_225582_a_((double)this.field_230674_k_, (double)this.field_230672_i_, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230675_l_, (double)this.field_230673_j_, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230674_k_, (double)this.field_230673_j_, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230674_k_, (double)((float)this.field_230673_j_ - this.transparentBorderSize), 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
            buffer.func_225582_a_((double)this.field_230675_l_, (double)((float)this.field_230673_j_ - this.transparentBorderSize), 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
            RenderUtil.enableTexture();
            RenderUtil.disableBlend();
        }
    }
}

