/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.u_team_core.api.gui.IScaleProvider;
import info.u_team.u_team_core.api.gui.IScaleable;
import info.u_team.u_team_core.gui.elements.UTextField;
import info.u_team.u_team_core.util.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class ScalableTextField
extends UTextField
implements IScaleable,
IScaleProvider {
    protected float scale;

    public ScalableTextField(FontRenderer fontRenderer, int x, int y, int width, int height, UTextField previousTextField, ITextComponent title, float scale) {
        this(fontRenderer, x, y, width, height, previousTextField, title, scale, EMPTY_TOOLTIP);
    }

    public ScalableTextField(FontRenderer fontRenderer, int x, int y, int width, int height, UTextField previousTextField, ITextComponent title, float scale, UTextField.ITooltip tooltip) {
        super(fontRenderer, x, y, width, height, previousTextField, title, tooltip);
        this.scale = scale;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        float currentScale = this.getCurrentScale(matrixStack, mouseX, mouseY, partialTicks);
        float positionFactor = 1.0f / this.scale;
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(currentScale, currentScale, 0.0f);
        RGBA currentTextColor = this.getCurrentTextColor(matrixStack, mouseX, mouseY, partialTicks);
        String currentText = this.field_146211_a.func_238412_a_(this.field_146216_j.substring(this.field_146225_q), this.func_146200_o());
        int cursorOffset = this.field_146224_r - this.field_146225_q;
        int selectionOffset = Math.min(this.field_146223_s - this.field_146225_q, currentText.length());
        boolean isCursorInText = cursorOffset >= 0 && cursorOffset <= currentText.length();
        boolean shouldCursorBlink = this.func_230999_j_() && this.field_146214_l / 6 % 2 == 0 && isCursorInText;
        boolean isCursorInTheMiddle = this.field_146224_r < this.field_146216_j.length() || this.field_146216_j.length() >= this.field_146217_k;
        int xOffset = (int)((float)(this.field_146215_m ? this.field_230690_l_ + 4 : this.field_230690_l_) * positionFactor);
        int yOffset = (int)((float)(this.field_146215_m ? this.field_230691_m_ + (int)((float)this.field_230689_k_ - 8.0f * this.scale) / 2 : this.field_230691_m_) * positionFactor);
        int leftRenderedTextX = xOffset;
        if (!currentText.isEmpty()) {
            String firstTextPart = isCursorInText ? currentText.substring(0, cursorOffset) : currentText;
            leftRenderedTextX = this.field_146211_a.func_238407_a_(matrixStack, (IReorderingProcessor)this.field_195613_A.apply(firstTextPart, this.field_146225_q), (float)xOffset, (float)yOffset, currentTextColor.getColorARGB());
        }
        int rightRenderedTextX = leftRenderedTextX;
        if (!isCursorInText) {
            rightRenderedTextX = cursorOffset > 0 ? xOffset + this.field_230688_j_ : xOffset;
        } else if (isCursorInTheMiddle) {
            rightRenderedTextX = leftRenderedTextX - 1;
            --leftRenderedTextX;
        }
        if (!currentText.isEmpty() && isCursorInText && cursorOffset < currentText.length()) {
            this.field_146211_a.func_238407_a_(matrixStack, (IReorderingProcessor)this.field_195613_A.apply(currentText.substring(cursorOffset), this.field_146224_r), (float)leftRenderedTextX, (float)yOffset, currentTextColor.getColorARGB());
        }
        if (!isCursorInTheMiddle && this.field_195614_x != null) {
            this.field_146211_a.func_238405_a_(matrixStack, this.field_195614_x, (float)(rightRenderedTextX - 1), (float)yOffset, this.getCurrentSuggestionTextColor(matrixStack, mouseX, mouseY, partialTicks).getColorARGB());
        }
        if (shouldCursorBlink) {
            if (isCursorInTheMiddle) {
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)rightRenderedTextX, (int)(yOffset - 1), (int)(rightRenderedTextX + 1), (int)(yOffset + 1 + 9), (int)this.getCurrentCursorColor(matrixStack, mouseX, mouseY, partialTicks).getColorARGB());
            } else {
                this.field_146211_a.func_238405_a_(matrixStack, "_", (float)rightRenderedTextX, (float)yOffset, currentTextColor.getColorARGB());
            }
        }
        if (selectionOffset != cursorOffset) {
            int selectedX = xOffset + this.field_146211_a.func_78256_a(currentText.substring(0, selectionOffset));
            this.func_146188_c((int)((float)rightRenderedTextX * currentScale), (int)((float)(yOffset - 1) * currentScale), (int)((float)(selectedX - 1) * currentScale), (int)((float)(yOffset + 1 + 9) * currentScale));
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public float getCurrentScale(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        return this.getCurrentScale(mouseX, mouseY);
    }

    public float getCurrentScale(double mouseX, double mouseY) {
        return this.scale;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (!this.field_230694_p_) {
            return false;
        }
        boolean clicked = this.func_230992_c_(mouseX, mouseY);
        if (this.field_146212_n) {
            this.func_146195_b(clicked);
        }
        if (this.func_230999_j_() && clicked && button == 0) {
            int clickOffset = MathHelper.func_76128_c((double)mouseX) - this.field_230690_l_;
            if (this.field_146215_m) {
                clickOffset -= 4;
            }
            clickOffset = (int)((float)clickOffset / this.getCurrentScale(mouseX, mouseY));
            String currentText = this.field_146211_a.func_238412_a_(this.field_146216_j.substring(this.field_146225_q), this.func_146200_o());
            this.func_146190_e(this.field_146211_a.func_238412_a_(currentText, clickOffset).length() + this.field_146225_q);
            return true;
        }
        return false;
    }
}

