/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.u_team_core.api.gui.IScaleProvider;
import info.u_team.u_team_core.api.gui.IScaleable;
import info.u_team.u_team_core.gui.elements.CheckboxButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class ScalableCheckboxButton
extends CheckboxButton
implements IScaleable,
IScaleProvider {
    protected float scale;

    public ScalableCheckboxButton(int x, int y, int width, int height, ITextComponent text, boolean checked, boolean drawText, float scale) {
        this(x, y, width, height, text, checked, drawText, scale, EMTPY_PRESSABLE);
    }

    public ScalableCheckboxButton(int x, int y, int width, int height, ITextComponent text, boolean checked, boolean drawText, float scale, Button.IPressable pessable) {
        this(x, y, width, height, text, checked, drawText, scale, pessable, field_238486_s_);
    }

    public ScalableCheckboxButton(int x, int y, int width, int height, ITextComponent text, boolean checked, boolean drawText, float scale, Button.ITooltip tooltip) {
        this(x, y, width, height, text, checked, drawText, scale, EMTPY_PRESSABLE, tooltip);
    }

    public ScalableCheckboxButton(int x, int y, int width, int height, ITextComponent text, boolean checked, boolean drawText, float scale, Button.IPressable pessable, Button.ITooltip tooltip) {
        super(x, y, width, height, text, checked, drawText, pessable, tooltip);
        this.scale = scale;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.drawText) {
            FontRenderer fontRenderer = minecraft.field_71466_p;
            ITextComponent message = this.getCurrentText();
            if (message != StringTextComponent.field_240750_d_) {
                float currentScale = this.getCurrentScale(matrixStack, mouseX, mouseY, partialTicks);
                float positionFactor = 1.0f / currentScale;
                float yStart = (float)(this.field_230691_m_ + (int)((float)this.field_230689_k_ - 8.0f * currentScale) / 2) * positionFactor;
                float xStart = this.leftSideText ? ((float)this.field_230690_l_ - ((float)fontRenderer.func_238414_a_((ITextProperties)message) * currentScale + 4.0f)) * positionFactor : (float)(this.field_230690_l_ + this.field_230688_j_ + 4) * positionFactor;
                int color = this.getCurrentTextColor(matrixStack, mouseX, mouseY, partialTicks).getColorARGB();
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(currentScale, currentScale, 0.0f);
                if (this.dropShadow) {
                    fontRenderer.func_243246_a(matrixStack, this.getCurrentText(), xStart, yStart, color);
                } else {
                    fontRenderer.func_243248_b(matrixStack, this.getCurrentText(), xStart, yStart, color);
                }
                matrixStack.func_227865_b_();
            }
        }
    }

    @Override
    public float getCurrentScale(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        return this.scale;
    }
}

