/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.u_team_core.util.RGBA;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class ProgressBar
extends AbstractGui
implements IGuiEventListener,
IRenderable {
    protected Supplier<Double> progress;
    protected Consumer<Double> click;
    protected int width = 200;
    protected int height = 5;
    protected int x;
    protected int y;
    protected RGBA backgroundColor;
    protected RGBA progressColor;
    protected boolean enabled = true;
    protected boolean visible = true;
    protected boolean hovered;

    public ProgressBar(int x, int y, int width, int height, RGBA backgroundColor, RGBA progressColor, Supplier<Double> progress, Consumer<Double> click) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.backgroundColor = backgroundColor;
        this.progressColor = progressColor;
        this.progress = progress;
        this.click = click;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            ProgressBar.func_238467_a_((MatrixStack)matrixStack, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.backgroundColor.getColorARGB());
            ProgressBar.func_238467_a_((MatrixStack)matrixStack, (int)this.x, (int)this.y, (int)((int)((double)this.x + this.progress.get() * (double)this.width)), (int)(this.y + this.height), (int)this.progressColor.getColorARGB());
        }
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.click != null) {
            this.click.accept((mouseX - (double)this.x) / (double)this.width);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isPressable(mouseX, mouseY)) {
            this.playPressSound(Minecraft.func_71410_x().func_147118_V());
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected boolean isPressable(double mouseX, double mouseY) {
        return this.enabled && this.visible && mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
    }

    public void playPressSound(SoundHandler soundHandler) {
        soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public void setProgressSupplier(Supplier<Double> progress) {
        this.progress = progress;
    }

    public double getProgress() {
        return this.progress.get();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public RGBA getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(RGBA backGroundColor) {
        this.backgroundColor = backGroundColor;
    }

    public RGBA getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(RGBA progressColor) {
        this.progressColor = progressColor;
    }

    public void setClick(Consumer<Double> click) {
        this.click = click;
    }
}

