/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.util.GuiUtil;
import info.u_team.u_team_core.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class CheckboxButton
extends UButton {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/checkbox.png");
    protected boolean checked;
    protected boolean drawText;
    protected boolean leftSideText;
    protected boolean dropShadow;

    public CheckboxButton(int x, int y, int width, int height, ITextComponent text, boolean checked, boolean drawText) {
        this(x, y, width, height, text, checked, drawText, EMTPY_PRESSABLE);
    }

    public CheckboxButton(int x, int y, int width, int height, ITextComponent text, boolean checked, boolean drawText, Button.IPressable pessable) {
        this(x, y, width, height, text, checked, drawText, pessable, field_238486_s_);
    }

    public CheckboxButton(int x, int y, int width, int height, ITextComponent text, boolean checked, boolean drawText, Button.ITooltip tooltip) {
        this(x, y, width, height, text, checked, drawText, EMTPY_PRESSABLE, tooltip);
    }

    public CheckboxButton(int x, int y, int width, int height, ITextComponent text, boolean checked, boolean drawText, Button.IPressable pessable, Button.ITooltip tooltip) {
        super(x, y, width, height, text, pessable, tooltip);
        this.checked = checked;
        this.drawText = drawText;
        this.leftSideText = false;
        this.dropShadow = false;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isDrawText() {
        return this.drawText;
    }

    public void setDrawText(boolean drawText) {
        this.drawText = drawText;
    }

    public boolean isLeftSideText() {
        return this.leftSideText;
    }

    public void setLeftSideText(boolean leftSideText) {
        this.leftSideText = leftSideText;
    }

    public void toggle() {
        this.checked = !this.checked;
    }

    public void func_230930_b_() {
        this.toggle();
        super.func_230930_b_();
    }

    @Override
    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(TEXTURE);
        RenderUtil.enableBlend();
        RenderUtil.defaultBlendFunc();
        GuiUtil.drawTexturedColoredQuad(matrixStack, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, 20, 20, this.func_230449_g_() ? 20.0f : 0.0f, this.checked ? 20.0f : 0.0f, 64, 64, 0.0f, this.getCurrentBackgroundColor(matrixStack, mouseX, mouseY, partialTicks));
        RenderUtil.disableBlend();
        this.renderBackground(matrixStack, minecraft, mouseX, mouseY, partialTicks);
        this.renderForeground(matrixStack, minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.drawText) {
            FontRenderer fontRenderer = minecraft.field_71466_p;
            ITextComponent message = this.getCurrentText();
            if (message != StringTextComponent.field_240750_d_) {
                float yStart = this.field_230691_m_ + (this.field_230689_k_ - 8) / 2;
                float xStart = this.leftSideText ? (float)(this.field_230690_l_ - (fontRenderer.func_238414_a_((ITextProperties)message) + 4)) : (float)(this.field_230690_l_ + this.field_230688_j_ + 4);
                int color = this.getCurrentTextColor(matrixStack, mouseX, mouseY, partialTicks).getColorARGB();
                if (this.dropShadow) {
                    fontRenderer.func_243246_a(matrixStack, this.getCurrentText(), xStart, yStart, color);
                } else {
                    fontRenderer.func_243248_b(matrixStack, this.getCurrentText(), xStart, yStart, color);
                }
            }
        }
    }
}

