/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.TagsProvider;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class CommonTagsProvider<T>
extends CommonProvider {
    protected final Registry<T> registry;
    protected final Map<ResourceLocation, ITag.Builder> tagToBuilder;
    protected final ExistingFileHelper.IResourceType resourceType;

    public CommonTagsProvider(GenerationData data, Registry<T> registry) {
        super(data);
        this.registry = registry;
        this.tagToBuilder = Maps.newLinkedHashMap();
        this.resourceType = new ExistingFileHelper.ResourceType(ResourcePackType.SERVER_DATA, ".json", "tags/" + this.getTagFolder());
    }

    protected abstract void registerTags();

    public void func_200398_a(DirectoryCache cache) {
        this.tagToBuilder.clear();
        this.registerTags();
        this.tagToBuilder.forEach((location, builder) -> {
            List list = builder.func_232963_b_(id -> this.tagToBuilder.containsKey(id) ? Tag.func_241284_a_() : null, id -> this.registry.func_241873_b(id).orElse(null)).filter(this::missing).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", location, list.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonObject object = builder.func_232965_c_();
            Path path = this.makePath((ResourceLocation)location);
            try {
                CommonTagsProvider.write(cache, (JsonElement)object, path);
            }
            catch (IOException ex) {
                LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
            }
        });
    }

    private boolean missing(ITag.Proxy proxy) {
        ITag.ITagEntry entry = proxy.func_232968_a_();
        if (entry instanceof ITag.TagEntry) {
            return !this.data.getExistingFileHelper().exists(((ITag.TagEntry)entry).field_200163_a, this.resourceType);
        }
        return false;
    }

    protected abstract String getTagFolder();

    protected Path makePath(ResourceLocation location) {
        return this.resolveData(location).resolve("tags").resolve(this.getTagFolder()).resolve(location.func_110623_a() + ".json");
    }

    protected BetterBuilder<T> getBuilder(ITag.INamedTag<T> tag) {
        ITag.Builder tagBuilder = this.getTagBuilder(tag);
        return new BetterBuilder<T>(tagBuilder, this.registry, this.modid);
    }

    protected ITag.Builder getTagBuilder(ITag.INamedTag<T> tag) {
        return this.tagToBuilder.computeIfAbsent(tag.func_230234_a_(), location -> {
            this.data.getExistingFileHelper().trackGenerated(location, this.resourceType);
            return new UniqueBuilder();
        });
    }

    private static class UniqueBuilder
    extends ITag.Builder {
        private UniqueBuilder() {
        }

        public ITag.Builder func_232954_a_(ITag.Proxy proxyTag) {
            ResourceLocation identifier = this.getIdentifier(proxyTag.func_232968_a_());
            boolean duplicate = this.func_232962_b_().map(ITag.Proxy::func_232968_a_).anyMatch(entry -> this.getIdentifier((ITag.ITagEntry)entry).equals((Object)identifier));
            if (!duplicate) {
                return super.func_232954_a_(proxyTag);
            }
            return this;
        }

        private ResourceLocation getIdentifier(ITag.ITagEntry entry) {
            ResourceLocation identifier;
            if (entry instanceof ITag.ItemEntry) {
                identifier = ((ITag.ItemEntry)entry).field_232969_a_;
            } else if (entry instanceof ITag.OptionalItemEntry) {
                identifier = ((ITag.OptionalItemEntry)entry).field_242200_a;
            } else if (entry instanceof ITag.TagEntry) {
                identifier = ((ITag.TagEntry)entry).field_200163_a;
            } else if (entry instanceof ITag.OptionalTagEntry) {
                identifier = ((ITag.OptionalTagEntry)entry).field_242201_a;
            } else {
                throw new IllegalArgumentException("Unknown implementation of ITagEntry");
            }
            return identifier;
        }
    }

    public static class BetterBuilder<T> {
        private final Registry<T> registry;
        private final TagsProvider.Builder<T> internalBuilder;

        public BetterBuilder(ITag.Builder builder, Registry<T> registry, String id) {
            this.registry = registry;
            this.internalBuilder = new TagsProvider.Builder(builder, registry, id);
        }

        @SafeVarargs
        public final BetterBuilder<T> add(T ... values) {
            this.internalBuilder.func_240534_a_((Object[])values);
            return this;
        }

        @SafeVarargs
        public final BetterBuilder<T> add(ITag.INamedTag<T> ... values) {
            this.internalBuilder.addTags(values);
            return this;
        }

        @SafeVarargs
        public final BetterBuilder<T> addOptional(T ... values) {
            Stream.of(values).map(arg_0 -> this.registry.func_177774_c(arg_0)).forEach(arg_0 -> this.internalBuilder.addOptional(arg_0));
            return this;
        }

        @SafeVarargs
        public final BetterBuilder<T> addOptional(ITag.INamedTag<T> ... values) {
            Stream.of(values).map(ITag.INamedTag::func_230234_a_).forEach(arg_0 -> this.internalBuilder.addOptionalTag(arg_0));
            return this;
        }

        public BetterBuilder<T> add(T value) {
            this.internalBuilder.func_240532_a_(value);
            return this;
        }

        public BetterBuilder<T> add(ITag.INamedTag<T> value) {
            this.internalBuilder.func_240531_a_(value);
            return this;
        }

        public BetterBuilder<T> addOptional(ResourceLocation location) {
            this.internalBuilder.addOptional(location);
            return this;
        }

        public BetterBuilder<T> addOptionalTag(ResourceLocation location) {
            this.internalBuilder.addOptionalTag(location);
            return this;
        }
    }
}

