/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DirectoryCache;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class CommonLanguagesProvider
extends CommonProvider {
    protected final Map<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();

    public CommonLanguagesProvider(GenerationData data) {
        super(data);
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.addTranslations();
        this.data.forEach((locale, map) -> {
            if (!map.isEmpty()) {
                try {
                    CommonLanguagesProvider.write(cache, GSON.toJsonTree(map), this.resolveModAssets().resolve("lang").resolve(locale + ".json"));
                }
                catch (IOException ex) {
                    LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
                }
            }
        });
    }

    public abstract void addTranslations();

    public String func_200397_b() {
        return "Languages";
    }

    protected void add(ItemGroup key, String name) {
        ITextComponent component = key.func_242392_c();
        if (component instanceof TranslationTextComponent) {
            this.add(((TranslationTextComponent)component).func_150268_i(), name);
        }
    }

    protected void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Block key, String name) {
        this.add(key.func_149739_a(), name);
    }

    protected void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Item key, String name) {
        this.add(key.func_77658_a(), name);
    }

    protected void addItemStack(Supplier<? extends ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(ItemStack key, String name) {
        this.add(key.func_77977_a(), name);
    }

    protected void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Enchantment key, String name) {
        this.add(key.func_77320_a(), name);
    }

    protected void addEffect(Supplier<? extends Effect> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Effect key, String name) {
        this.add(key.func_76393_a(), name);
    }

    protected void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(EntityType<?> key, String name) {
        this.add(key.func_210760_d(), name);
    }

    protected void add(Supplier<? extends Fluid> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Fluid key, String name) {
        this.add(key.getAttributes().getTranslationKey(), name);
    }

    protected void add(String key, String value) {
        this.add("en_us", key, value);
    }

    protected void add(String locale, ItemGroup key, String name) {
        ITextComponent component = key.func_242392_c();
        if (component instanceof TranslationTextComponent) {
            this.add(locale, ((TranslationTextComponent)component).func_150268_i(), name);
        }
    }

    protected void addBlock(String locale, Supplier<? extends Block> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Block key, String name) {
        this.add(locale, key.func_149739_a(), name);
    }

    protected void addItem(String locale, Supplier<? extends Item> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Item key, String name) {
        this.add(locale, key.func_77658_a(), name);
    }

    protected void addItemStack(String locale, Supplier<? extends ItemStack> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, ItemStack key, String name) {
        this.add(locale, key.func_77977_a(), name);
    }

    protected void addEnchantment(String locale, Supplier<? extends Enchantment> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Enchantment key, String name) {
        this.add(locale, key.func_77320_a(), name);
    }

    protected void addEffect(String locale, Supplier<? extends Effect> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Effect key, String name) {
        this.add(locale, key.func_76393_a(), name);
    }

    protected void addEntityType(String locale, Supplier<? extends EntityType<?>> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, EntityType<?> key, String name) {
        this.add(locale, key.func_210760_d(), name);
    }

    protected void addFluid(String locale, Supplier<? extends Fluid> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Fluid key, String name) {
        this.add(locale, key.getAttributes().getTranslationKey(), name);
    }

    protected void add(String locale, String key, String value) {
        Map map = this.data.computeIfAbsent(locale, unused -> new TreeMap());
        if (map.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }

    protected void addBlockTooltip(Supplier<? extends Block> key, String category, int line, String value) {
        this.addItemTooltip(() -> ((Block)key.get()).func_199767_j(), category, line, value);
    }

    protected void addBlockTooltip(String locale, Supplier<? extends Block> key, String category, int line, String value) {
        this.addItemTooltip(locale, () -> ((Block)key.get()).func_199767_j(), category, line, value);
    }

    protected void addItemTooltip(Supplier<? extends Item> key, String category, int line, String value) {
        if (!category.isEmpty()) {
            category = category + ".";
        }
        this.add(key.get().func_77658_a() + ".tooltip." + category + line, value);
    }

    protected void addItemTooltip(String locale, Supplier<? extends Item> key, String category, int line, String value) {
        if (!category.isEmpty()) {
            category = category + ".";
        }
        this.add(locale, key.get().func_77658_a() + ".tooltip." + category + line, value);
    }

    protected void addTooltip(String key, String category, int line, String value) {
        if (!category.isEmpty()) {
            category = category + ".";
        }
        this.add("general." + this.modid + "." + key + ".tooltip." + category + line, value);
    }

    protected void addTooltip(String locale, String key, String category, int line, String value) {
        if (!category.isEmpty()) {
            category = category + ".";
        }
        this.add(locale, "general." + this.modid + "." + key + ".tooltip." + category + line, value);
    }
}

