/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api;

import info.u_team.u_team_core.api.sync.IInitSyncedTileEntity;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public interface ITileEntityBlock {
    public TileEntityType<?> getTileEntityType(IBlockReader var1, BlockPos var2);

    default public ActionResultType openContainer(World world, BlockPos pos, PlayerEntity player) {
        return this.openContainer(world, pos, player, false);
    }

    default public ActionResultType openContainer(World world, BlockPos pos, PlayerEntity player, boolean canOpenSneak) {
        if (world.field_72995_K || !(player instanceof ServerPlayerEntity)) {
            return ActionResultType.SUCCESS;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        Optional tileEntityOptional = this.isTileEntityFromType((IBlockReader)world, pos);
        if (!tileEntityOptional.isPresent()) {
            return ActionResultType.PASS;
        }
        TileEntity tileEntity = (TileEntity)tileEntityOptional.get();
        if (!(tileEntity instanceof INamedContainerProvider)) {
            return ActionResultType.PASS;
        }
        if (!canOpenSneak && serverPlayer.func_225608_bj_()) {
            return ActionResultType.SUCCESS;
        }
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        if (tileEntity instanceof IInitSyncedTileEntity) {
            ((IInitSyncedTileEntity)tileEntity).sendInitialDataBuffer(buffer);
        }
        NetworkHooks.openGui((ServerPlayerEntity)serverPlayer, (INamedContainerProvider)((INamedContainerProvider)tileEntity), extraData -> {
            extraData.func_179255_a(pos);
            extraData.func_150787_b(buffer.readableBytes());
            extraData.writeBytes((ByteBuf)buffer);
        });
        return ActionResultType.SUCCESS;
    }

    default public <T extends TileEntity> Optional<T> isTileEntityFromType(IBlockReader world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || this.getTileEntityType(world, pos) != tileEntity.func_200662_C()) {
            return Optional.empty();
        }
        return Optional.of(tileEntity);
    }
}

