/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.data.provider;

import info.u_team.u_team_core.data.CommonRecipesProvider;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.useful_railroads.data.builder.FuelRecipeBuilder;
import info.u_team.useful_railroads.init.UsefulRailroadsBlocks;
import info.u_team.useful_railroads.init.UsefulRailroadsItems;
import info.u_team.useful_railroads.init.UsefulRailroadsRecipeSerializers;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.data.CustomRecipeBuilder;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class UsefulRailroadsRecipesProvider
extends CommonRecipesProvider {
    public UsefulRailroadsRecipesProvider(GenerationData data) {
        super(data);
    }

    protected void registerRecipes(Consumer<IFinishedRecipe> consumer) {
        this.registerCraftingRecipes(consumer);
        this.registerFuelRecipes(consumer);
    }

    private void registerCraftingRecipes(Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsBlocks.HIGHSPEED_RAIL.get(), (int)24).func_200472_a("IDI").func_200472_a("LSL").func_200472_a("IRI").func_200471_a(Character.valueOf('R'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.DUSTS_REDSTONE)).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('I'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.INGOTS_IRON)).func_200471_a(Character.valueOf('D'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.GEMS_DIAMOND)).func_200471_a(Character.valueOf('L'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.GEMS_LAPIS)).func_200465_a("has_minecart", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsBlocks.SPEED_CLAMP_RAIL.get(), (int)24).func_200472_a("IDI").func_200472_a("LSL").func_200472_a("IRI").func_200471_a(Character.valueOf('R'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.DUSTS_REDSTONE)).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('I'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.INGOTS_IRON)).func_200471_a(Character.valueOf('D'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.GEMS_DIAMOND)).func_200471_a(Character.valueOf('L'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.SLIMEBALLS)).func_200465_a("has_minecart", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsBlocks.DIRECTION_RAIL.get(), (int)16).func_200472_a("IEI").func_200472_a("IRI").func_200472_a("ISI").func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('R'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.DUSTS_REDSTONE)).func_200471_a(Character.valueOf('I'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.INGOTS_IRON)).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_222027_iT).func_200465_a("has_minecart", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsBlocks.TELEPORT_RAIL.get(), (int)1).func_200472_a("IDI").func_200472_a("ESE").func_200472_a("IRI").func_200471_a(Character.valueOf('R'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.DUSTS_REDSTONE)).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('I'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.INGOTS_IRON)).func_200471_a(Character.valueOf('D'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.GEMS_DIAMOND)).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151079_bi).func_200465_a("has_minecart", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsBlocks.INTERSECTION_RAIL.get(), (int)8).func_200472_a("III").func_200472_a("ISI").func_200472_a("III").func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('I'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.INGOTS_IRON)).func_200465_a("has_minecart", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)UsefulRailroadsBlocks.BUFFER_STOP.get(), (int)2).func_200472_a("III").func_200472_a(" B ").func_200472_a("I I").func_200471_a(Character.valueOf('B'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.STORAGE_BLOCKS_IRON)).func_200471_a(Character.valueOf('I'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.INGOTS_IRON)).func_200465_a("has_minecart", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)UsefulRailroadsItems.SINGLE_TRACK_BUILDER.get()), (int)1).func_200472_a("IBI").func_200472_a("PRC").func_200472_a("IAI").func_200471_a(Character.valueOf('I'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.INGOTS_IRON)).func_200471_a(Character.valueOf('B'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.STORAGE_BLOCKS_REDSTONE)).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_222027_iT).func_200471_a(Character.valueOf('R'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.DUSTS_REDSTONE)).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_222029_iU).func_200462_a(Character.valueOf('A'), (IItemProvider)Items.field_221666_au).func_200465_a("has_redstone", (ICriterionInstance)this.hasItem((ITag)Tags.Items.DUSTS_REDSTONE)).func_200465_a("has_iron", (ICriterionInstance)this.hasItem((ITag)Tags.Items.INGOTS_IRON)).func_200465_a("has_rail", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_221666_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)UsefulRailroadsItems.DOUBLE_TRACK_BUILDER.get()), (int)1).func_200472_a("IBI").func_200472_a("PRC").func_200472_a("AIA").func_200471_a(Character.valueOf('I'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.STORAGE_BLOCKS_IRON)).func_200471_a(Character.valueOf('B'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.STORAGE_BLOCKS_REDSTONE)).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_222027_iT).func_200471_a(Character.valueOf('R'), UsefulRailroadsRecipesProvider.getIngredientOfTag((ITag)Tags.Items.DUSTS_REDSTONE)).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_222029_iU).func_200462_a(Character.valueOf('A'), (IItemProvider)Items.field_221666_au).func_200465_a("has_redstone", (ICriterionInstance)this.hasItem((ITag)Tags.Items.DUSTS_REDSTONE)).func_200465_a("has_iron", (ICriterionInstance)this.hasItem((ITag)Tags.Items.INGOTS_IRON)).func_200465_a("has_rail", (ICriterionInstance)this.hasItem((IItemProvider)Items.field_221666_au)).func_200464_a(consumer);
        CustomRecipeBuilder.func_218656_a((SpecialRecipeSerializer)((SpecialRecipeSerializer)UsefulRailroadsRecipeSerializers.CRAFTING_SPECIAL_TELEPORT_RAIL_REMOVE_LOCATION.get())).func_200499_a(consumer, "usefulrailroads:teleport_rail_remove_location");
    }

    private void registerFuelRecipes(Consumer<IFinishedRecipe> consumer) {
        this.addTeleportRailFuel(Items.field_151079_bi, 100, consumer, "ender_pearl");
        this.addTeleportRailFuel(Items.field_151061_bv, 150, consumer, "ender_eye");
        this.addTeleportRailFuel(Items.field_221663_bT, 250, consumer, "chorus_flower");
        this.addTeleportRailFuel(Items.field_185161_cS, 200, consumer, "chorus_fruit");
        this.addTeleportRailFuel(Items.field_185162_cT, 210, consumer, "popped_chorus_fruit");
        this.addTeleportRailFuel((ITag<Item>)Tags.Items.DUSTS_REDSTONE, 5, consumer, "redstone_dusts");
        this.addTeleportRailFuel((ITag<Item>)Tags.Items.INGOTS_GOLD, 10, consumer, "gold_ingots");
        this.addTeleportRailFuel((ITag<Item>)Tags.Items.GEMS_DIAMOND, 50, consumer, "diamond_gems");
        this.addTrackBuilderFuel((ITag<Item>)ItemTags.field_219775_L, 100, consumer, "coals");
        this.addTrackBuilderFuel((ITag<Item>)Tags.Items.STORAGE_BLOCKS_COAL, 900, consumer, "coal_blocks");
    }

    private void addTeleportRailFuel(Item item, int fuel, Consumer<IFinishedRecipe> consumer, String name) {
        this.addTeleportRailFuel(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), this.hasItem((IItemProvider)item), fuel, consumer, name);
    }

    private void addTeleportRailFuel(ITag<Item> tag, int fuel, Consumer<IFinishedRecipe> consumer, String name) {
        this.addTeleportRailFuel(UsefulRailroadsRecipesProvider.getIngredientOfTag(tag), this.hasItem(tag), fuel, consumer, name);
    }

    private void addTeleportRailFuel(Ingredient ingredient, InventoryChangeTrigger.Instance trigger, int fuel, Consumer<IFinishedRecipe> consumer, String name) {
        FuelRecipeBuilder.teleportRailFuel(ingredient, fuel).addCriterion("has_ingredient", (ICriterionInstance)trigger).build(consumer, new ResourceLocation("usefulrailroads", "fuel/teleport_rail/" + name));
    }

    private void addTrackBuilderFuel(ITag<Item> tag, int fuel, Consumer<IFinishedRecipe> consumer, String name) {
        this.addTrackBuilderFuel(UsefulRailroadsRecipesProvider.getIngredientOfTag(tag), this.hasItem(tag), fuel, consumer, name);
    }

    private void addTrackBuilderFuel(Ingredient ingredient, InventoryChangeTrigger.Instance trigger, int fuel, Consumer<IFinishedRecipe> consumer, String name) {
        FuelRecipeBuilder.trackBuilderFuel(ingredient, fuel).addCriterion("has_ingredient", (ICriterionInstance)trigger).build(consumer, new ResourceLocation("usefulrailroads", "fuel/track_builder/" + name));
    }
}

