/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.UniversalGrid.item;

import com.YTrollman.UniversalGrid.UniversalGrid;
import com.YTrollman.UniversalGrid.config.UniversalGridConfig;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.INetworkAwareGrid;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.FluidGridStorageCacheListener;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.tile.grid.WirelessGrid;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class WirelessUniversalGrid
extends WirelessGrid {
    @Nullable
    private final MinecraftServer server;
    private final World world;
    private Set<ICraftingGridListener> listeners = new HashSet<ICraftingGridListener>();
    private Container craftingContainer = new Container(null, 0){

        public boolean func_75145_c(PlayerEntity player) {
            return false;
        }

        public void func_75130_a(IInventory inventory) {
            if (WirelessUniversalGrid.this.server != null) {
                WirelessUniversalGrid.this.onCraftingMatrixChanged();
            }
        }
    };
    private ICraftingRecipe currentRecipe;
    private CraftingInventory matrix = new CraftingInventory(this.craftingContainer, 3, 3);
    private CraftResultInventory result = new CraftResultInventory();
    private final int gridType;

    public WirelessUniversalGrid(ItemStack stack, World world, @Nullable MinecraftServer server, PlayerSlot slot) {
        super(stack, server, slot);
        this.server = server;
        this.world = world;
        this.gridType = stack.func_77978_p().func_74762_e("gridType");
        if (stack.func_77942_o()) {
            StackUtils.readItems((IInventory)this.matrix, (int)1, (CompoundNBT)stack.func_77978_p());
        }
    }

    public ITextComponent getTitle() {
        return new TranslationTextComponent("gui.universalgrid.universal_grid");
    }

    public GridType getGridType() {
        if (this.gridType == 0) {
            return GridType.NORMAL;
        }
        if (this.gridType == 1) {
            return GridType.CRAFTING;
        }
        if (this.gridType == 2) {
            return GridType.FLUID;
        }
        return null;
    }

    public CraftingInventory getCraftingMatrix() {
        return this.matrix;
    }

    public CraftResultInventory getCraftingResult() {
        return this.result;
    }

    public IStorageCacheListener createListener(ServerPlayerEntity player) {
        if (this.getGridType() != GridType.FLUID) {
            return super.createListener(player);
        }
        return new FluidGridStorageCacheListener(player, this.getNetwork());
    }

    @Nullable
    public IStorageCache getStorageCache() {
        if (this.getGridType() != GridType.FLUID) {
            return super.getStorageCache();
        }
        INetwork network = this.getNetwork();
        return network != null ? network.getFluidStorageCache() : null;
    }

    @Nullable
    public IItemGridHandler getItemHandler() {
        if (this.getGridType() != GridType.FLUID) {
            return super.getItemHandler();
        }
        return null;
    }

    @Nullable
    public IFluidGridHandler getFluidHandler() {
        if (this.getGridType() != GridType.FLUID) {
            return null;
        }
        INetwork network = this.getNetwork();
        return network != null ? network.getFluidGridHandler() : null;
    }

    public void onCraftingMatrixChanged() {
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((IInventory)this.matrix, this.world)) {
            this.currentRecipe = this.world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.matrix, this.world).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.result.func_70299_a(0, ItemStack.field_190927_a);
        } else {
            this.result.func_70299_a(0, this.currentRecipe.func_77572_b((IInventory)this.matrix));
        }
        this.listeners.forEach(ICraftingGridListener::onCraftingMatrixChanged);
        if (!this.getStack().func_77942_o()) {
            this.getStack().func_77982_d(new CompoundNBT());
        }
        StackUtils.writeItems((IInventory)this.matrix, (int)1, (CompoundNBT)this.getStack().func_77978_p());
    }

    public void onCrafted(PlayerEntity player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
        UniversalGrid.RSAPI.getCraftingGridBehavior().onCrafted((INetworkAwareGrid)this, this.currentRecipe, player, availableItems, usedItems);
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemManager().drainEnergy(player, ((Integer)UniversalGridConfig.UNIVERSAL_GRID_CRAFT_USAGE.get()).intValue());
        }
    }

    public void onClear(PlayerEntity player) {
        INetwork network = this.getNetwork();
        if (network != null && network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
                ItemStack slot = this.matrix.func_70301_a(i);
                if (slot.func_190926_b()) continue;
                this.matrix.func_70299_a(i, network.insertItem(slot, slot.func_190916_E(), Action.PERFORM));
                network.getItemStorageTracker().changed(player, (Object)slot.func_77946_l());
            }
            network.getNetworkItemManager().drainEnergy(player, ((Integer)UniversalGridConfig.UNIVERSAL_GRID_CLEAR_USAGE.get()).intValue());
        }
    }

    public void onCraftedShift(PlayerEntity player) {
        UniversalGrid.RSAPI.getCraftingGridBehavior().onCraftedShift((INetworkAwareGrid)this, player);
    }

    public void onRecipeTransfer(PlayerEntity player, ItemStack[][] recipe) {
        UniversalGrid.RSAPI.getCraftingGridBehavior().onRecipeTransfer((INetworkAwareGrid)this, player, recipe);
    }

    public void addCraftingListener(ICraftingGridListener listener) {
        this.listeners.add(listener);
    }

    public void removeCraftingListener(ICraftingGridListener listener) {
        this.listeners.remove(listener);
    }
}

