/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.duck;

import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.untitledduckmod.ModEntityTypes;
import net.untitledduckmod.ModItems;
import net.untitledduckmod.ModSoundEvents;
import net.untitledduckmod.duck.DuckCleanGoal;
import net.untitledduckmod.duck.DuckDiveGoal;
import net.untitledduckmod.duck.DuckSwimGoal;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DuckEntity
extends AnimalEntity
implements IAnimatable {
    public static final String EGG_LAY_TIME_TAG = "duckEggLayTime";
    public static final String VARIANT_TAG = "duckVariant";
    public static final String IS_FROM_SACK_TAG = "isFromSack";
    public static final float SWIM_SPEED_MULTIPLIER = 3.0f;
    protected static final DataParameter<Byte> VARIANT = EntityDataManager.func_187226_a(TameableEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> ANIMATION = EntityDataManager.func_187226_a(TameableEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final byte ANIMATION_IDLE = 0;
    protected static final byte ANIMATION_CLEAN = 1;
    protected static final byte ANIMATION_DIVE = 2;
    protected static final byte ANIMATION_DANCE = 3;
    protected static final byte ANIMATION_PANIC = 4;
    private static final AnimationBuilder WALK_ANIM = new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true));
    private static final AnimationBuilder IDLE_ANIM = new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true));
    private static final AnimationBuilder SWIM_ANIM = new AnimationBuilder().addAnimation("swim", Boolean.valueOf(true));
    private static final AnimationBuilder SWIM_IDLE_ANIM = new AnimationBuilder().addAnimation("idle_swim", Boolean.valueOf(true));
    private static final AnimationBuilder CLEAN_ANIM = new AnimationBuilder().addAnimation("clean");
    private static final AnimationBuilder SWIM_CLEAN_ANIM = new AnimationBuilder().addAnimation("clean_swim");
    private static final AnimationBuilder DIVE_ANIM = new AnimationBuilder().addAnimation("dive");
    private static final AnimationBuilder DANCE_ANIM = new AnimationBuilder().addAnimation("dance", Boolean.valueOf(true));
    private static final AnimationBuilder FLY_ANIM = new AnimationBuilder().addAnimation("fly", Boolean.valueOf(true));
    private static final AnimationBuilder PANIC_ANIM = new AnimationBuilder().addAnimation("panic", Boolean.valueOf(true));
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    private static final int MIN_EGG_LAY_TIME = 6000;
    private static final int MAX_EGG_LAY_TIME = 12000;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int eggLayTime = this.field_70146_Z.nextInt(6000) + 6000;
    private boolean isFlapping;
    private boolean wasSongPlaying = false;
    private boolean panicked = false;
    private boolean isFromSack = false;

    public DuckEntity(EntityType<? extends AnimalEntity> entityType, World world) {
        super(entityType, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public static AttributeModifierMap.MutableAttribute getDefaultAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 7.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        byte variant = (byte)this.field_70146_Z.nextInt(2);
        this.field_70180_af.func_187214_a(VARIANT, (Object)variant);
        this.field_70180_af.func_187214_a(ANIMATION, (Object)0);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74774_a(VARIANT_TAG, this.getVariant());
        tag.func_74768_a(EGG_LAY_TIME_TAG, this.eggLayTime);
        tag.func_74757_a(IS_FROM_SACK_TAG, this.isFromSack);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setVariant(tag.func_74771_c(VARIANT_TAG));
        if (tag.func_74764_b(EGG_LAY_TIME_TAG)) {
            this.eggLayTime = tag.func_74762_e(EGG_LAY_TIME_TAG);
        }
        this.setFromSack(tag.func_74767_n(IS_FROM_SACK_TAG));
    }

    public byte getVariant() {
        return (Byte)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(byte variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public byte getAnimation() {
        return (Byte)this.field_70180_af.func_187225_a(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.field_70180_af.func_187227_b(ANIMATION, (Object)animation);
    }

    public void func_191987_a(BlockPos songPosition, boolean playing) {
        if (playing && !this.wasSongPlaying) {
            this.setAnimation((byte)3);
            this.wasSongPlaying = true;
        } else if (!playing && this.wasSongPlaying) {
            this.setAnimation((byte)0);
            this.wasSongPlaying = false;
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new DuckSwimGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.6));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, BREEDING_INGREDIENT));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new DuckCleanGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new DuckDiveGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_INGREDIENT.test(stack);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70089_S() && !this.func_70631_g_() && --this.eggLayTime <= 0) {
                this.func_184185_a(ModSoundEvents.getDuckEggSound(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_199703_a((IItemProvider)ModItems.getDuckEgg());
                this.eggLayTime = this.field_70146_Z.nextInt(6000) + 6000;
            }
            Vector3d velocity = this.func_213322_ci();
            if (!this.field_70122_E && velocity.field_72448_b < 0.0) {
                this.func_213317_d(velocity.func_216372_d(1.0, 0.6, 1.0));
            }
            if (!this.panicked && this.func_70643_av() != null || this.func_70027_ad()) {
                this.setAnimation((byte)4);
                this.panicked = true;
            } else if (this.panicked && this.func_70643_av() == null && !this.func_70027_ad()) {
                this.setAnimation((byte)0);
                this.panicked = false;
            }
        }
        this.isFlapping = this.field_70170_p.field_72995_K && !this.func_70090_H() && !this.field_70122_E;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stackInHand = player.func_184586_b(hand);
        if (stackInHand.func_77973_b() == ModItems.getEmptyDuckSack()) {
            CompoundNBT duckData = new CompoundNBT();
            if (this.func_184198_c(duckData)) {
                stackInHand.func_190918_g(1);
                ItemStack duckSack = new ItemStack((IItemProvider)ModItems.getDuckSack());
                CompoundNBT sackData = new CompoundNBT();
                sackData.func_218657_a("EntityTag", (INBT)duckData);
                duckSack.func_77982_d(sackData);
                if (stackInHand.func_190926_b()) {
                    player.func_184611_a(hand, duckSack);
                } else if (!player.field_71071_by.func_70441_a(duckSack)) {
                    player.func_71019_a(duckSack, false);
                }
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), ModSoundEvents.getDuckSackUse(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            } else {
                field_184243_a.error("Could not save duck data to duck sack!");
            }
            this.func_70106_y();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity entity) {
        return (AgeableEntity)ModEntityTypes.getDuck().func_200721_a((World)world);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public boolean lookingAround() {
        return this.getAnimation() != 1;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean inWater = this.func_70090_H();
        AnimationController controller = event.getController();
        if (this.isFlapping) {
            controller.setAnimation(FLY_ANIM);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 1: {
                controller.setAnimation(inWater ? SWIM_CLEAN_ANIM : CLEAN_ANIM);
                break;
            }
            case 2: {
                controller.setAnimation(DIVE_ANIM);
                break;
            }
            case 3: {
                controller.setAnimation(DANCE_ANIM);
                break;
            }
            case 4: {
                controller.setAnimation(PANIC_ANIM);
                break;
            }
            default: {
                if (inWater) {
                    controller.setAnimation(isMoving ? SWIM_ANIM : SWIM_IDLE_ANIM);
                    break;
                }
                controller.setAnimation(isMoving ? WALK_ANIM : IDLE_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void func_70642_aH() {
        if (this.func_70631_g_()) {
            this.func_184185_a(ModSoundEvents.getDucklingAmbientSound(), 0.3f, this.func_70647_i());
            return;
        }
        this.func_184185_a(ModSoundEvents.getDuckAmbientSound(), 0.1f, this.func_70647_i());
    }

    protected void func_184581_c(DamageSource source) {
        if (this.func_70631_g_()) {
            this.func_184185_a(ModSoundEvents.getDucklingHurtSound(), 0.3f, this.func_70647_i() + 0.25f);
            return;
        }
        this.func_184185_a(ModSoundEvents.getDuckHurtSound(), 0.1f, this.func_70647_i() + 0.5f);
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        if (this.func_70631_g_()) {
            return ModSoundEvents.getDucklingDeathSound();
        }
        return ModSoundEvents.getDuckDeathSound();
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(ModSoundEvents.getDuckStepSound(), 0.15f, 1.0f);
    }

    protected void func_180466_bG(ITag<Fluid> fluid) {
        if (this.func_70661_as().func_212238_t()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)0.04f, 0.0));
        } else {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.3, 0.0));
        }
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.isFromSack;
    }

    public boolean isFromSack() {
        return this.isFromSack;
    }

    public void setFromSack(boolean fromSack) {
        this.isFromSack = fromSack;
    }
}

