/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.LongFunction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import twilightforest.world.TFDimensions;
import twilightforest.world.layer.GenLayerTFBiomeStabilize;
import twilightforest.world.layer.GenLayerTFBiomes;
import twilightforest.world.layer.GenLayerTFCompanionBiomes;
import twilightforest.world.layer.GenLayerTFKeyBiomes;
import twilightforest.world.layer.GenLayerTFRiverMix;
import twilightforest.world.layer.GenLayerTFStream;
import twilightforest.world.layer.GenLayerTFThornBorder;
import twilightforest.worldgen.biomes.BiomeKeys;

public class TFBiomeProvider
extends BiomeProvider {
    public static final Codec<TFBiomeProvider> TF_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().orElseGet(() -> TFDimensions.seed).forGetter(obj -> obj.seed), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(provider -> provider.registry)).apply((Applicative)instance, instance.stable(TFBiomeProvider::new)));
    private static final List<RegistryKey<Biome>> BIOMES = ImmutableList.of(BiomeKeys.LAKE, BiomeKeys.FOREST, BiomeKeys.DENSE_FOREST, BiomeKeys.HIGHLANDS, BiomeKeys.MUSHROOM_FOREST, BiomeKeys.SWAMP, BiomeKeys.STREAM, BiomeKeys.SNOWY_FOREST, BiomeKeys.GLACIER, BiomeKeys.CLEARING, BiomeKeys.OAK_SAVANNAH, BiomeKeys.FIREFLY_FOREST, (Object[])new RegistryKey[]{BiomeKeys.DENSE_MUSHROOM_FOREST, BiomeKeys.DARK_FOREST, BiomeKeys.ENCHANTED_FOREST, BiomeKeys.FIRE_SWAMP, BiomeKeys.DARK_FOREST_CENTER, BiomeKeys.FINAL_PLATEAU, BiomeKeys.THORNLANDS, BiomeKeys.SPOOKY_FOREST});
    private final Registry<Biome> registry;
    private final Layer genBiomes;
    private final long seed;

    public TFBiomeProvider(long seed, Registry<Biome> registryIn) {
        super(BIOMES.stream().map(RegistryKey::func_240901_a_).map(arg_0 -> registryIn.func_241873_b(arg_0)).filter(Optional::isPresent).map(opt -> opt::get));
        this.seed = seed;
        this.registry = registryIn;
        this.genBiomes = TFBiomeProvider.makeLayers(seed, registryIn);
    }

    public static int getBiomeId(RegistryKey<Biome> biome, Registry<Biome> registry) {
        return registry.func_148757_b(registry.func_230516_a_(biome));
    }

    private static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> makeLayers(LongFunction<C> seed, Registry<Biome> registry) {
        IAreaFactory biomes = GenLayerTFBiomes.INSTANCE.setup(registry).func_202823_a((IExtendedNoiseRandom)seed.apply(1L));
        biomes = GenLayerTFKeyBiomes.INSTANCE.setup(registry).func_202713_a((IExtendedNoiseRandom)seed.apply(1000L), biomes);
        biomes = GenLayerTFCompanionBiomes.INSTANCE.setup(registry).func_202713_a((IExtendedNoiseRandom)seed.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)seed.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)seed.apply(1001L), biomes);
        biomes = GenLayerTFBiomeStabilize.INSTANCE.func_202713_a((IExtendedNoiseRandom)seed.apply(700L), biomes);
        biomes = GenLayerTFThornBorder.INSTANCE.setup(registry).func_202713_a((IExtendedNoiseRandom)seed.apply(500L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)seed.apply(1002L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)seed.apply(1003L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)seed.apply(1004L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)seed.apply(1005L), biomes);
        IAreaFactory riverLayer = GenLayerTFStream.INSTANCE.setup(registry).func_202713_a((IExtendedNoiseRandom)seed.apply(1L), biomes);
        riverLayer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)seed.apply(7000L), riverLayer);
        biomes = GenLayerTFRiverMix.INSTANCE.setup(registry).func_202707_a((IExtendedNoiseRandom)seed.apply(100L), biomes, riverLayer);
        return biomes;
    }

    public static Layer makeLayers(long seed, final Registry<Biome> registry) {
        IAreaFactory areaFactory = TFBiomeProvider.makeLayers(context -> new LazyAreaLayerContext(25, seed, context), registry);
        return new Layer(areaFactory){

            public Biome func_242936_a(Registry<Biome> p_242936_1_, int p_242936_2_, int p_242936_3_) {
                int i = this.field_215742_b.func_202678_a(p_242936_2_, p_242936_3_);
                Biome biome = (Biome)registry.func_148745_a(i);
                if (biome == null) {
                    throw new IllegalStateException("Unknown biome id emitted by layers: " + i);
                }
                return biome;
            }
        };
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return TF_CODEC;
    }

    public BiomeProvider func_230320_a_(long l) {
        return new TFBiomeProvider(l, this.registry);
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.genBiomes.func_242936_a(this.registry, x, z);
    }
}

