/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.stronghold;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import twilightforest.TFFeature;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.stronghold.StrongholdAccessChamberComponent;
import twilightforest.structures.stronghold.StrongholdAtriumComponent;
import twilightforest.structures.stronghold.StrongholdBalconyRoomComponent;
import twilightforest.structures.stronghold.StrongholdBossRoomComponent;
import twilightforest.structures.stronghold.StrongholdCrossingComponent;
import twilightforest.structures.stronghold.StrongholdDeadEndComponent;
import twilightforest.structures.stronghold.StrongholdEntranceComponent;
import twilightforest.structures.stronghold.StrongholdFoundryComponent;
import twilightforest.structures.stronghold.StrongholdLeftTurnComponent;
import twilightforest.structures.stronghold.StrongholdPieceWeight;
import twilightforest.structures.stronghold.StrongholdRightTurnComponent;
import twilightforest.structures.stronghold.StrongholdShieldStructure;
import twilightforest.structures.stronghold.StrongholdSmallHallwayComponent;
import twilightforest.structures.stronghold.StrongholdSmallStairsComponent;
import twilightforest.structures.stronghold.StrongholdTrainingRoomComponent;
import twilightforest.structures.stronghold.StrongholdTreasureCorridorComponent;
import twilightforest.structures.stronghold.StrongholdTreasureRoomComponent;
import twilightforest.structures.stronghold.StrongholdUpperAscenderComponent;
import twilightforest.structures.stronghold.StrongholdUpperCorridorComponent;
import twilightforest.structures.stronghold.StrongholdUpperLeftTurnComponent;
import twilightforest.structures.stronghold.StrongholdUpperRightTurnComponent;
import twilightforest.structures.stronghold.StrongholdUpperTIntersectionComponent;
import twilightforest.structures.stronghold.StructureTFStrongholdComponent;

public class StrongholdPieces {
    private static final StrongholdPieceWeight[] pieceWeightArray = new StrongholdPieceWeight[]{new StrongholdPieceWeight(StrongholdSmallHallwayComponent::new, 40, 0), new StrongholdPieceWeight(StrongholdLeftTurnComponent::new, 20, 0), new StrongholdPieceWeight(StrongholdCrossingComponent::new, 10, 4), new StrongholdPieceWeight(StrongholdRightTurnComponent::new, 20, 0), new StrongholdPieceWeight(StrongholdDeadEndComponent::new, 5, 0), new StrongholdPieceWeight(StrongholdBalconyRoomComponent::new, 10, 3, 2), new StrongholdPieceWeight(StrongholdTrainingRoomComponent::new, 10, 2), new StrongholdPieceWeight(StrongholdSmallStairsComponent::new, 10, 0), new StrongholdPieceWeight(StrongholdTreasureCorridorComponent::new, 5, 0), new StrongholdPieceWeight(StrongholdAtriumComponent::new, 5, 2, 3), new StrongholdPieceWeight(StrongholdFoundryComponent::new, 5, 1, 4), new StrongholdPieceWeight(StrongholdTreasureRoomComponent::new, 5, 1, 4), new StrongholdPieceWeight(StrongholdBossRoomComponent::new, 10, 1, 4)};
    private List<StrongholdPieceWeight> pieceList;
    static int totalWeight = 0;
    private static StrongholdPieceWeight lastPieceMade;
    public static final IStructurePieceType TFSSH;
    public static final IStructurePieceType TFSLT;
    public static final IStructurePieceType TFSCr;
    public static final IStructurePieceType TFSRT;
    public static final IStructurePieceType TFSDE;
    public static final IStructurePieceType TFSBalR;
    public static final IStructurePieceType TFSTR;
    public static final IStructurePieceType TFSSS;
    public static final IStructurePieceType TFSTC;
    public static final IStructurePieceType TFSAt;
    public static final IStructurePieceType TFSFo;
    public static final IStructurePieceType TFTreaR;
    public static final IStructurePieceType TFSBR;
    public static final IStructurePieceType TFSAC;
    public static final IStructurePieceType TFSEnter;
    public static final IStructurePieceType TFSUA;
    public static final IStructurePieceType TFSULT;
    public static final IStructurePieceType TFSURT;
    public static final IStructurePieceType TFSUCo;
    public static final IStructurePieceType TFSUTI;
    public static final IStructurePieceType TFSShield;

    public void prepareStructurePieces() {
        this.pieceList = new ArrayList<StrongholdPieceWeight>();
        for (StrongholdPieceWeight piece : pieceWeightArray) {
            piece.instancesSpawned = 0;
            this.pieceList.add(piece);
        }
    }

    public void markBossRoomUsed() {
        this.pieceList.remove(this.pieceList.size() - 1);
    }

    private boolean hasMoreLimitedPieces() {
        boolean flag = false;
        totalWeight = 0;
        for (StrongholdPieceWeight piece : this.pieceList) {
            totalWeight += piece.pieceWeight;
            if (piece.instancesLimit <= 0 || piece.instancesSpawned >= piece.instancesLimit) continue;
            flag = true;
        }
        return flag;
    }

    public StructureTFStrongholdComponent getNextComponent(StructurePiece parent, List<StructurePiece> list, Random random, TFFeature feature, int index, Direction facing, int x, int y, int z) {
        if (!this.hasMoreLimitedPieces()) {
            return null;
        }
        block0: for (int i = 0; i < 5; ++i) {
            int counter = random.nextInt(totalWeight);
            for (StrongholdPieceWeight piece : this.pieceList) {
                if ((counter -= piece.pieceWeight) >= 0) continue;
                if (!piece.isDeepEnough(index) || piece == lastPieceMade) continue block0;
                StructureTFStrongholdComponent component = piece.factory.newInstance(feature, index, facing, x, y, z);
                if (StructurePiece.func_74883_a(list, (MutableBoundingBox)component.func_74874_b()) != null) continue;
                ++piece.instancesSpawned;
                if (!piece.canSpawnMoreStructures()) {
                    this.pieceList.remove(piece);
                }
                lastPieceMade = piece;
                return component;
            }
        }
        StrongholdDeadEndComponent deadEnd = new StrongholdDeadEndComponent(parent instanceof TFStructureComponentOld ? ((TFStructureComponentOld)parent).getFeatureType() : TFFeature.NOTHING, index, facing, x, y, z);
        if (StructurePiece.func_74883_a(list, (MutableBoundingBox)deadEnd.func_74874_b()) == null) {
            return deadEnd;
        }
        return null;
    }

    static {
        TFSSH = TFFeature.registerPiece("TFSSH", StrongholdSmallHallwayComponent::new);
        TFSLT = TFFeature.registerPiece("TFSLT", StrongholdLeftTurnComponent::new);
        TFSCr = TFFeature.registerPiece("TFSCr", StrongholdCrossingComponent::new);
        TFSRT = TFFeature.registerPiece("TFSRT", StrongholdRightTurnComponent::new);
        TFSDE = TFFeature.registerPiece("TFSDE", StrongholdDeadEndComponent::new);
        TFSBalR = TFFeature.registerPiece("TFSBalR", StrongholdBalconyRoomComponent::new);
        TFSTR = TFFeature.registerPiece("TFSTR", StrongholdTrainingRoomComponent::new);
        TFSSS = TFFeature.registerPiece("TFSSS", StrongholdSmallStairsComponent::new);
        TFSTC = TFFeature.registerPiece("TFSTC", StrongholdTreasureCorridorComponent::new);
        TFSAt = TFFeature.registerPiece("TFSAt", StrongholdAtriumComponent::new);
        TFSFo = TFFeature.registerPiece("TFSFo", StrongholdFoundryComponent::new);
        TFTreaR = TFFeature.registerPiece("TFTreaR", StrongholdTreasureRoomComponent::new);
        TFSBR = TFFeature.registerPiece("TFSBR", StrongholdBossRoomComponent::new);
        TFSAC = TFFeature.registerPiece("TFSAC", StrongholdAccessChamberComponent::new);
        TFSEnter = TFFeature.registerPiece("TFSEnter", StrongholdEntranceComponent::new);
        TFSUA = TFFeature.registerPiece("TFSUA", StrongholdUpperAscenderComponent::new);
        TFSULT = TFFeature.registerPiece("TFSULT", StrongholdUpperLeftTurnComponent::new);
        TFSURT = TFFeature.registerPiece("TFSURT", StrongholdUpperRightTurnComponent::new);
        TFSUCo = TFFeature.registerPiece("TFSUCo", StrongholdUpperCorridorComponent::new);
        TFSUTI = TFFeature.registerPiece("TFSUTI", StrongholdUpperTIntersectionComponent::new);
        TFSShield = TFFeature.registerPiece("TFSShield", StrongholdShieldStructure::new);
    }
}

