/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.entity.TFEntities;
import twilightforest.loot.TFTreasure;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.world.feature.TFBiomeFeatures;
import twilightforest.world.feature.TFGenCaveStalactite;
import twilightforest.world.feature.config.CaveStalactiteConfig;

public class HollowHillComponent
extends TFStructureComponentOld {
    int hillSize;
    int radius;

    public HollowHillComponent(TemplateManager manager, CompoundNBT nbt) {
        this(TFFeature.TFHill, nbt);
    }

    public HollowHillComponent(IStructurePieceType piece, CompoundNBT nbt) {
        super(piece, nbt);
        this.hillSize = nbt.func_74762_e("hillSize");
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
    }

    public HollowHillComponent(IStructurePieceType piece, TFFeature feature, int i, int size, int x, int y, int z) {
        super(piece, feature, i);
        this.func_186164_a(Direction.SOUTH);
        this.hillSize = size;
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
        this.field_74887_e = feature.getComponentToAddBoundingBox(x, y, z, -this.radius, -(3 + this.hillSize), -this.radius, this.radius * 2, this.radius / 2, this.radius * 2, Direction.SOUTH);
    }

    @Override
    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74768_a("hillSize", this.hillSize);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        int[] dest;
        int i;
        int[] sna = new int[]{0, 128, 256, 512};
        int sn = sna[this.hillSize];
        int[] mga = new int[]{0, 1, 4, 9};
        int mg = mga[this.hillSize];
        int[] tca = new int[]{0, 2, 6, 12};
        int tc = tca[this.hillSize];
        for (i = 0; i < mg; ++i) {
            dest = this.getCoordsInHill2D(rand);
            EntityType<?> mobID = this.getMobID(rand);
            this.setSpawner(world, dest[0], rand.nextInt(4), dest[1], sbb, mobID);
        }
        for (i = 0; i < tc; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateTreasureChest(world, dest[0], 0, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateOreStalactite(world, generator, manager, dest[0], 1, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateBlockStalactite(world, generator, manager, Blocks.field_150348_b, 1.0f, true, dest[0], 1, dest[1], sbb);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.getCoordsInHill2D(rand);
            this.generateBlockStalactite(world, generator, manager, Blocks.field_150348_b, 0.9f, false, dest[0], 1, dest[1], sbb);
        }
        if (this.hillSize == 3) {
            // empty if block
        }
        return true;
    }

    protected void generateTreasureChest(ISeedReader world, int x, int y, int z, MutableBoundingBox sbb) {
        Random chestRNG = new Random(world.func_72905_C() + (long)(x * z));
        this.placeTreasureAtCurrentPosition(world, x, y, z, this.hillSize == 3 ? TFTreasure.hill3 : (this.hillSize == 2 ? TFTreasure.hill2 : TFTreasure.hill1), sbb);
        this.func_175811_a(world, Blocks.field_150347_e.func_176223_P(), x, y - 1, z, sbb);
    }

    protected void generateOreStalactite(ISeedReader world, ChunkGenerator generator, StructureManager manager, int x, int y, int z, MutableBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vector3i)pos) && world.func_180495_p(pos).func_177230_c() != Blocks.field_150474_ac) {
            Random stalRNG = new Random(world.func_72905_C() + (long)(dx * dz));
            CaveStalactiteConfig stalag = TFGenCaveStalactite.makeRandomOreStalactite(stalRNG, this.hillSize);
            ((Feature)TFBiomeFeatures.CAVE_STALACTITE.get()).func_225566_b_((IFeatureConfig)stalag).func_242765_a(world, generator, stalRNG, pos);
        }
    }

    protected void generateBlockStalactite(ISeedReader world, ChunkGenerator generator, StructureManager manager, Block blockToGenerate, float length, boolean up, int x, int y, int z, MutableBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vector3i)pos) && world.func_180495_p(pos).func_177230_c() != Blocks.field_150474_ac) {
            Random stalRNG = new Random(world.func_72905_C() + (long)(dx * dz));
            if (this.hillSize == 1) {
                length *= 1.9f;
            }
            ((Feature)TFBiomeFeatures.CAVE_STALACTITE.get()).func_225566_b_((IFeatureConfig)new CaveStalactiteConfig(blockToGenerate.func_176223_P(), length, -1, -1, up)).func_242765_a(world, generator, stalRNG, pos);
        }
    }

    boolean isInHill(int cx, int cz) {
        int dx = this.radius - cx;
        int dz = this.radius - cz;
        int dist = (int)Math.sqrt(dx * dx + dz * dz);
        return dist < this.radius;
    }

    boolean isInHill(int mapX, int mapY, int mapZ) {
        int dx = this.field_74887_e.field_78897_a + this.radius - mapX;
        int dy = (this.field_74887_e.field_78895_b - mapY) * 2;
        int dz = this.field_74887_e.field_78896_c + this.radius - mapZ;
        int dist = dx * dx + dy * dy + dz * dz;
        return dist < this.radius * this.radius;
    }

    int[] getCoordsInHill2D(Random rand) {
        return this.getCoordsInHill2D(rand, this.radius);
    }

    int[] getCoordsInHill2D(Random rand, int rad) {
        int rz;
        int rx;
        while (!this.isInHill(rx = rand.nextInt(2 * rad), rz = rand.nextInt(2 * rad))) {
        }
        int[] coords = new int[]{rx, rz};
        return coords;
    }

    protected EntityType<?> getMobID(Random rand) {
        return this.getMobID(rand, this.hillSize);
    }

    protected EntityType<?> getMobID(Random rand, int level) {
        if (level == 1) {
            return this.getLevel1Mob(rand);
        }
        if (level == 2) {
            return this.getLevel2Mob(rand);
        }
        if (level == 3) {
            return this.getLevel3Mob(rand);
        }
        return EntityType.field_200748_an;
    }

    public EntityType<?> getLevel1Mob(Random rand) {
        switch (rand.nextInt(10)) {
            default: {
                return TFEntities.swarm_spider;
            }
            case 3: 
            case 4: 
            case 5: {
                return EntityType.field_200748_an;
            }
            case 6: 
            case 7: {
                return EntityType.field_200725_aD;
            }
            case 8: {
                return EntityType.field_200740_af;
            }
            case 9: 
        }
        return TFEntities.redcap;
    }

    public EntityType<?> getLevel2Mob(Random rand) {
        switch (rand.nextInt(10)) {
            default: {
                return TFEntities.redcap;
            }
            case 3: 
            case 4: 
            case 5: {
                return EntityType.field_200725_aD;
            }
            case 6: 
            case 7: {
                return EntityType.field_200741_ag;
            }
            case 8: {
                return TFEntities.swarm_spider;
            }
            case 9: 
        }
        return EntityType.field_200794_h;
    }

    public EntityType<?> getLevel3Mob(Random rand) {
        switch (rand.nextInt(11)) {
            case 0: {
                return TFEntities.slime_beetle;
            }
            case 1: {
                return TFEntities.fire_beetle;
            }
            case 2: {
                return TFEntities.pinch_beetle;
            }
            case 3: 
            case 4: 
            case 5: {
                return EntityType.field_200741_ag;
            }
            case 6: 
            case 7: 
            case 8: {
                return EntityType.field_200794_h;
            }
            case 9: {
                return EntityType.field_200797_k;
            }
        }
        return TFEntities.wraith;
    }
}

