/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.functions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;
import twilightforest.loot.TFTreasure;

public class Enchant
extends LootFunction {
    private final Map<IRegistryDelegate<Enchantment>, Short> enchantments;

    protected Enchant(ILootCondition[] conditions, Map<IRegistryDelegate<Enchantment>, Short> enchantments) {
        super(conditions);
        this.enchantments = enchantments;
    }

    public LootFunctionType func_230425_b_() {
        return TFTreasure.ENCHANT;
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        for (Map.Entry<IRegistryDelegate<Enchantment>, Short> e : this.enchantments.entrySet()) {
            if (stack.func_77973_b() == Items.field_151134_bR) {
                EnchantedBookItem.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData((Enchantment)e.getKey().get(), (int)e.getValue().shortValue()));
                continue;
            }
            stack.func_77966_a((Enchantment)e.getKey().get(), (int)e.getValue().shortValue());
        }
        return stack;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Serializer
    extends LootFunction.Serializer<Enchant> {
        public void serialize(JsonObject object, Enchant function, JsonSerializationContext ctx) {
            if (!function.enchantments.isEmpty()) {
                JsonObject obj = new JsonObject();
                for (Map.Entry e : function.enchantments.entrySet()) {
                    obj.addProperty(((Enchantment)((IRegistryDelegate)e.getKey()).get()).getRegistryName().toString(), (Number)e.getValue());
                }
                object.add("enchantments", (JsonElement)obj);
            }
        }

        public Enchant deserialize(JsonObject object, JsonDeserializationContext ctx, ILootCondition[] conditions) {
            HashMap<IRegistryDelegate<Enchantment>, Short> enchantments = new HashMap<IRegistryDelegate<Enchantment>, Short>();
            if (object.has("enchantments")) {
                JsonObject enchantObj = JSONUtils.func_152754_s((JsonObject)object, (String)"enchantments");
                for (Map.Entry e : enchantObj.entrySet()) {
                    ResourceLocation id = new ResourceLocation((String)e.getKey());
                    if (!ForgeRegistries.ENCHANTMENTS.containsKey(id)) {
                        throw new JsonSyntaxException("Can't find enchantment " + (String)e.getKey());
                    }
                    Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id);
                    short lvl = ((JsonElement)e.getValue()).getAsShort();
                    for (IRegistryDelegate other : enchantments.keySet()) {
                        if (ench.func_191560_c((Enchantment)other.get())) continue;
                        throw new JsonParseException(String.format("Enchantments %s and %s conflict", ench.getRegistryName(), ((Enchantment)other.get()).getRegistryName()));
                    }
                    enchantments.put((IRegistryDelegate<Enchantment>)ench.delegate, lvl);
                }
            }
            return new Enchant(conditions, enchantments);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final Map<IRegistryDelegate<Enchantment>, Short> enchants = Maps.newHashMap();

        protected Builder doCast() {
            return this;
        }

        public Builder apply(Enchantment p_216077_1_, Integer p_216077_2_) {
            this.enchants.put((IRegistryDelegate<Enchantment>)p_216077_1_.delegate, p_216077_2_.shortValue());
            return this;
        }

        public ILootFunction func_216052_b() {
            return new Enchant(this.func_216053_g(), this.enchants);
        }
    }
}

