/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.client.model.armor.KnightlyArmorModel;

public class KnightmetalArmorItem
extends ArmorItem {
    private static final Map<EquipmentSlotType, BipedModel<?>> knightlyArmorModel = new EnumMap(EquipmentSlotType.class);

    public KnightmetalArmorItem(IArmorMaterial material, EquipmentSlotType slot, Item.Properties props) {
        super(material, slot, props);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, EquipmentSlotType slot, String layer) {
        if (slot == EquipmentSlotType.LEGS) {
            return "twilightforest:textures/armor/knightly_2.png";
        }
        return "twilightforest:textures/armor/knightly_1.png";
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A original) {
        return (A)knightlyArmorModel.get(armorSlot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initArmorModel() {
        knightlyArmorModel.put(EquipmentSlotType.HEAD, new KnightlyArmorModel(0.75f));
        knightlyArmorModel.put(EquipmentSlotType.CHEST, new KnightlyArmorModel(1.0f));
        knightlyArmorModel.put(EquipmentSlotType.LEGS, new KnightlyArmorModel(0.5f));
        knightlyArmorModel.put(EquipmentSlotType.FEET, new KnightlyArmorModel(1.0f));
    }
}

