/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import twilightforest.entity.projectile.TFArrowEntity;

public class SeekerArrowEntity
extends TFArrowEntity {
    private static final DataParameter<Integer> TARGET = EntityDataManager.func_187226_a(SeekerArrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final double seekDistance = 5.0;
    private static final double seekFactor = 0.8;
    private static final double seekAngle = 0.5235987755982988;
    private static final double seekThreshold = 0.5;

    public SeekerArrowEntity(EntityType<? extends SeekerArrowEntity> type, World world) {
        super(type, world);
    }

    public SeekerArrowEntity(EntityType<? extends SeekerArrowEntity> type, World world, LivingEntity shooter) {
        super(type, world, shooter);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET, (Object)-1);
    }

    public void func_70071_h_() {
        if (this.isThisArrowFlying()) {
            Entity target;
            if (!this.field_70170_p.field_72995_K) {
                this.updateTarget();
            }
            if (this.field_70170_p.field_72995_K && !this.field_70254_i) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.func_226277_ct_() + this.func_213322_ci().func_82615_a() * (double)i / 4.0, this.func_226278_cu_() + this.func_213322_ci().func_82617_b() * (double)i / 4.0, this.func_226281_cx_() + this.func_213322_ci().func_82616_c() * (double)i / 4.0, -this.func_213322_ci().func_82615_a(), -this.func_213322_ci().func_82617_b() + 0.2, -this.func_213322_ci().func_82616_c());
                }
            }
            if ((target = this.getTarget()) != null) {
                Vector3d targetVec = this.getVectorToTarget(target).func_186678_a(0.8);
                Vector3d courseVec = this.getMotionVec();
                double courseLen = courseVec.func_72433_c();
                double targetLen = targetVec.func_72433_c();
                double totalLen = Math.sqrt(courseLen * courseLen + targetLen * targetLen);
                double dotProduct = courseVec.func_72430_b(targetVec) / (courseLen * targetLen);
                if (dotProduct > 0.5) {
                    Vector3d newMotion = courseVec.func_186678_a(courseLen / totalLen).func_178787_e(targetVec.func_186678_a(courseLen / totalLen));
                    this.func_213317_d(newMotion.func_72441_c(0.0, (double)0.045f, 0.0));
                } else if (!this.field_70170_p.field_72995_K) {
                    this.setTarget(null);
                }
            }
        }
        super.func_70071_h_();
    }

    private void updateTarget() {
        Entity target = this.getTarget();
        if (target != null && !target.func_70089_S()) {
            target = null;
            this.setTarget(null);
        }
        if (target == null) {
            AxisAlignedBB positionBB;
            AxisAlignedBB targetBB = positionBB = new AxisAlignedBB(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            Vector3d courseVec = this.getMotionVec().func_186678_a(5.0).func_178785_b(0.5235988f);
            targetBB = targetBB.func_111270_a(positionBB.func_191194_a(courseVec));
            courseVec = this.getMotionVec().func_186678_a(5.0).func_178785_b(-0.5235988f);
            targetBB = targetBB.func_111270_a(positionBB.func_191194_a(courseVec));
            targetBB = targetBB.func_72314_b(0.0, 2.5, 0.0);
            double closestDot = -1.0;
            LivingEntity closestTarget = null;
            List monsters = this.field_70170_p.func_217357_a(MonsterEntity.class, targetBB);
            for (LivingEntity living : this.field_70170_p.func_217357_a(LivingEntity.class, targetBB)) {
                Vector3d targetVec;
                Vector3d motionVec;
                double dot;
                if (!monsters.isEmpty()) {
                    for (MonsterEntity targets : monsters) {
                        Vector3d targetVec2;
                        Vector3d motionVec2 = this.getMotionVec().func_72432_b();
                        double dot2 = motionVec2.func_72430_b(targetVec2 = this.getVectorToTarget((Entity)living).func_72432_b());
                        if (!(dot2 > Math.max(closestDot, 0.5))) continue;
                        closestDot = dot2;
                        closestTarget = targets;
                        break;
                    }
                }
                if (living instanceof PlayerEntity || this.func_234616_v_() != null && living instanceof TameableEntity && ((TameableEntity)living).func_70902_q() == this.func_234616_v_() || !((dot = (motionVec = this.getMotionVec().func_72432_b()).func_72430_b(targetVec = this.getVectorToTarget((Entity)living).func_72432_b())) > Math.max(closestDot, 0.5))) continue;
                closestDot = dot;
                if (!monsters.isEmpty()) continue;
                closestTarget = living;
            }
            if (closestTarget != null) {
                this.setTarget((Entity)closestTarget);
            }
        }
    }

    private Vector3d getMotionVec() {
        return new Vector3d(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c());
    }

    private Vector3d getVectorToTarget(Entity target) {
        return new Vector3d(target.func_226277_ct_() - this.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e() - this.func_226278_cu_(), target.func_226281_cx_() - this.func_226281_cx_());
    }

    @Nullable
    private Entity getTarget() {
        return this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET)).intValue());
    }

    private void setTarget(@Nullable Entity e) {
        this.field_70180_af.func_187227_b(TARGET, (Object)(e == null ? -1 : e.func_145782_y()));
    }

    private boolean isThisArrowFlying() {
        return !this.field_70254_i && this.func_213322_ci().func_189985_c() > 1.0;
    }
}

