/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;
import twilightforest.TwilightForestMod;
import twilightforest.block.AuroraBrickBlock;
import twilightforest.block.BuilderBlock;
import twilightforest.block.CarminiteReactorBlock;
import twilightforest.block.CastleDoorBlock;
import twilightforest.block.DirectionalRotatedPillarBlock;
import twilightforest.block.EncasedSmokerBlock;
import twilightforest.block.Experiment115Block;
import twilightforest.block.FireJetBlock;
import twilightforest.block.GhastTrapBlock;
import twilightforest.block.HugeLilyPadBlock;
import twilightforest.block.IronLadderBlock;
import twilightforest.block.LockedVanishingBlock;
import twilightforest.block.NagastoneBlock;
import twilightforest.block.SliderBlock;
import twilightforest.block.SpecialMagicLogBlock;
import twilightforest.block.TFBlocks;
import twilightforest.block.TFPortalBlock;
import twilightforest.block.TranslucentBuiltBlock;
import twilightforest.block.TrophyPedestalBlock;
import twilightforest.block.VanishingBlock;
import twilightforest.block.WallPillarBlock;
import twilightforest.enums.FireJetVariant;
import twilightforest.enums.HugeLilypadPiece;
import twilightforest.enums.NagastoneVariant;
import twilightforest.enums.TowerDeviceVariant;

public class BlockstateGenerator
extends BlockStateProvider {
    public BlockstateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "twilightforest", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.tintedAndFlipped((Block)TFBlocks.tower_wood.get());
        this.simpleBlock((Block)TFBlocks.tower_wood_encased.get(), (ModelFile)this.cubeAllTinted(TFBlocks.tower_wood_encased.getId().func_110623_a(), TFBlocks.tower_wood_encased.getId().func_110623_a()));
        this.simpleBlock((Block)TFBlocks.tower_wood_cracked.get(), ConfiguredModel.builder().modelFile((ModelFile)this.cubeAllTinted(TFBlocks.tower_wood_cracked.getId().func_110623_a(), TFBlocks.tower_wood_cracked.getId().func_110623_a())).nextModel().modelFile((ModelFile)this.cubeAllTinted(TFBlocks.tower_wood_cracked.getId().func_110623_a() + "_flipped", TFBlocks.tower_wood_cracked.getId().func_110623_a(), true)).nextModel().modelFile((ModelFile)this.cubeAllTinted(TFBlocks.tower_wood_cracked.getId().func_110623_a() + "_alt", TFBlocks.tower_wood_cracked.getId().func_110623_a() + "_alt")).nextModel().modelFile((ModelFile)this.cubeAllTinted(TFBlocks.tower_wood_cracked.getId().func_110623_a() + "_alt_flipped", TFBlocks.tower_wood_cracked.getId().func_110623_a() + "_alt", true)).build());
        this.tintedAndFlipped((Block)TFBlocks.tower_wood_mossy.get());
        this.tintedAndFlipped((Block)TFBlocks.tower_wood_infested.get());
        this.builtinEntity((Block)TFBlocks.firefly.get(), "twilightforest:block/stone_twist/twist_blank");
        this.builtinEntity((Block)TFBlocks.moonworm.get(), "twilightforest:block/stone_twist/twist_blank");
        this.builtinEntity((Block)TFBlocks.cicada.get(), "twilightforest:block/stone_twist/twist_blank");
        this.builtinEntity((Block)TFBlocks.keepsake_casket.get(), "minecraft:block/netherite_block");
        ModelFile.ExistingModelFile portalModel = this.models().getExistingFile(TwilightForestMod.prefix("block/twilight_portal"));
        ModelFile.ExistingModelFile portalOverlayModel = this.models().getExistingFile(TwilightForestMod.prefix("block/twilight_portal_barrier"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)TFBlocks.twilight_portal.get()).part().modelFile((ModelFile)portalModel).addModel()).end().part().modelFile((ModelFile)portalOverlayModel).addModel()).condition((Property)TFPortalBlock.DISALLOW_RETURN, (Comparable[])new Boolean[]{true}).end();
        this.getVariantBuilder((Block)TFBlocks.experiment_115.get()).forAllStates(state -> {
            int bitesTaken = (Integer)state.func_177229_b((Property)Experiment115Block.BITES_TAKEN);
            String basePath = String.format("block/experiment115_%d_8", 8 - bitesTaken);
            Object model = (Boolean)state.func_177229_b((Property)Experiment115Block.REGENERATE) != false ? ((BlockModelBuilder)this.models().withExistingParent(basePath + "_regenerating", TwilightForestMod.prefix(basePath))).texture("top_2", "block/experiment115/experiment115_sprinkle") : this.models().getExistingFile(TwilightForestMod.prefix(basePath));
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
        MultiPartBlockStateBuilder ironLadder = this.getMultipartBuilder((Block)TFBlocks.iron_ladder.get());
        ModelFile.ExistingModelFile ironLadderLeft = this.models().getExistingFile(TwilightForestMod.prefix("block/iron_ladder_left"));
        ModelFile.ExistingModelFile ironLadderLeftConnected = this.models().getExistingFile(TwilightForestMod.prefix("block/iron_ladder_left_connection"));
        ModelFile.ExistingModelFile ironLadderRight = this.models().getExistingFile(TwilightForestMod.prefix("block/iron_ladder_right"));
        ModelFile.ExistingModelFile ironLadderRightConnected = this.models().getExistingFile(TwilightForestMod.prefix("block/iron_ladder_right_connection"));
        for (Direction d : Direction.Plane.HORIZONTAL) {
            int rotY;
            switch (d) {
                default: {
                    rotY = 0;
                    break;
                }
                case EAST: {
                    rotY = 90;
                    break;
                }
                case SOUTH: {
                    rotY = 180;
                    break;
                }
                case WEST: {
                    rotY = 270;
                }
            }
            ((MultiPartBlockStateBuilder.PartBuilder)ironLadder.part().modelFile((ModelFile)ironLadderLeft).rotationY(rotY).addModel()).condition((Property)LadderBlock.field_176382_a, (Comparable[])new Direction[]{d}).condition((Property)IronLadderBlock.LEFT, (Comparable[])new Boolean[]{false}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)ironLadder.part().modelFile((ModelFile)ironLadderLeftConnected).rotationY(rotY).addModel()).condition((Property)LadderBlock.field_176382_a, (Comparable[])new Direction[]{d}).condition((Property)IronLadderBlock.LEFT, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)ironLadder.part().modelFile((ModelFile)ironLadderRight).rotationY(rotY).addModel()).condition((Property)LadderBlock.field_176382_a, (Comparable[])new Direction[]{d}).condition((Property)IronLadderBlock.RIGHT, (Comparable[])new Boolean[]{false}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)ironLadder.part().modelFile((ModelFile)ironLadderRightConnected).rotationY(rotY).addModel()).condition((Property)LadderBlock.field_176382_a, (Comparable[])new Direction[]{d}).condition((Property)IronLadderBlock.RIGHT, (Comparable[])new Boolean[]{true}).end();
        }
        this.towerBlocks();
        this.simpleBlock((Block)TFBlocks.fake_gold.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/gold_block")));
        this.simpleBlock((Block)TFBlocks.fake_diamond.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/diamond_block")));
        this.simpleBlock((Block)TFBlocks.naga_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.lich_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.minoshroom_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.hydra_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.yeti_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.snow_queen_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.knight_phantom_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.ur_ghast_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.quest_ram_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.naga_wall_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.lich_wall_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.minoshroom_wall_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.hydra_wall_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.yeti_wall_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.snow_queen_wall_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.knight_phantom_wall_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.ur_ghast_wall_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        this.simpleBlock((Block)TFBlocks.quest_ram_wall_trophy.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/skull")));
        ModelBuilder shieldModel = this.models().cubeTop(TFBlocks.stronghold_shield.getId().func_110623_a(), TwilightForestMod.prefix("block/shield_outside"), TwilightForestMod.prefix("block/shield_inside"));
        this.getVariantBuilder((Block)TFBlocks.stronghold_shield.get()).forAllStates(arg_0 -> BlockstateGenerator.lambda$registerStatesAndModels$1((ModelFile)shieldModel, arg_0));
        this.trophyPedestal();
        this.auroraBlocks();
        this.slider();
        this.simpleBlock((Block)TFBlocks.underbrick.get());
        this.simpleBlock((Block)TFBlocks.underbrick_cracked.get());
        this.simpleBlock((Block)TFBlocks.underbrick_mossy.get());
        this.simpleBlock((Block)TFBlocks.underbrick_floor.get());
        this.thorns();
        this.simpleBlock((Block)TFBlocks.thorn_rose.get(), (ModelFile)this.models().cross(TFBlocks.thorn_rose.getId().func_110623_a(), this.blockTexture((Block)TFBlocks.thorn_rose.get())));
        this.simpleBlock((Block)TFBlocks.thorn_leaves.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/oak_leaves")));
        this.simpleBlock((Block)TFBlocks.beanstalk_leaves.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/spruce_leaves")));
        this.simpleBlock((Block)TFBlocks.hollow_oak_sapling.get(), (ModelFile)this.models().cross(TFBlocks.hollow_oak_sapling.getId().func_110623_a(), this.blockTexture((Block)TFBlocks.hollow_oak_sapling.get())));
        ModelBuilder deadrock = this.models().cubeAll(TFBlocks.deadrock.getId().func_110623_a(), this.blockTexture((Block)TFBlocks.deadrock.get()));
        ModelBuilder deadrockMirrored = ((BlockModelBuilder)this.models().withExistingParent(TFBlocks.deadrock.getId().func_110623_a() + "_mirrored", TwilightForestMod.prefix("block/util/cube_mirrored_all"))).texture("all", this.blockTexture((Block)TFBlocks.deadrock.get()));
        this.simpleBlock((Block)TFBlocks.deadrock.get(), ConfiguredModel.builder().modelFile((ModelFile)deadrock).nextModel().rotationY(180).modelFile((ModelFile)deadrock).nextModel().modelFile((ModelFile)deadrockMirrored).nextModel().rotationY(180).modelFile((ModelFile)deadrockMirrored).build());
        ModelBuilder deadrockCracked = this.models().cubeAll(TFBlocks.deadrock_cracked.getId().func_110623_a(), this.blockTexture((Block)TFBlocks.deadrock_cracked.get()));
        this.allRotations((Block)TFBlocks.deadrock_cracked.get(), (ModelFile)deadrockCracked);
        ModelBuilder deadrockWeathered = this.models().cubeAll(TFBlocks.deadrock_weathered.getId().func_110623_a(), this.blockTexture((Block)TFBlocks.deadrock_weathered.get()));
        this.allRotations((Block)TFBlocks.deadrock_weathered.get(), (ModelFile)deadrockWeathered);
        this.perFaceBlock((Block)TFBlocks.trollsteinn.get(), this.blockTexture((Block)TFBlocks.trollsteinn.get()), TwilightForestMod.prefix("block/" + TFBlocks.trollsteinn.getId().func_110623_a() + "_light"));
        this.simpleBlock((Block)TFBlocks.wispy_cloud.get());
        this.simpleBlock((Block)TFBlocks.fluffy_cloud.get());
        this.simpleBlock((Block)TFBlocks.giant_cobblestone.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.giant_cobblestone.getId().func_110623_a(), TwilightForestMod.prefix("block/util/giant_block"))).texture("all", this.blockTexture(Blocks.field_150347_e)));
        this.simpleBlock((Block)TFBlocks.giant_log.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.giant_log.getId().func_110623_a(), TwilightForestMod.prefix("block/util/giant_column"))).texture("side", this.blockTexture(Blocks.field_196617_K))).texture("end", new ResourceLocation("block/oak_log_top")));
        this.simpleBlock((Block)TFBlocks.giant_leaves.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.giant_leaves.getId().func_110623_a(), TwilightForestMod.prefix("block/util/giant_block"))).texture("all", this.blockTexture(Blocks.field_196642_W)));
        this.simpleBlock((Block)TFBlocks.giant_obsidian.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.giant_obsidian.getId().func_110623_a(), TwilightForestMod.prefix("block/util/giant_block"))).texture("all", this.blockTexture(Blocks.field_150343_Z)));
        this.simpleBlock((Block)TFBlocks.uberous_soil.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.uberous_soil.getId().func_110623_a(), TwilightForestMod.prefix("block/util/cube_all_2_layer"))).texture("all", this.blockTexture((Block)TFBlocks.uberous_soil.get()))).texture("all2", TwilightForestMod.prefix("block/" + TFBlocks.uberous_soil.getId().func_110623_a() + "_glow")));
        this.simpleBlock((Block)TFBlocks.huge_stalk.get(), (ModelFile)this.models().cubeColumn(TFBlocks.huge_stalk.getId().func_110623_a(), TwilightForestMod.prefix("block/" + TFBlocks.huge_stalk.getId().func_110623_a()), TwilightForestMod.prefix("block/" + TFBlocks.huge_stalk.getId().func_110623_a() + "_top")));
        this.perFaceBlock((Block)TFBlocks.huge_mushgloom.get(), TwilightForestMod.prefix("block/huge_gloom_inside"), TwilightForestMod.prefix("block/huge_gloom_cap"));
        this.simpleBlock((Block)TFBlocks.huge_mushgloom_stem.get());
        this.simpleBlock((Block)TFBlocks.trollvidr.get(), (ModelFile)this.models().cross(TFBlocks.trollvidr.getId().func_110623_a(), this.blockTexture((Block)TFBlocks.trollvidr.get())));
        this.simpleBlock((Block)TFBlocks.unripe_trollber.get(), (ModelFile)this.models().cross(TFBlocks.unripe_trollber.getId().func_110623_a(), this.blockTexture((Block)TFBlocks.unripe_trollber.get())));
        ModelBuilder trollber = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.trollber.getId().func_110623_a(), TwilightForestMod.prefix("block/util/cross_2_layer"))).texture("cross", this.blockTexture((Block)TFBlocks.trollber.get()))).texture("cross2", TwilightForestMod.prefix("block/" + TFBlocks.trollber.getId().func_110623_a() + "_glow"));
        this.simpleBlock((Block)TFBlocks.trollber.get(), (ModelFile)trollber);
        this.lilyPad((Block)TFBlocks.huge_lilypad.get());
        this.simpleBlock((Block)TFBlocks.huge_waterlily.get(), (ModelFile)this.models().cross(TFBlocks.huge_waterlily.getId().func_110623_a(), this.blockTexture((Block)TFBlocks.huge_waterlily.get())));
        this.simpleBlock((Block)TFBlocks.castle_brick.get());
        this.simpleBlock((Block)TFBlocks.castle_brick_worn.get());
        this.simpleBlock((Block)TFBlocks.castle_brick_cracked.get());
        this.allRotations((Block)TFBlocks.castle_brick_roof.get(), this.cubeAll((Block)TFBlocks.castle_brick_roof.get()));
        this.simpleBlock((Block)TFBlocks.castle_brick_mossy.get());
        this.simpleBlock((Block)TFBlocks.castle_brick_frame.get());
        this.rotationallyCorrectColumn((Block)TFBlocks.castle_pillar_encased.get());
        this.rotationallyCorrectColumn((Block)TFBlocks.castle_pillar_bold.get());
        this.simpleBlock((Block)TFBlocks.castle_pillar_encased_tile.get(), (ModelFile)this.models().cubeAll(TFBlocks.castle_pillar_encased_tile.getId().func_110623_a(), TwilightForestMod.prefix("block/castle_pillar_encased_end")));
        this.simpleBlock((Block)TFBlocks.castle_pillar_bold_tile.get());
        this.stairsBlock((StairsBlock)TFBlocks.castle_stairs_brick.get(), TwilightForestMod.prefix("block/" + TFBlocks.castle_stairs_brick.getId().func_110623_a()));
        this.stairsBlock((StairsBlock)TFBlocks.castle_stairs_worn.get(), TwilightForestMod.prefix("block/" + TFBlocks.castle_stairs_worn.getId().func_110623_a()));
        this.stairsBlock((StairsBlock)TFBlocks.castle_stairs_cracked.get(), TwilightForestMod.prefix("block/" + TFBlocks.castle_stairs_cracked.getId().func_110623_a()));
        this.stairsBlock((StairsBlock)TFBlocks.castle_stairs_mossy.get(), TwilightForestMod.prefix("block/" + TFBlocks.castle_stairs_mossy.getId().func_110623_a()));
        this.stairsBlock((StairsBlock)TFBlocks.castle_stairs_encased.get(), TwilightForestMod.prefix("block/castle_pillar_encased_h"), TwilightForestMod.prefix("block/castleblock_tile"), TwilightForestMod.prefix("block/castle_brick_roof"));
        this.stairsBlock((StairsBlock)TFBlocks.castle_stairs_bold.get(), TwilightForestMod.prefix("block/castle_pillar_bold_tile"));
        ConfiguredModel[] runeBrickModels = new ConfiguredModel[8];
        for (int i = 0; i < runeBrickModels.length; ++i) {
            runeBrickModels[i] = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("castle_rune_brick_" + i, TwilightForestMod.prefix("block/util/cube_all_2_layer"))).texture("all", TwilightForestMod.prefix("block/castle_brick"))).texture("all2", TwilightForestMod.prefix("block/castleblock_magic_" + i)));
        }
        this.simpleBlock((Block)TFBlocks.castle_rune_brick_yellow.get(), runeBrickModels);
        this.simpleBlock((Block)TFBlocks.castle_rune_brick_purple.get(), runeBrickModels);
        this.simpleBlock((Block)TFBlocks.castle_rune_brick_pink.get(), runeBrickModels);
        this.simpleBlock((Block)TFBlocks.castle_rune_brick_blue.get(), runeBrickModels);
        this.logBlock((RotatedPillarBlock)TFBlocks.cinder_log.get());
        this.simpleBlock((Block)TFBlocks.cinder_wood.get(), (ModelFile)this.models().cubeAll(TFBlocks.cinder_wood.getId().func_110623_a(), TwilightForestMod.prefix("block/" + TFBlocks.cinder_log.getId().func_110623_a())));
        ModelFile.ExistingModelFile furnaceOff = this.models().getExistingFile(new ResourceLocation("block/furnace"));
        ModelFile.ExistingModelFile furnaceOn = this.models().getExistingFile(new ResourceLocation("block/furnace_on"));
        this.horizontalBlock((Block)TFBlocks.cinder_furnace.get(), arg_0 -> BlockstateGenerator.lambda$registerStatesAndModels$2((ModelFile)furnaceOn, (ModelFile)furnaceOff, arg_0));
        this.castleDoor((Block)TFBlocks.castle_door_yellow.get());
        this.castleDoor((Block)TFBlocks.castle_door_purple.get());
        this.castleDoor((Block)TFBlocks.castle_door_pink.get());
        this.castleDoor((Block)TFBlocks.castle_door_blue.get());
        this.simpleBlockExisting((Block)TFBlocks.knightmetal_block.get());
        this.simpleBlockExisting((Block)TFBlocks.ironwood_block.get());
        this.simpleBlockExisting((Block)TFBlocks.fiery_block.get());
        this.simpleBlock((Block)TFBlocks.arctic_fur_block.get());
        ModelBuilder steeleafBlock = this.models().cubeAll(TFBlocks.steeleaf_block.getId().func_110623_a(), TwilightForestMod.prefix("block/" + TFBlocks.steeleaf_block.getId().func_110623_a()));
        this.allRotations((Block)TFBlocks.steeleaf_block.get(), (ModelFile)steeleafBlock);
        ModelBuilder carminiteBlock = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.carminite_block.getId().func_110623_a(), TwilightForestMod.prefix("block/util/cube_all_2_layer"))).texture("all", TwilightForestMod.prefix("block/" + TFBlocks.carminite_block.getId().func_110623_a()))).texture("all2", TwilightForestMod.prefix("block/" + TFBlocks.carminite_block.getId().func_110623_a() + "_overlay"));
        this.allRotations((Block)TFBlocks.carminite_block.get(), (ModelFile)carminiteBlock);
        this.simpleBlock((Block)TFBlocks.twilight_portal_miniature_structure.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/miniature/portal")));
        this.simpleBlock((Block)TFBlocks.naga_courtyard_miniature_structure.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/miniature/naga_courtyard")));
        this.simpleBlock((Block)TFBlocks.lich_tower_miniature_structure.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/miniature/lich_tower")));
        this.mazestone();
        this.simpleBlock((Block)TFBlocks.hedge.get(), ConfiguredModel.builder().weight(10).modelFile((ModelFile)this.models().cubeAll(TFBlocks.hedge.getId().func_110623_a(), this.blockTexture((Block)TFBlocks.hedge.get()))).nextModel().weight(1).modelFile((ModelFile)this.models().cubeAll(TFBlocks.hedge.getId().func_110623_a() + "_rose", TwilightForestMod.prefix("block/" + TFBlocks.hedge.getId().func_110623_a() + "_rose"))).build());
        this.simpleBlock((Block)TFBlocks.boss_spawner_naga.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation("block/spawner")))});
        this.simpleBlock((Block)TFBlocks.boss_spawner_lich.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation("block/spawner")))});
        this.simpleBlock((Block)TFBlocks.boss_spawner_hydra.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation("block/spawner")))});
        this.simpleBlock((Block)TFBlocks.boss_spawner_ur_ghast.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation("block/spawner")))});
        this.simpleBlock((Block)TFBlocks.boss_spawner_knight_phantom.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation("block/spawner")))});
        this.simpleBlock((Block)TFBlocks.boss_spawner_snow_queen.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation("block/spawner")))});
        this.simpleBlock((Block)TFBlocks.boss_spawner_minoshroom.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation("block/spawner")))});
        this.simpleBlock((Block)TFBlocks.boss_spawner_alpha_yeti.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation("block/spawner")))});
        this.simpleBlock((Block)TFBlocks.boss_spawner_final_boss.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(new ResourceLocation("block/spawner")))});
        this.simpleBlockExisting((Block)TFBlocks.firefly_jar.get());
        this.simpleBlockExisting((Block)TFBlocks.cicada_jar.get());
        this.registerPlantBlocks();
        this.simpleBlock((Block)TFBlocks.root.get());
        this.simpleBlock((Block)TFBlocks.liveroot_block.get());
        this.simpleBlock((Block)TFBlocks.uncrafting_table.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.uncrafting_table.getId().func_110623_a(), TwilightForestMod.prefix("block/util/cube_bottom_double_top"))).texture("top", TwilightForestMod.prefix("block/uncrafting_top"))).texture("glow", TwilightForestMod.prefix("block/uncrafting_glow"))).texture("bottom", new ResourceLocation("block/jungle_planks"))).texture("side", TwilightForestMod.prefix("block/uncrafting_side")));
        this.registerSmokersAndJets();
        this.axisBlock((RotatedPillarBlock)TFBlocks.stone_twist.get(), TwilightForestMod.prefix("block/stone_twist/twist_side"), TwilightForestMod.prefix("block/stone_twist/twist_end"));
        ConfiguredModel[] lapisModels = new ConfiguredModel[4];
        this.registerWoodBlocks();
        this.registerNagastone();
        this.registerForceFields();
        this.simpleBlock((Block)TFBlocks.potted_twilight_oak_sapling.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_twilight_oak_sapling")));
        this.simpleBlock((Block)TFBlocks.potted_canopy_sapling.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_canopy_sapling")));
        this.simpleBlock((Block)TFBlocks.potted_mangrove_sapling.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_mangrove_sapling")));
        this.simpleBlock((Block)TFBlocks.potted_darkwood_sapling.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_darkwood_sapling")));
        this.simpleBlock((Block)TFBlocks.potted_hollow_oak_sapling.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_hollow_oak_sapling")));
        this.simpleBlock((Block)TFBlocks.potted_rainboak_sapling.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_rainboak_sapling")));
        this.simpleBlock((Block)TFBlocks.potted_time_sapling.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_time_sapling")));
        this.simpleBlock((Block)TFBlocks.potted_trans_sapling.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_trans_sapling")));
        this.simpleBlock((Block)TFBlocks.potted_mine_sapling.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_mine_sapling")));
        this.simpleBlock((Block)TFBlocks.potted_sort_sapling.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_sort_sapling")));
        this.simpleBlock((Block)TFBlocks.potted_mayapple.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_mayapple")));
        this.simpleBlock((Block)TFBlocks.potted_fiddlehead.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_fiddlehead")));
        this.simpleBlock((Block)TFBlocks.potted_mushgloom.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_mushgloom")));
        this.simpleBlock((Block)TFBlocks.potted_thorn.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_thorn")));
        this.simpleBlock((Block)TFBlocks.potted_green_thorn.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_green_thorn")));
        this.simpleBlock((Block)TFBlocks.potted_dead_thorn.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/potted_dead_thorn")));
        this.builtinEntity((Block)TFBlocks.twilight_oak_sign.get(), "twilightforest:block/wood/planks_twilight_oak_0");
        this.builtinEntity((Block)TFBlocks.twilight_wall_sign.get(), "twilightforest:block/wood/planks_twilight_oak_0");
        this.builtinEntity((Block)TFBlocks.canopy_sign.get(), "twilightforest:block/wood/planks_canopy_0");
        this.builtinEntity((Block)TFBlocks.canopy_wall_sign.get(), "twilightforest:block/wood/planks_canopy_0");
        this.builtinEntity((Block)TFBlocks.mangrove_sign.get(), "twilightforest:block/wood/planks_mangrove_0");
        this.builtinEntity((Block)TFBlocks.mangrove_wall_sign.get(), "twilightforest:block/wood/planks_mangrove_0");
        this.builtinEntity((Block)TFBlocks.darkwood_sign.get(), "twilightforest:block/wood/planks_darkwood_0");
        this.builtinEntity((Block)TFBlocks.darkwood_wall_sign.get(), "twilightforest:block/wood/planks_darkwood_0");
        this.builtinEntity((Block)TFBlocks.time_sign.get(), "twilightforest:block/wood/planks_time_0");
        this.builtinEntity((Block)TFBlocks.time_wall_sign.get(), "twilightforest:block/wood/planks_time_0");
        this.builtinEntity((Block)TFBlocks.trans_sign.get(), "twilightforest:block/wood/planks_trans_0");
        this.builtinEntity((Block)TFBlocks.trans_wall_sign.get(), "twilightforest:block/wood/planks_trans_0");
        this.builtinEntity((Block)TFBlocks.mine_sign.get(), "twilightforest:block/wood/planks_mine_0");
        this.builtinEntity((Block)TFBlocks.mine_wall_sign.get(), "twilightforest:block/wood/planks_mine_0");
        this.builtinEntity((Block)TFBlocks.sort_sign.get(), "twilightforest:block/wood/planks_sort_0");
        this.builtinEntity((Block)TFBlocks.sort_wall_sign.get(), "twilightforest:block/wood/planks_sort_0");
        this.casketStuff();
        this.stonePillar();
    }

    private void registerForceFields() {
        ImmutableList forceFields = ImmutableList.of(TFBlocks.force_field_pink, TFBlocks.force_field_blue, TFBlocks.force_field_green, TFBlocks.force_field_purple, TFBlocks.force_field_orange);
        for (RegistryObject block : forceFields) {
            ModelBuilder post = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(block.getId().func_110623_a() + "_post", TwilightForestMod.prefix("block/util/pane/post"))).texture("pane", TwilightForestMod.prefix("block/forcefield_white"))).texture("edge", "#pane");
            ModelBuilder side = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(block.getId().func_110623_a() + "_side", TwilightForestMod.prefix("block/util/pane/side"))).texture("pane", TwilightForestMod.prefix("block/forcefield_white"))).texture("edge", "#pane");
            ModelBuilder noside = ((BlockModelBuilder)this.models().withExistingParent(block.getId().func_110623_a() + "_noside", TwilightForestMod.prefix("block/util/pane/noside"))).texture("pane", TwilightForestMod.prefix("block/forcefield_white"));
            ModelBuilder sidealt = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(block.getId().func_110623_a() + "_side_alt", TwilightForestMod.prefix("block/util/pane/side_alt"))).texture("pane", TwilightForestMod.prefix("block/forcefield_white"))).texture("edge", "#pane");
            ModelBuilder nosidealt = ((BlockModelBuilder)this.models().withExistingParent(block.getId().func_110623_a() + "_noside_alt", TwilightForestMod.prefix("block/util/pane/noside_alt"))).texture("pane", TwilightForestMod.prefix("block/forcefield_white"));
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block.get()).part().modelFile((ModelFile)post).uvLock(true).addModel()).end().part().modelFile((ModelFile)side).uvLock(true).addModel()).condition((Property)SixWayBlock.field_196488_a, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)noside).uvLock(true).addModel()).condition((Property)SixWayBlock.field_196488_a, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)side).uvLock(true).rotationY(90).addModel()).condition((Property)SixWayBlock.field_196490_b, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)nosidealt).uvLock(true).addModel()).condition((Property)SixWayBlock.field_196490_b, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)sidealt).uvLock(true).addModel()).condition((Property)SixWayBlock.field_196492_c, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)nosidealt).uvLock(true).rotationY(90).addModel()).condition((Property)SixWayBlock.field_196492_c, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)sidealt).uvLock(true).rotationY(90).addModel()).condition((Property)SixWayBlock.field_196495_y, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)noside).uvLock(true).rotationY(270).addModel()).condition((Property)SixWayBlock.field_196495_y, (Comparable[])new Boolean[]{false}).end();
        }
    }

    private void registerNagastone() {
        String baseName = TFBlocks.naga_stone.getId().func_110623_a();
        ModelBuilder solid = this.models().cubeBottomTop(baseName, TwilightForestMod.prefix("block/nagastone_long_side"), TwilightForestMod.prefix("block/nagastone_bottom_long"), TwilightForestMod.prefix("block/nagastone_turn_top"));
        ModelFile.ExistingModelFile down = this.models().getExistingFile(TwilightForestMod.prefix("block/naga_segment/down"));
        ModelFile.ExistingModelFile up = this.models().getExistingFile(TwilightForestMod.prefix("block/naga_segment/up"));
        ModelFile.ExistingModelFile horizontal = this.models().getExistingFile(TwilightForestMod.prefix("block/naga_segment/horizontal"));
        ModelFile.ExistingModelFile vertical = this.models().getExistingFile(TwilightForestMod.prefix("block/naga_segment/vertical"));
        this.getVariantBuilder((Block)TFBlocks.naga_stone.get()).forAllStates(arg_0 -> BlockstateGenerator.lambda$registerNagastone$3((ModelFile)down, (ModelFile)up, (ModelFile)horizontal, (ModelFile)vertical, (ModelFile)solid, arg_0));
        this.horizontalBlock((Block)TFBlocks.naga_stone_head.get(), (ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/" + TFBlocks.naga_stone_head.getId().func_110623_a())));
        this.nagastonePillar((Block)TFBlocks.nagastone_pillar.get(), "");
        this.nagastonePillar((Block)TFBlocks.nagastone_pillar_mossy.get(), "_mossy");
        this.nagastonePillar((Block)TFBlocks.nagastone_pillar_weathered.get(), "_weathered");
        this.etchedNagastone((Block)TFBlocks.etched_nagastone.get(), "");
        this.etchedNagastone((Block)TFBlocks.etched_nagastone_mossy.get(), "_mossy");
        this.etchedNagastone((Block)TFBlocks.etched_nagastone_weathered.get(), "_weathered");
        this.stairsBlock((StairsBlock)TFBlocks.nagastone_stairs_left.get(), TwilightForestMod.prefix("block/etched_nagastone_left"), TwilightForestMod.prefix("block/stone_tiles"), TwilightForestMod.prefix("block/nagastone_bare"));
        this.stairsBlock((StairsBlock)TFBlocks.nagastone_stairs_right.get(), TwilightForestMod.prefix("block/etched_nagastone_right"), TwilightForestMod.prefix("block/stone_tiles"), TwilightForestMod.prefix("block/nagastone_bare"));
        this.stairsBlock((StairsBlock)TFBlocks.nagastone_stairs_mossy_left.get(), TwilightForestMod.prefix("block/etched_nagastone_left_mossy"), TwilightForestMod.prefix("block/stone_tiles_mossy"), TwilightForestMod.prefix("block/nagastone_bare_mossy"));
        this.stairsBlock((StairsBlock)TFBlocks.nagastone_stairs_mossy_right.get(), TwilightForestMod.prefix("block/etched_nagastone_right_mossy"), TwilightForestMod.prefix("block/stone_tiles_mossy"), TwilightForestMod.prefix("block/nagastone_bare_mossy"));
        this.stairsBlock((StairsBlock)TFBlocks.nagastone_stairs_weathered_left.get(), TwilightForestMod.prefix("block/etched_nagastone_left_weathered"), TwilightForestMod.prefix("block/stone_tiles_weathered"), TwilightForestMod.prefix("block/nagastone_bare_weathered"));
        this.stairsBlock((StairsBlock)TFBlocks.nagastone_stairs_weathered_right.get(), TwilightForestMod.prefix("block/etched_nagastone_right_weathered"), TwilightForestMod.prefix("block/stone_tiles_weathered"), TwilightForestMod.prefix("block/nagastone_bare_weathered"));
    }

    private void nagastonePillar(Block b, String suffix) {
        ResourceLocation side = TwilightForestMod.prefix("block/nagastone_pillar_side" + suffix);
        ResourceLocation end = TwilightForestMod.prefix("block/nagastone_pillar_end" + suffix);
        ResourceLocation alt = TwilightForestMod.prefix("block/nagastone_pillar_side" + suffix + "_alt");
        ModelBuilder model = this.models().cubeColumn(b.getRegistryName().func_110623_a(), side, end);
        ModelBuilder reversed = this.models().cubeColumn(b.getRegistryName().func_110623_a() + "_reversed", alt, end);
        this.getVariantBuilder(b).forAllStates(arg_0 -> BlockstateGenerator.lambda$nagastonePillar$4((ModelFile)reversed, (ModelFile)model, arg_0));
    }

    private void etchedNagastone(Block b, String suffix) {
        ResourceLocation stoneTiles = TwilightForestMod.prefix("block/stone_tiles" + suffix);
        ResourceLocation upTex = TwilightForestMod.prefix("block/etched_nagastone_up" + suffix);
        ResourceLocation downTex = TwilightForestMod.prefix("block/etched_nagastone_down" + suffix);
        ResourceLocation rightTex = TwilightForestMod.prefix("block/etched_nagastone_right" + suffix);
        ResourceLocation leftTex = TwilightForestMod.prefix("block/etched_nagastone_left" + suffix);
        ModelBuilder down = this.models().cubeColumn(b.getRegistryName().func_110623_a(), downTex, stoneTiles);
        ModelBuilder up = this.models().cubeColumn(b.getRegistryName().func_110623_a() + "_up", upTex, stoneTiles);
        ModelBuilder north = ((BlockModelBuilder)this.models().cube(b.getRegistryName().func_110623_a() + "_north", upTex, upTex, stoneTiles, stoneTiles, rightTex, leftTex)).texture("particle", "#down");
        ModelBuilder south = ((BlockModelBuilder)this.models().cube(b.getRegistryName().func_110623_a() + "_south", downTex, downTex, stoneTiles, stoneTiles, leftTex, rightTex)).texture("particle", "#down");
        ModelBuilder west = ((BlockModelBuilder)this.models().cube(b.getRegistryName().func_110623_a() + "_west", leftTex, rightTex, rightTex, leftTex, stoneTiles, stoneTiles)).texture("particle", "#down");
        ModelBuilder east = ((BlockModelBuilder)this.models().cube(b.getRegistryName().func_110623_a() + "_east", rightTex, leftTex, leftTex, rightTex, stoneTiles, stoneTiles)).texture("particle", "#down");
        this.getVariantBuilder(b).partialState().with((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.DOWN).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)down)});
        this.getVariantBuilder(b).partialState().with((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.UP).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)up)});
        this.getVariantBuilder(b).partialState().with((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.NORTH).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)north)});
        this.getVariantBuilder(b).partialState().with((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.SOUTH).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)south)});
        this.getVariantBuilder(b).partialState().with((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.WEST).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)west)});
        this.getVariantBuilder(b).partialState().with((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.EAST).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)east)});
    }

    private void casketStuff() {
        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("casket_obsidian", TwilightForestMod.prefix("block/casket_solid_template"))).texture("top", new ResourceLocation("block/obsidian"))).texture("side", new ResourceLocation("block/obsidian"));
        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("casket_stone", TwilightForestMod.prefix("block/casket_solid_template"))).texture("top", new ResourceLocation("block/stone"))).texture("side", new ResourceLocation("block/stone"));
        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("casket_basalt", TwilightForestMod.prefix("block/casket_solid_template"))).texture("top", new ResourceLocation("block/basalt_top"))).texture("side", new ResourceLocation("block/basalt_side"));
    }

    private void registerSmokersAndJets() {
        this.simpleBlock((Block)TFBlocks.smoker.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/jet")))});
        this.simpleBlock((Block)TFBlocks.fire_jet.get(), new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(TwilightForestMod.prefix("block/jet")))});
        ModelBuilder smokerOff = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.encased_smoker.getId().func_110623_a(), TwilightForestMod.prefix("block/util/cube_bottom_top_3_layer"))).texture("top", TwilightForestMod.prefix("block/towerdev_ghasttraplid_off"))).texture("side", TwilightForestMod.prefix("block/towerdev_smoker_off"))).texture("bottom", this.blockTexture((Block)TFBlocks.tower_wood_encased.get()))).texture("top2", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_ghasttraplid_off_1"))).texture("side2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_smoker_1"))).texture("top3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_ghasttraplid_off_1"))).texture("side3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_smoker_off_1"));
        ModelBuilder smokerOn = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.encased_smoker.getId().func_110623_a() + "_on", TwilightForestMod.prefix("block/util/cube_bottom_top_3_layer"))).texture("top", TwilightForestMod.prefix("block/towerdev_ghasttraplid_on"))).texture("side", TwilightForestMod.prefix("block/towerdev_firejet_on"))).texture("bottom", this.blockTexture((Block)TFBlocks.tower_wood_encased.get()))).texture("top2", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_ghasttraplid_on_1"))).texture("side2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_smoker_1"))).texture("top3", TwilightForestMod.prefix("block/tower_device_level_3/towerdev_ghasttraplid_on_2"))).texture("side3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_smoker_on_1"));
        this.getVariantBuilder((Block)TFBlocks.encased_smoker.get()).partialState().with((Property)EncasedSmokerBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)smokerOff)});
        this.getVariantBuilder((Block)TFBlocks.encased_smoker.get()).partialState().with((Property)EncasedSmokerBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)smokerOn)});
        ModelBuilder encasedJetOff = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.encased_fire_jet.getId().func_110623_a(), TwilightForestMod.prefix("block/util/cube_bottom_top_3_layer"))).texture("top", TwilightForestMod.prefix("block/towerdev_ghasttraplid_off"))).texture("side", TwilightForestMod.prefix("block/towerdev_firejet_off"))).texture("bottom", this.blockTexture((Block)TFBlocks.tower_wood_encased.get()))).texture("top2", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_ghasttraplid_off_1"))).texture("side2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_firejet_1"))).texture("top3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_ghasttraplid_off_1"))).texture("side3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_firejet_off_1"));
        ModelBuilder encasedJetOn = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.encased_fire_jet.getId().func_110623_a() + "_on", TwilightForestMod.prefix("block/util/cube_bottom_top_3_layer"))).texture("top", TwilightForestMod.prefix("block/towerdev_ghasttraplid_on"))).texture("side", TwilightForestMod.prefix("block/towerdev_firejet_on"))).texture("bottom", this.blockTexture((Block)TFBlocks.tower_wood_encased.get()))).texture("top2", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_ghasttraplid_on_1"))).texture("side2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_firejet_1"))).texture("top3", TwilightForestMod.prefix("block/tower_device_level_3/towerdev_ghasttraplid_on_2"))).texture("side3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_firejet_on_1"));
        this.getVariantBuilder((Block)TFBlocks.encased_fire_jet.get()).partialState().with(FireJetBlock.STATE, (Comparable)((Object)FireJetVariant.IDLE)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)encasedJetOff)});
        this.getVariantBuilder((Block)TFBlocks.encased_fire_jet.get()).partialState().with(FireJetBlock.STATE, (Comparable)((Object)FireJetVariant.POPPING)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)encasedJetOn)});
        this.getVariantBuilder((Block)TFBlocks.encased_fire_jet.get()).partialState().with(FireJetBlock.STATE, (Comparable)((Object)FireJetVariant.FLAME)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)encasedJetOn)});
    }

    private void registerPlantBlocks() {
        this.simpleBlockExisting((Block)TFBlocks.moss_patch.get());
        this.simpleBlockExisting((Block)TFBlocks.mayapple.get());
        ConfiguredModel[] cloverModels = new ConfiguredModel[4];
        for (int i = 0; i < 4; ++i) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.clover_patch.getId().func_110623_a() + "_" + i, TwilightForestMod.prefix("block/util/flat_tex"))).texture("particle", TwilightForestMod.prefix("block/cloverpatch"))).texture("texture", TwilightForestMod.prefix("block/patch/clover_" + i))).texture("ctm", TwilightForestMod.prefix("block/patch/clover_" + i + "_ctm"));
            cloverModels[i] = new ConfiguredModel((ModelFile)model);
        }
        this.simpleBlock((Block)TFBlocks.clover_patch.get(), cloverModels);
        this.simpleBlock((Block)TFBlocks.fiddlehead.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.fiddlehead.getId().func_110623_a(), "block/tinted_cross")).texture("cross", this.blockTexture((Block)TFBlocks.fiddlehead.get())));
        this.simpleBlock((Block)TFBlocks.mushgloom.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.mushgloom.getId().func_110623_a(), TwilightForestMod.prefix("block/util/cross_2_layer"))).texture("cross", this.blockTexture((Block)TFBlocks.mushgloom.get()))).texture("cross2", TwilightForestMod.prefix("block/" + TFBlocks.mushgloom.getId().func_110623_a() + "_head")));
        this.simpleBlock((Block)TFBlocks.torchberry_plant.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.torchberry_plant.getId().func_110623_a(), TwilightForestMod.prefix("block/util/cross_2_layer"))).texture("cross", this.blockTexture((Block)TFBlocks.torchberry_plant.get()))).texture("cross2", TwilightForestMod.prefix("block/" + TFBlocks.torchberry_plant.getId().func_110623_a() + "_glow")));
        this.simpleBlockExisting((Block)TFBlocks.root_strand.get());
        this.simpleBlockExisting((Block)TFBlocks.fallen_leaves.get());
    }

    private void registerWoodBlocks() {
        this.logWoodSapling((RotatedPillarBlock)TFBlocks.oak_log.get(), (RotatedPillarBlock)TFBlocks.stripped_oak_log.get(), (RotatedPillarBlock)TFBlocks.oak_wood.get(), (RotatedPillarBlock)TFBlocks.stripped_oak_wood.get(), (Block)TFBlocks.oak_sapling.get());
        this.plankBlocks("twilight_oak", (Block)TFBlocks.twilight_oak_planks.get(), (Block)TFBlocks.twilight_oak_slab.get(), (StairsBlock)TFBlocks.twilight_oak_stairs.get(), (Block)TFBlocks.twilight_oak_button.get(), (Block)TFBlocks.twilight_oak_fence.get(), (Block)TFBlocks.twilight_oak_gate.get(), (Block)TFBlocks.twilight_oak_plate.get(), (DoorBlock)TFBlocks.twilight_oak_door.get(), (TrapDoorBlock)TFBlocks.twilight_oak_trapdoor.get());
        this.singleBlockBoilerPlate((Block)TFBlocks.oak_leaves.get(), "block/leaves", m -> {
            BlockModelBuilder cfr_ignored_0 = (BlockModelBuilder)m.texture("all", "minecraft:block/oak_leaves");
        });
        ResourceLocation rainboakSaplTex = TwilightForestMod.prefix("block/" + TFBlocks.rainboak_sapling.getId().func_110623_a());
        this.simpleBlock((Block)TFBlocks.rainboak_sapling.get(), (ModelFile)this.models().cross(TFBlocks.rainboak_sapling.getId().func_110623_a(), rainboakSaplTex));
        this.singleBlockBoilerPlate((Block)TFBlocks.rainboak_leaves.get(), "block/leaves", m -> {
            BlockModelBuilder cfr_ignored_0 = (BlockModelBuilder)m.texture("all", "minecraft:block/oak_leaves");
        });
        this.logWoodSapling((RotatedPillarBlock)TFBlocks.canopy_log.get(), (RotatedPillarBlock)TFBlocks.stripped_canopy_log.get(), (RotatedPillarBlock)TFBlocks.canopy_wood.get(), (RotatedPillarBlock)TFBlocks.stripped_canopy_wood.get(), (Block)TFBlocks.canopy_sapling.get());
        this.plankBlocks("canopy", (Block)TFBlocks.canopy_planks.get(), (Block)TFBlocks.canopy_slab.get(), (StairsBlock)TFBlocks.canopy_stairs.get(), (Block)TFBlocks.canopy_button.get(), (Block)TFBlocks.canopy_fence.get(), (Block)TFBlocks.canopy_gate.get(), (Block)TFBlocks.canopy_plate.get(), (DoorBlock)TFBlocks.canopy_door.get(), (TrapDoorBlock)TFBlocks.canopy_trapdoor.get());
        this.singleBlockBoilerPlate((Block)TFBlocks.canopy_leaves.get(), "block/leaves", m -> {
            BlockModelBuilder cfr_ignored_0 = (BlockModelBuilder)m.texture("all", "minecraft:block/spruce_leaves");
        });
        this.logWoodSapling((RotatedPillarBlock)TFBlocks.mangrove_log.get(), (RotatedPillarBlock)TFBlocks.stripped_mangrove_log.get(), (RotatedPillarBlock)TFBlocks.mangrove_wood.get(), (RotatedPillarBlock)TFBlocks.stripped_mangrove_wood.get(), (Block)TFBlocks.mangrove_sapling.get());
        this.plankBlocks("mangrove", (Block)TFBlocks.mangrove_planks.get(), (Block)TFBlocks.mangrove_slab.get(), (StairsBlock)TFBlocks.mangrove_stairs.get(), (Block)TFBlocks.mangrove_button.get(), (Block)TFBlocks.mangrove_fence.get(), (Block)TFBlocks.mangrove_gate.get(), (Block)TFBlocks.mangrove_plate.get(), (DoorBlock)TFBlocks.mangrove_door.get(), (TrapDoorBlock)TFBlocks.mangrove_trapdoor.get());
        this.singleBlockBoilerPlate((Block)TFBlocks.mangrove_leaves.get(), "block/leaves", m -> {
            BlockModelBuilder cfr_ignored_0 = (BlockModelBuilder)m.texture("all", "minecraft:block/birch_leaves");
        });
        this.logWoodSapling((RotatedPillarBlock)TFBlocks.dark_log.get(), (RotatedPillarBlock)TFBlocks.stripped_dark_log.get(), (RotatedPillarBlock)TFBlocks.dark_wood.get(), (RotatedPillarBlock)TFBlocks.stripped_dark_wood.get(), (Block)TFBlocks.darkwood_sapling.get());
        this.plankBlocks("darkwood", (Block)TFBlocks.dark_planks.get(), (Block)TFBlocks.dark_slab.get(), (StairsBlock)TFBlocks.dark_stairs.get(), (Block)TFBlocks.dark_button.get(), (Block)TFBlocks.dark_fence.get(), (Block)TFBlocks.dark_gate.get(), (Block)TFBlocks.dark_plate.get(), (DoorBlock)TFBlocks.dark_door.get(), (TrapDoorBlock)TFBlocks.dark_trapdoor.get());
        this.singleBlockBoilerPlate((Block)TFBlocks.dark_leaves.get(), "block/leaves", m -> {
            BlockModelBuilder cfr_ignored_0 = (BlockModelBuilder)m.texture("all", "block/darkwood_leaves");
        });
        this.logWoodSapling((RotatedPillarBlock)TFBlocks.time_log.get(), (RotatedPillarBlock)TFBlocks.stripped_time_log.get(), (RotatedPillarBlock)TFBlocks.time_wood.get(), (RotatedPillarBlock)TFBlocks.stripped_time_wood.get(), (Block)TFBlocks.time_sapling.get());
        this.plankBlocks("time", (Block)TFBlocks.time_planks.get(), (Block)TFBlocks.time_slab.get(), (StairsBlock)TFBlocks.time_stairs.get(), (Block)TFBlocks.time_button.get(), (Block)TFBlocks.time_fence.get(), (Block)TFBlocks.time_gate.get(), (Block)TFBlocks.time_plate.get(), (DoorBlock)TFBlocks.time_door.get(), (TrapDoorBlock)TFBlocks.time_trapdoor.get());
        this.singleBlockBoilerPlate((Block)TFBlocks.time_leaves.get(), "block/leaves", m -> {
            BlockModelBuilder cfr_ignored_0 = (BlockModelBuilder)m.texture("all", "block/time_leaves");
        });
        this.magicLogCore((Block)TFBlocks.time_log_core.get());
        this.logWoodSapling((RotatedPillarBlock)TFBlocks.transformation_log.get(), (RotatedPillarBlock)TFBlocks.stripped_transformation_log.get(), (RotatedPillarBlock)TFBlocks.transformation_wood.get(), (RotatedPillarBlock)TFBlocks.stripped_transformation_wood.get(), (Block)TFBlocks.transformation_sapling.get());
        this.plankBlocks("trans", (Block)TFBlocks.trans_planks.get(), (Block)TFBlocks.trans_slab.get(), (StairsBlock)TFBlocks.trans_stairs.get(), (Block)TFBlocks.trans_button.get(), (Block)TFBlocks.trans_fence.get(), (Block)TFBlocks.trans_gate.get(), (Block)TFBlocks.trans_plate.get(), (DoorBlock)TFBlocks.trans_door.get(), (TrapDoorBlock)TFBlocks.trans_trapdoor.get());
        this.singleBlockBoilerPlate((Block)TFBlocks.transformation_leaves.get(), "block/leaves", m -> {
            BlockModelBuilder cfr_ignored_0 = (BlockModelBuilder)m.texture("all", "block/transformation_leaves");
        });
        this.magicLogCore((Block)TFBlocks.transformation_log_core.get());
        this.logWoodSapling((RotatedPillarBlock)TFBlocks.mining_log.get(), (RotatedPillarBlock)TFBlocks.stripped_mining_log.get(), (RotatedPillarBlock)TFBlocks.mining_wood.get(), (RotatedPillarBlock)TFBlocks.stripped_mining_wood.get(), (Block)TFBlocks.mining_sapling.get());
        this.plankBlocks("mine", (Block)TFBlocks.mine_planks.get(), (Block)TFBlocks.mine_slab.get(), (StairsBlock)TFBlocks.mine_stairs.get(), (Block)TFBlocks.mine_button.get(), (Block)TFBlocks.mine_fence.get(), (Block)TFBlocks.mine_gate.get(), (Block)TFBlocks.mine_plate.get(), (DoorBlock)TFBlocks.mine_door.get(), (TrapDoorBlock)TFBlocks.mine_trapdoor.get());
        this.singleBlockBoilerPlate((Block)TFBlocks.mining_leaves.get(), "block/leaves", m -> {
            BlockModelBuilder cfr_ignored_0 = (BlockModelBuilder)m.texture("all", "block/mining_leaves");
        });
        this.magicLogCore((Block)TFBlocks.mining_log_core.get());
        this.logWoodSapling((RotatedPillarBlock)TFBlocks.sorting_log.get(), (RotatedPillarBlock)TFBlocks.stripped_sorting_log.get(), (RotatedPillarBlock)TFBlocks.sorting_wood.get(), (RotatedPillarBlock)TFBlocks.stripped_sorting_wood.get(), (Block)TFBlocks.sorting_sapling.get());
        this.plankBlocks("sort", (Block)TFBlocks.sort_planks.get(), (Block)TFBlocks.sort_slab.get(), (StairsBlock)TFBlocks.sort_stairs.get(), (Block)TFBlocks.sort_button.get(), (Block)TFBlocks.sort_fence.get(), (Block)TFBlocks.sort_gate.get(), (Block)TFBlocks.sort_plate.get(), (DoorBlock)TFBlocks.sort_door.get(), (TrapDoorBlock)TFBlocks.sort_trapdoor.get());
        this.singleBlockBoilerPlate((Block)TFBlocks.sorting_leaves.get(), "block/leaves", m -> {
            BlockModelBuilder cfr_ignored_0 = (BlockModelBuilder)m.texture("all", "block/sorting_leaves");
        });
        this.magicLogCore((Block)TFBlocks.sorting_log_core.get());
    }

    private void magicLogCore(Block b) {
        ResourceLocation topTex = TwilightForestMod.prefix("block/" + b.getRegistryName().func_110623_a().replace("_core", "_top"));
        ModelBuilder off = this.models().cubeColumn(b.getRegistryName().func_110623_a(), this.blockTexture(b), topTex);
        ModelBuilder on = this.models().cubeColumn(b.getRegistryName().func_110623_a() + "_on", TwilightForestMod.prefix("block/" + b.getRegistryName().func_110623_a() + "_on"), topTex);
        this.getVariantBuilder(b).forAllStates(arg_0 -> BlockstateGenerator.lambda$magicLogCore$14((ModelFile)on, (ModelFile)off, arg_0));
    }

    private void rotationallyCorrectColumn(Block b) {
        ResourceLocation side = TwilightForestMod.prefix("block/" + b.getRegistryName().func_110623_a() + "_side");
        ResourceLocation end = TwilightForestMod.prefix("block/" + b.getRegistryName().func_110623_a() + "_end");
        ConfiguredModel yModel = new ConfiguredModel((ModelFile)this.models().cubeColumn(b.getRegistryName().func_110623_a(), side, end));
        ConfiguredModel xModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(b.getRegistryName().func_110623_a() + "_x", TwilightForestMod.prefix("block/util/cube_column_rotationally_correct_x"))).texture("side", side)).texture("end", end)).rotationX(90).rotationY(90).buildLast();
        ConfiguredModel zModel = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(b.getRegistryName().func_110623_a() + "_z", TwilightForestMod.prefix("block/util/cube_column_rotationally_correct_z"))).texture("side", side)).texture("end", end)).rotationX(90).buildLast();
        this.getVariantBuilder(b).partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y).setModels(new ConfiguredModel[]{yModel}).partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X).setModels(new ConfiguredModel[]{xModel}).partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z).setModels(new ConfiguredModel[]{zModel});
    }

    private void castleDoor(Block b) {
        ModelFile.ExistingModelFile overlay = this.models().getExistingFile(TwilightForestMod.prefix("block/castle_door_overlay"));
        ModelBuilder main = this.models().cubeAll(b.getRegistryName().func_110623_a(), TwilightForestMod.prefix("block/castle_door"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)overlay).addModel()).end().part().modelFile((ModelFile)main).addModel()).condition((Property)CastleDoorBlock.VANISHED, (Comparable[])new Boolean[]{false}).end();
    }

    private void allRotations(Block b, ModelFile model) {
        int[] rots;
        ConfiguredModel.Builder builder = ConfiguredModel.builder();
        for (int x : rots = new int[]{0, 90, 180, 270}) {
            for (int y : rots) {
                builder = builder.modelFile(model).rotationX(x).rotationY(y);
                if (x == rots[rots.length - 1] || y == rots[rots.length - 1]) continue;
                builder = builder.nextModel();
            }
        }
        this.simpleBlock(b, builder.build());
    }

    private void builtinEntity(Block b, String particle) {
        this.simpleBlock(b, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(b.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).texture("particle", particle));
    }

    private void simpleBlockExisting(Block b) {
        this.simpleBlock(b, new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(TwilightForestMod.prefix(b.getRegistryName().func_110623_a())))});
    }

    private void singleBlockBoilerPlate(Block b, String parent, Consumer<BlockModelBuilder> modelCustomizer) {
        BlockModelBuilder bModel = (BlockModelBuilder)this.models().withExistingParent(b.getRegistryName().func_110623_a(), parent);
        modelCustomizer.accept(bModel);
        this.simpleBlock(b, (ModelFile)bModel);
    }

    private BlockModelBuilder cubeAllTinted(String name, String all, boolean flipV) {
        String parent = flipV ? "block/util/tinted_cube_all_flipped_v" : "block/util/tinted_cube_all";
        return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, TwilightForestMod.prefix(parent))).texture("all", "block/" + all);
    }

    private BlockModelBuilder cubeAllTinted(String name, String all) {
        return this.cubeAllTinted(name, all, false);
    }

    private void tintedAndFlipped(Block b) {
        this.simpleBlock(b, ConfiguredModel.builder().modelFile((ModelFile)this.cubeAllTinted(b.getRegistryName().func_110623_a(), b.getRegistryName().func_110623_a())).nextModel().modelFile((ModelFile)this.cubeAllTinted(b.getRegistryName().func_110623_a() + "_flipped", b.getRegistryName().func_110623_a(), true)).build());
    }

    private void logWoodSapling(RotatedPillarBlock log, RotatedPillarBlock slog, RotatedPillarBlock wood, RotatedPillarBlock swood, Block sapling) {
        this.logBlock(log);
        this.logBlock(slog);
        ResourceLocation sideTex = this.blockTexture((Block)log);
        this.axisBlock(wood, sideTex, sideTex);
        ResourceLocation sSideTex = this.blockTexture((Block)slog);
        this.axisBlock(swood, sSideTex, sSideTex);
        ResourceLocation saplingTex = TwilightForestMod.prefix("block/" + sapling.getRegistryName().func_110623_a());
        this.simpleBlock(sapling, (ModelFile)this.models().cross(sapling.getRegistryName().func_110623_a(), saplingTex));
    }

    private void plankBlocks(String variant, Block plank, Block slab, StairsBlock stair, Block button, Block fence, Block gate, Block plate, DoorBlock door, TrapDoorBlock trapdoor) {
        String plankTexName = "planks_" + variant;
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + plankTexName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + plankTexName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + plankTexName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + plankTexName + "_3");
        ConfiguredModel[] plankModels = ConfiguredModel.builder().weight(10).modelFile((ModelFile)this.models().cubeAll(plank.getRegistryName().func_110623_a(), tex0)).nextModel().weight(10).modelFile((ModelFile)this.models().cubeAll(plank.getRegistryName().func_110623_a() + "_1", tex1)).nextModel().weight(1).modelFile((ModelFile)this.models().cubeAll(plank.getRegistryName().func_110623_a() + "_2", tex2)).nextModel().weight(1).modelFile((ModelFile)this.models().cubeAll(plank.getRegistryName().func_110623_a() + "_3", tex3)).build();
        this.simpleBlock(plank, plankModels);
        ConfiguredModel[] bottomSlabModels = ConfiguredModel.builder().weight(10).modelFile((ModelFile)this.models().slab(slab.getRegistryName().func_110623_a(), tex0, tex0, tex0)).nextModel().weight(10).modelFile((ModelFile)this.models().slab(slab.getRegistryName().func_110623_a() + "_1", tex1, tex1, tex1)).nextModel().weight(1).modelFile((ModelFile)this.models().slab(slab.getRegistryName().func_110623_a() + "_2", tex2, tex2, tex2)).nextModel().weight(1).modelFile((ModelFile)this.models().slab(slab.getRegistryName().func_110623_a() + "_3", tex3, tex3, tex3)).build();
        ConfiguredModel[] topSlabModels = ConfiguredModel.builder().weight(10).uvLock(true).rotationX(180).modelFile(bottomSlabModels[0].model).nextModel().weight(10).uvLock(true).rotationX(180).modelFile(bottomSlabModels[1].model).nextModel().weight(1).uvLock(true).rotationX(180).modelFile(bottomSlabModels[2].model).nextModel().weight(1).uvLock(true).rotationX(180).modelFile(bottomSlabModels[3].model).build();
        this.getVariantBuilder(slab).partialState().with((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM).setModels(bottomSlabModels);
        this.getVariantBuilder(slab).partialState().with((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP).setModels(topSlabModels);
        this.getVariantBuilder(slab).partialState().with((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE).setModels(plankModels);
        this.woodStairs(stair, plankTexName);
        this.woodButton(button, plankTexName);
        this.woodFence(fence, plankTexName);
        this.woodGate(gate, plankTexName);
        this.woodPlate(plate, plankTexName);
        this.doorBlock(door, TwilightForestMod.prefix("block/wood/door/" + variant + "_lower"), TwilightForestMod.prefix("block/wood/door/" + variant + "_upper"));
        this.trapdoorBlock(trapdoor, TwilightForestMod.prefix("block/wood/trapdoor/" + variant + "_trapdoor"), true);
    }

    private void woodGate(Block gate, String texName) {
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ModelBuilder gate0 = this.models().fenceGate(gate.getRegistryName().func_110623_a(), tex0);
        ModelBuilder gate1 = this.models().fenceGate(gate.getRegistryName().func_110623_a() + "_1", tex1);
        ModelBuilder gate2 = this.models().fenceGate(gate.getRegistryName().func_110623_a() + "_2", tex2);
        ModelBuilder gate3 = this.models().fenceGate(gate.getRegistryName().func_110623_a() + "_3", tex3);
        ModelBuilder open0 = this.models().fenceGateOpen(gate.getRegistryName().func_110623_a() + "_open", tex0);
        ModelBuilder open1 = this.models().fenceGateOpen(gate.getRegistryName().func_110623_a() + "_open_1", tex1);
        ModelBuilder open2 = this.models().fenceGateOpen(gate.getRegistryName().func_110623_a() + "_open_2", tex2);
        ModelBuilder open3 = this.models().fenceGateOpen(gate.getRegistryName().func_110623_a() + "_open_3", tex3);
        ModelBuilder wall0 = this.models().fenceGateWall(gate.getRegistryName().func_110623_a() + "_wall", tex0);
        ModelBuilder wall1 = this.models().fenceGateWall(gate.getRegistryName().func_110623_a() + "_wall_1", tex1);
        ModelBuilder wall2 = this.models().fenceGateWall(gate.getRegistryName().func_110623_a() + "_wall_2", tex2);
        ModelBuilder wall3 = this.models().fenceGateWall(gate.getRegistryName().func_110623_a() + "_wall_3", tex3);
        ModelBuilder wallOpen0 = this.models().fenceGateWallOpen(gate.getRegistryName().func_110623_a() + "_wall_open", tex0);
        ModelBuilder wallOpen1 = this.models().fenceGateWallOpen(gate.getRegistryName().func_110623_a() + "_wall_open_1", tex1);
        ModelBuilder wallOpen2 = this.models().fenceGateWallOpen(gate.getRegistryName().func_110623_a() + "_wall_open_2", tex2);
        ModelBuilder wallOpen3 = this.models().fenceGateWallOpen(gate.getRegistryName().func_110623_a() + "_wall_open_3", tex3);
        this.getVariantBuilder(gate).forAllStatesExcept(arg_0 -> BlockstateGenerator.lambda$woodGate$15((ModelFile)gate0, (ModelFile)gate1, (ModelFile)gate2, (ModelFile)gate3, (ModelFile)wall0, (ModelFile)wall1, (ModelFile)wall2, (ModelFile)wall3, (ModelFile)wallOpen0, (ModelFile)open0, (ModelFile)wallOpen1, (ModelFile)open1, (ModelFile)wallOpen2, (ModelFile)open2, (ModelFile)wallOpen3, (ModelFile)open3, arg_0), new Property[]{FenceGateBlock.field_176465_b});
    }

    private void woodFence(Block fence, String texName) {
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ModelBuilder post0 = this.models().fencePost(fence.getRegistryName().func_110623_a() + "_post", tex0);
        ModelBuilder post1 = this.models().fencePost(fence.getRegistryName().func_110623_a() + "_post_1", tex1);
        ModelBuilder post2 = this.models().fencePost(fence.getRegistryName().func_110623_a() + "_post_2", tex2);
        ModelBuilder post3 = this.models().fencePost(fence.getRegistryName().func_110623_a() + "_post_3", tex3);
        ModelBuilder side0 = this.models().fenceSide(fence.getRegistryName().func_110623_a() + "_side", tex0);
        ModelBuilder side1 = this.models().fenceSide(fence.getRegistryName().func_110623_a() + "_side_1", tex1);
        ModelBuilder side2 = this.models().fenceSide(fence.getRegistryName().func_110623_a() + "_side_2", tex2);
        ModelBuilder side3 = this.models().fenceSide(fence.getRegistryName().func_110623_a() + "_side_3", tex3);
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(fence).part().weight(10).modelFile((ModelFile)post0).nextModel().weight(10).modelFile((ModelFile)post1).nextModel().weight(1).modelFile((ModelFile)post2).nextModel().weight(1).modelFile((ModelFile)post3).addModel()).end();
        SixWayBlock.field_196491_B.forEach((arg_0, arg_1) -> BlockstateGenerator.lambda$woodFence$16(builder, (ModelFile)side0, (ModelFile)side1, (ModelFile)side2, (ModelFile)side3, arg_0, arg_1));
    }

    private void woodPlate(Block plate, String texName) {
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ConfiguredModel[] unpressed = ConfiguredModel.builder().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plate.getRegistryName().func_110623_a(), "pressure_plate_up")).texture("texture", tex0)).nextModel().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plate.getRegistryName().func_110623_a() + "_1", "pressure_plate_up")).texture("texture", tex1)).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plate.getRegistryName().func_110623_a() + "_2", "pressure_plate_up")).texture("texture", tex2)).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plate.getRegistryName().func_110623_a() + "_3", "pressure_plate_up")).texture("texture", tex3)).build();
        ConfiguredModel[] pressed = ConfiguredModel.builder().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plate.getRegistryName().func_110623_a() + "_down", "pressure_plate_down")).texture("texture", tex0)).nextModel().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plate.getRegistryName().func_110623_a() + "_down_1", "pressure_plate_down")).texture("texture", tex1)).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plate.getRegistryName().func_110623_a() + "_down_2", "pressure_plate_down")).texture("texture", tex2)).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plate.getRegistryName().func_110623_a() + "_down_3", "pressure_plate_down")).texture("texture", tex3)).build();
        this.getVariantBuilder(plate).partialState().with((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(false)).setModels(unpressed);
        this.getVariantBuilder(plate).partialState().with((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(true)).setModels(pressed);
    }

    private void woodButton(Block button, String texName) {
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ModelBuilder unpressed0 = ((BlockModelBuilder)this.models().withExistingParent(button.getRegistryName().func_110623_a(), "button")).texture("texture", tex0);
        ModelBuilder pressed0 = ((BlockModelBuilder)this.models().withExistingParent(button.getRegistryName().func_110623_a() + "_pressed", "button_pressed")).texture("texture", tex0);
        ModelBuilder unpressed1 = ((BlockModelBuilder)this.models().withExistingParent(button.getRegistryName().func_110623_a() + "_1", "button")).texture("texture", tex1);
        ModelBuilder pressed1 = ((BlockModelBuilder)this.models().withExistingParent(button.getRegistryName().func_110623_a() + "_pressed_1", "button_pressed")).texture("texture", tex1);
        ModelBuilder unpressed2 = ((BlockModelBuilder)this.models().withExistingParent(button.getRegistryName().func_110623_a() + "_2", "button")).texture("texture", tex2);
        ModelBuilder pressed2 = ((BlockModelBuilder)this.models().withExistingParent(button.getRegistryName().func_110623_a() + "_pressed_2", "button_pressed")).texture("texture", tex2);
        ModelBuilder unpressed3 = ((BlockModelBuilder)this.models().withExistingParent(button.getRegistryName().func_110623_a() + "_3", "button")).texture("texture", tex3);
        ModelBuilder pressed3 = ((BlockModelBuilder)this.models().withExistingParent(button.getRegistryName().func_110623_a() + "_pressed_3", "button_pressed")).texture("texture", tex3);
        this.getVariantBuilder(button).forAllStates(arg_0 -> BlockstateGenerator.lambda$woodButton$17((ModelFile)pressed0, (ModelFile)unpressed0, (ModelFile)pressed1, (ModelFile)unpressed1, (ModelFile)pressed2, (ModelFile)unpressed2, (ModelFile)pressed3, (ModelFile)unpressed3, arg_0));
    }

    private void woodStairs(StairsBlock block, String texName) {
        ResourceLocation tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        ResourceLocation tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        ResourceLocation tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        ResourceLocation tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ModelBuilder main0 = this.models().stairs(block.getRegistryName().func_110623_a(), tex0, tex0, tex0);
        ModelBuilder main1 = this.models().stairs(block.getRegistryName().func_110623_a() + "_1", tex1, tex1, tex1);
        ModelBuilder main2 = this.models().stairs(block.getRegistryName().func_110623_a() + "_2", tex2, tex2, tex2);
        ModelBuilder main3 = this.models().stairs(block.getRegistryName().func_110623_a() + "_3", tex3, tex3, tex3);
        ModelBuilder inner0 = this.models().stairsInner(block.getRegistryName().func_110623_a() + "_inner", tex0, tex0, tex0);
        ModelBuilder inner1 = this.models().stairsInner(block.getRegistryName().func_110623_a() + "_inner_1", tex1, tex1, tex1);
        ModelBuilder inner2 = this.models().stairsInner(block.getRegistryName().func_110623_a() + "_inner_2", tex2, tex2, tex2);
        ModelBuilder inner3 = this.models().stairsInner(block.getRegistryName().func_110623_a() + "_inner_3", tex3, tex3, tex3);
        ModelBuilder outer0 = this.models().stairsOuter(block.getRegistryName().func_110623_a() + "_outer", tex0, tex0, tex0);
        ModelBuilder outer1 = this.models().stairsOuter(block.getRegistryName().func_110623_a() + "_outer_1", tex1, tex1, tex1);
        ModelBuilder outer2 = this.models().stairsOuter(block.getRegistryName().func_110623_a() + "_outer_2", tex2, tex2, tex2);
        ModelBuilder outer3 = this.models().stairsOuter(block.getRegistryName().func_110623_a() + "_outer_3", tex3, tex3, tex3);
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> BlockstateGenerator.lambda$woodStairs$18((ModelFile)main0, (ModelFile)inner0, (ModelFile)outer0, (ModelFile)main1, (ModelFile)inner1, (ModelFile)outer1, (ModelFile)main2, (ModelFile)inner2, (ModelFile)outer2, (ModelFile)main3, (ModelFile)inner3, (ModelFile)outer3, arg_0), new Property[]{StairsBlock.field_204513_t});
    }

    private void stonePillar() {
        ModelBuilder main_x = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pillar_main_x", TwilightForestMod.prefix("block/pillar/pillar_12_ctm"))).texture("side_x", TwilightForestMod.prefix("block/stone_twist/twist_x"))).texture("side_z", TwilightForestMod.prefix("block/stone_twist/twist_x"));
        ModelBuilder bottom_x = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pillar_bottom_x", TwilightForestMod.prefix("block/pillar/pillar_bottom"))).texture("bottom_x", TwilightForestMod.prefix("block/stone_twist/cap/y_y_bottom"))).texture("bottom_z", TwilightForestMod.prefix("block/stone_twist/cap/y_y_bottom"))).texture("bottom_cap", TwilightForestMod.prefix("block/stone_twist/cap/end_bottom_x"));
        ModelBuilder top_x = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pillar_top_x", TwilightForestMod.prefix("block/pillar/pillar_top"))).texture("top_x", TwilightForestMod.prefix("block/stone_twist/cap/y_y_top"))).texture("top_z", TwilightForestMod.prefix("block/stone_twist/cap/y_y_top"))).texture("top_cap", TwilightForestMod.prefix("block/stone_twist/cap/end_top_x"));
        ModelBuilder main_y = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pillar_main_y", TwilightForestMod.prefix("block/pillar/pillar_12_ctm"))).texture("side_x", TwilightForestMod.prefix("block/stone_twist/twist_y"))).texture("side_z", TwilightForestMod.prefix("block/stone_twist/twist_y"));
        ModelBuilder bottom_y = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pillar_bottom_y", TwilightForestMod.prefix("block/pillar/pillar_bottom"))).texture("bottom_x", TwilightForestMod.prefix("block/stone_twist/cap/y_y_bottom"))).texture("bottom_z", TwilightForestMod.prefix("block/stone_twist/cap/y_y_bottom"))).texture("bottom_cap", TwilightForestMod.prefix("block/stone_twist/cap/end_bottom_y"));
        ModelBuilder top_y = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pillar_top_y", TwilightForestMod.prefix("block/pillar/pillar_top"))).texture("top_x", TwilightForestMod.prefix("block/stone_twist/cap/y_y_top"))).texture("top_z", TwilightForestMod.prefix("block/stone_twist/cap/y_y_top"))).texture("top_cap", TwilightForestMod.prefix("block/stone_twist/cap/end_top_y"));
        ModelBuilder main_z = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pillar_main_z", TwilightForestMod.prefix("block/pillar/pillar_12_ctm"))).texture("side_x", TwilightForestMod.prefix("block/stone_twist/twist_x"))).texture("side_z", TwilightForestMod.prefix("block/stone_twist/twist_y"));
        ModelBuilder bottom_z = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pillar_bottom_z", TwilightForestMod.prefix("block/pillar/pillar_bottom"))).texture("bottom_x", TwilightForestMod.prefix("block/stone_twist/cap/y_y_bottom"))).texture("bottom_z", TwilightForestMod.prefix("block/stone_twist/cap/y_y_bottom"))).texture("bottom_cap", TwilightForestMod.prefix("block/stone_twist/cap/end_bottom_z"));
        ModelBuilder top_z = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("pillar_top_z", TwilightForestMod.prefix("block/pillar/pillar_top"))).texture("top_x", TwilightForestMod.prefix("block/stone_twist/cap/y_y_top"))).texture("top_z", TwilightForestMod.prefix("block/stone_twist/cap/y_y_top"))).texture("top_cap", TwilightForestMod.prefix("block/stone_twist/cap/end_top_z"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)TFBlocks.stone_twist_thin.get()).part().modelFile((ModelFile)main_x).uvLock(true).rotationX(90).rotationY(90).addModel()).condition((Property)WallPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile((ModelFile)top_x).rotationX(90).rotationY(90).addModel()).condition((Property)WallPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).condition((Property)SixWayBlock.field_196490_b, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)bottom_x).rotationX(90).rotationY(90).addModel()).condition((Property)WallPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).condition((Property)SixWayBlock.field_196495_y, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)main_y).uvLock(true).addModel()).condition((Property)WallPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.Y}).end().part().modelFile((ModelFile)top_y).addModel()).condition((Property)WallPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.Y}).condition((Property)SixWayBlock.field_196496_z, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)bottom_y).addModel()).condition((Property)WallPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.Y}).condition((Property)SixWayBlock.field_196489_A, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)main_z).uvLock(true).rotationX(90).addModel()).condition((Property)WallPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end().part().modelFile((ModelFile)top_z).rotationX(90).addModel()).condition((Property)WallPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).condition((Property)SixWayBlock.field_196488_a, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)bottom_z).rotationX(90).addModel()).condition((Property)WallPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).condition((Property)SixWayBlock.field_196492_c, (Comparable[])new Boolean[]{false}).end();
    }

    private void slider() {
        ModelFile.ExistingModelFile slider = this.models().getExistingFile(TwilightForestMod.prefix("block/slider"));
        ModelFile.ExistingModelFile horizSlider = this.models().getExistingFile(TwilightForestMod.prefix("block/slider_horiz"));
        this.getVariantBuilder((Block)TFBlocks.slider.get()).forAllStates(arg_0 -> BlockstateGenerator.lambda$slider$19((ModelFile)horizSlider, (ModelFile)slider, arg_0));
    }

    private void towerBlocks() {
        ResourceLocation cube3 = TwilightForestMod.prefix("block/util/cube_all_3_layer");
        ResourceLocation cubeBt3 = TwilightForestMod.prefix("block/util/cube_bottom_top_3_layer");
        ResourceLocation cube2NoShade = TwilightForestMod.prefix("block/util/cube_all_2_layer_no_shade");
        ResourceLocation fourCube = TwilightForestMod.prefix("block/util/4_cubed");
        ModelBuilder reappear = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.reappearing_block.getId().func_110623_a(), cube3)).texture("all", TwilightForestMod.prefix("block/towerdev_reappearing_off"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_reappearing_off_1"))).texture("all3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_reappearing_off_2"));
        ModelBuilder reappearActive = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.reappearing_block.getId().func_110623_a() + "_active", cube3)).texture("all", TwilightForestMod.prefix("block/towerdev_reappearing_on"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_reappearing_on_1"))).texture("all3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_reappearing_on_2"));
        ModelBuilder reappearVanished = ((BlockModelBuilder)this.models().withExistingParent(TFBlocks.reappearing_block.getId().func_110623_a() + "_vanished", fourCube)).texture("all", TwilightForestMod.prefix("block/towerdev_reappearing_trace_off"));
        ModelBuilder reappearVanishedActive = ((BlockModelBuilder)this.models().withExistingParent(TFBlocks.reappearing_block.getId().func_110623_a() + "_vanished_active", fourCube)).texture("all", TwilightForestMod.prefix("block/towerdev_reappearing_trace_on"));
        this.getVariantBuilder((Block)TFBlocks.reappearing_block.get()).forAllStates(arg_0 -> BlockstateGenerator.lambda$towerBlocks$20((ModelFile)reappearVanishedActive, (ModelFile)reappearVanished, (ModelFile)reappearActive, (ModelFile)reappear, arg_0));
        ModelBuilder vanish = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.vanishing_block.getId().func_110623_a(), cube3)).texture("all", TwilightForestMod.prefix("block/towerdev_vanish_off"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_vanish_off_1"))).texture("all3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_vanish_off_2"));
        ModelBuilder vanishActive = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.vanishing_block.getId().func_110623_a() + "_active", cube3)).texture("all", TwilightForestMod.prefix("block/towerdev_vanish_on"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_vanish_on_1"))).texture("all3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_vanish_on_2"));
        this.getVariantBuilder((Block)TFBlocks.vanishing_block.get()).partialState().with((Property)VanishingBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)vanish)});
        this.getVariantBuilder((Block)TFBlocks.vanishing_block.get()).partialState().with((Property)VanishingBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)vanishActive)});
        ModelBuilder vanishLocked = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.locked_vanishing_block.getId().func_110623_a(), cube3)).texture("all", TwilightForestMod.prefix("block/towerdev_lock_on"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_lock_on_1"))).texture("all3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_lock_on_2"));
        ModelBuilder vanishUnlocked = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.locked_vanishing_block.getId().func_110623_a() + "_unlocked", cube3)).texture("all", TwilightForestMod.prefix("block/towerdev_lock_off"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_lock_off_1"))).texture("all3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_lock_off_2"));
        this.getVariantBuilder((Block)TFBlocks.locked_vanishing_block.get()).partialState().with((Property)LockedVanishingBlock.LOCKED, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)vanishLocked)});
        this.getVariantBuilder((Block)TFBlocks.locked_vanishing_block.get()).partialState().with((Property)LockedVanishingBlock.LOCKED, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)vanishUnlocked)});
        ModelBuilder ghastTrap = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.ghast_trap.getId().func_110623_a(), cubeBt3)).texture("top", TwilightForestMod.prefix("block/towerdev_ghasttraplid_off"))).texture("side", TwilightForestMod.prefix("block/towerdev_ghasttrap_off"))).texture("bottom", TwilightForestMod.prefix("block/tower_wood_encased"))).texture("top2", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_ghasttraplid_off_1"))).texture("side2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_ghasttrap_off_1"))).texture("top3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_ghasttraplid_off_1"))).texture("side3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_ghasttrap_off_2"));
        ModelBuilder ghastTrapActive = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.ghast_trap.getId().func_110623_a() + "_active", cubeBt3)).texture("top", TwilightForestMod.prefix("block/towerdev_ghasttraplid_on"))).texture("side", TwilightForestMod.prefix("block/towerdev_ghasttrap_on"))).texture("bottom", TwilightForestMod.prefix("block/tower_wood_encased"))).texture("top2", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_ghasttraplid_on_1"))).texture("side2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_ghasttrap_on_1"))).texture("top3", TwilightForestMod.prefix("block/tower_device_level_3/towerdev_ghasttraplid_on_2"))).texture("side3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_ghasttrap_on_2"));
        this.getVariantBuilder((Block)TFBlocks.ghast_trap.get()).partialState().with((Property)GhastTrapBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)ghastTrap)});
        this.getVariantBuilder((Block)TFBlocks.ghast_trap.get()).partialState().with((Property)GhastTrapBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)ghastTrapActive)});
        ModelBuilder builder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.carminite_builder.getId().func_110623_a(), cube3)).texture("all", TwilightForestMod.prefix("block/towerdev_builder_off"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_builder_off_1"))).texture("all3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_builder_off_2"));
        ModelBuilder builderActive = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.carminite_builder.getId().func_110623_a() + "_active", cube3)).texture("all", TwilightForestMod.prefix("block/towerdev_builder_on"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_builder_on_1"))).texture("all3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_builder_on_2"));
        ModelBuilder builderTimeout = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.carminite_builder.getId().func_110623_a() + "_timeout", cube3)).texture("all", TwilightForestMod.prefix("block/towerdev_builder_timeout"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_builder_timeout_1"))).texture("all3", TwilightForestMod.prefix("block/tower_device_level_3/towerdev_builder_timeout_2"));
        this.getVariantBuilder((Block)TFBlocks.carminite_builder.get()).partialState().with(BuilderBlock.STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)builder)});
        this.getVariantBuilder((Block)TFBlocks.carminite_builder.get()).partialState().with(BuilderBlock.STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_ACTIVE)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)builderActive)});
        this.getVariantBuilder((Block)TFBlocks.carminite_builder.get()).partialState().with(BuilderBlock.STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_TIMEOUT)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)builderTimeout)});
        ModelBuilder built = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.built_block.getId().func_110623_a(), cube2NoShade)).texture("all", TwilightForestMod.prefix("block/towerdev_built_off"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_builder_off_1"));
        ModelBuilder builtActive = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.built_block.getId().func_110623_a() + "_active", cube2NoShade)).texture("all", TwilightForestMod.prefix("block/towerdev_built_on"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_builder_on_1"));
        this.getVariantBuilder((Block)TFBlocks.built_block.get()).partialState().with((Property)TranslucentBuiltBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)built)});
        this.getVariantBuilder((Block)TFBlocks.built_block.get()).partialState().with((Property)TranslucentBuiltBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)builtActive)});
        ModelBuilder antibuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.antibuilder.getId().func_110623_a(), cube3)).texture("all", TwilightForestMod.prefix("block/towerdev_antibuilder"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_antibuilder_1"))).texture("all3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_antibuilder_2"));
        this.simpleBlock((Block)TFBlocks.antibuilder.get(), (ModelFile)antibuilder);
        ModelBuilder antibuilt = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.antibuilt_block.getId().func_110623_a(), cube2NoShade)).texture("all", TwilightForestMod.prefix("block/towerdev_antibuilt"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_antibuilt_1"));
        this.simpleBlock((Block)TFBlocks.antibuilt_block.get(), (ModelFile)antibuilt);
        ModelBuilder reactor = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.carminite_reactor.getId().func_110623_a(), cube3)).texture("all", TwilightForestMod.prefix("block/towerdev_reactor_off"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_reactor_off_1"))).texture("all3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_reactor_off_2"));
        ModelBuilder reactorActive = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.carminite_reactor.getId().func_110623_a() + "_active", cube3)).texture("all", TwilightForestMod.prefix("block/towerdev_reactor_on"))).texture("all2", TwilightForestMod.prefix("block/tower_device_level_1/towerdev_reactor_on_1"))).texture("all3", TwilightForestMod.prefix("block/tower_device_level_2/towerdev_reactor_on_2"));
        this.getVariantBuilder((Block)TFBlocks.carminite_reactor.get()).partialState().with((Property)CarminiteReactorBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)reactor)});
        this.getVariantBuilder((Block)TFBlocks.carminite_reactor.get()).partialState().with((Property)CarminiteReactorBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)reactorActive)});
        this.simpleBlock((Block)TFBlocks.reactor_debris.get(), (ModelFile)this.models().cubeAll(TFBlocks.reactor_debris.getId().func_110623_a(), new ResourceLocation("block/destroy_stage_9")));
    }

    private ModelFile pedestalModel(String name, String north, String south, String west, String east, boolean active) {
        String suffix = active ? "" : "_latent";
        BlockModelBuilder ret = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, TwilightForestMod.prefix(active ? "block/util/pedestal_2_layer" : "block/util/pedestal"))).texture("end", TwilightForestMod.prefix("block/pedestal/top"))).texture("north", TwilightForestMod.prefix("block/pedestal/" + north + suffix))).texture("south", TwilightForestMod.prefix("block/pedestal/" + south + suffix))).texture("west", TwilightForestMod.prefix("block/pedestal/" + west + suffix))).texture("east", TwilightForestMod.prefix("block/pedestal/" + east + suffix));
        if (active) {
            ret = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)ret.texture("end2", TwilightForestMod.prefix("block/pedestal/top_glow"))).texture("north2", TwilightForestMod.prefix("block/pedestal/" + north + "_glow"))).texture("south2", TwilightForestMod.prefix("block/pedestal/" + south + "_glow"))).texture("west2", TwilightForestMod.prefix("block/pedestal/" + west + "_glow"))).texture("east2", TwilightForestMod.prefix("block/pedestal/" + east + "_glow"));
        }
        return ret;
    }

    private void trophyPedestal() {
        String baseName = TFBlocks.trophy_pedestal.getId().func_110623_a();
        ModelFile latent0 = this.pedestalModel(baseName, "naga", "lich", "hydra", "ur-ghast", false);
        ModelFile latent1 = this.pedestalModel(baseName + "_1", "snow_queen", "naga", "lich", "hydra", false);
        ModelFile latent2 = this.pedestalModel(baseName + "_2", "ur-ghast", "snow_queen", "naga", "lich", false);
        ModelFile latent3 = this.pedestalModel(baseName + "_3", "hydra", "ur-ghast", "snow_queen", "naga", false);
        ModelFile latent4 = this.pedestalModel(baseName + "_4", "lich", "hydra", "ur-ghast", "snow_queen", false);
        ArrayList<ConfiguredModel> latentModels = new ArrayList<ConfiguredModel>();
        for (ModelFile f : Arrays.asList(latent0, latent1, latent2, latent3, latent4)) {
            latentModels.add(new ConfiguredModel(f, 0, 0, false));
            latentModels.add(new ConfiguredModel(f, 0, 90, false));
            latentModels.add(new ConfiguredModel(f, 0, 180, false));
            latentModels.add(new ConfiguredModel(f, 0, 270, false));
        }
        this.getVariantBuilder((Block)TFBlocks.trophy_pedestal.get()).partialState().with((Property)TrophyPedestalBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).setModels(latentModels.toArray(new ConfiguredModel[0]));
        ModelFile active0 = this.pedestalModel(baseName + "_active", "naga", "lich", "hydra", "ur-ghast", true);
        ModelFile active1 = this.pedestalModel(baseName + "_active_1", "snow_queen", "naga", "lich", "hydra", true);
        ModelFile active2 = this.pedestalModel(baseName + "_active_2", "ur-ghast", "snow_queen", "naga", "lich", true);
        ModelFile active3 = this.pedestalModel(baseName + "_active_3", "hydra", "ur-ghast", "snow_queen", "naga", true);
        ModelFile active4 = this.pedestalModel(baseName + "_active_4", "lich", "hydra", "ur-ghast", "snow_queen", true);
        ArrayList<ConfiguredModel> activeModels = new ArrayList<ConfiguredModel>();
        for (ModelFile f : Arrays.asList(active0, active1, active2, active3, active4)) {
            activeModels.add(new ConfiguredModel(f, 0, 0, false));
            activeModels.add(new ConfiguredModel(f, 0, 90, false));
            activeModels.add(new ConfiguredModel(f, 0, 180, false));
            activeModels.add(new ConfiguredModel(f, 0, 270, false));
        }
        this.getVariantBuilder((Block)TFBlocks.trophy_pedestal.get()).partialState().with((Property)TrophyPedestalBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).setModels(activeModels.toArray(new ConfiguredModel[0]));
    }

    private void thorns() {
        boolean fixer = Direction.SOUTH.func_176740_k() == Direction.Axis.Z;
        ModelBuilder green = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.green_thorns.getId().func_110623_a(), TwilightForestMod.prefix("block/thorns_main"))).texture("side", TwilightForestMod.prefix("block/green_thorns_side"))).texture("end", TwilightForestMod.prefix("block/green_thorns_top"));
        ModelBuilder greenBottom = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.green_thorns.getId().func_110623_a() + "_bottom", TwilightForestMod.prefix("block/thorns_section_bottom"))).texture("side", TwilightForestMod.prefix("block/green_thorns_side"))).texture("end", TwilightForestMod.prefix("block/green_thorns_top"));
        ModelBuilder greenTop = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.green_thorns.getId().func_110623_a() + "_top", TwilightForestMod.prefix("block/thorns_section_top"))).texture("side", TwilightForestMod.prefix("block/green_thorns_side"))).texture("end", TwilightForestMod.prefix("block/green_thorns_top"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)TFBlocks.green_thorns.get()).part().modelFile((ModelFile)green).addModel()).condition((Property)RotatedPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.Y}).end().part().modelFile((ModelFile)green).rotationX(90).addModel()).condition((Property)RotatedPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end().part().modelFile((ModelFile)green).rotationX(90).rotationY(90).addModel()).condition((Property)RotatedPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile((ModelFile)greenTop).rotationX(90).addModel()).condition((Property)SixWayBlock.field_196496_z, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)greenBottom).rotationX(90).addModel()).condition((Property)SixWayBlock.field_196489_A, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)greenTop).rotationY(270).addModel()).condition((Property)SixWayBlock.field_196490_b, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)greenBottom).rotationY(270).addModel()).condition((Property)SixWayBlock.field_196495_y, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)(fixer ? greenBottom : greenTop)).rotationY(fixer ? 180 : 0).addModel()).condition((Property)SixWayBlock.field_196492_c, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)(fixer ? greenTop : greenBottom)).rotationY(fixer ? 180 : 0).addModel()).condition((Property)SixWayBlock.field_196488_a, (Comparable[])new Boolean[]{true}).end();
        ModelBuilder brown = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.brown_thorns.getId().func_110623_a(), TwilightForestMod.prefix("block/thorns_main"))).texture("side", TwilightForestMod.prefix("block/brown_thorns_side"))).texture("end", TwilightForestMod.prefix("block/brown_thorns_top"));
        ModelBuilder brownBottom = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.brown_thorns.getId().func_110623_a() + "_bottom", TwilightForestMod.prefix("block/thorns_section_bottom"))).texture("side", TwilightForestMod.prefix("block/brown_thorns_side"))).texture("end", TwilightForestMod.prefix("block/brown_thorns_top"));
        ModelBuilder brownTop = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.brown_thorns.getId().func_110623_a() + "_top", TwilightForestMod.prefix("block/thorns_section_top"))).texture("side", TwilightForestMod.prefix("block/brown_thorns_side"))).texture("end", TwilightForestMod.prefix("block/brown_thorns_top"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)TFBlocks.brown_thorns.get()).part().modelFile((ModelFile)brown).addModel()).condition((Property)RotatedPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.Y}).end().part().modelFile((ModelFile)brown).rotationX(90).addModel()).condition((Property)RotatedPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end().part().modelFile((ModelFile)brown).rotationX(90).rotationY(90).addModel()).condition((Property)RotatedPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile((ModelFile)brownTop).rotationX(90).addModel()).condition((Property)SixWayBlock.field_196496_z, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)brownBottom).rotationX(90).addModel()).condition((Property)SixWayBlock.field_196489_A, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)brownTop).rotationY(270).addModel()).condition((Property)SixWayBlock.field_196490_b, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)brownBottom).rotationY(270).addModel()).condition((Property)SixWayBlock.field_196495_y, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)(fixer ? brownBottom : brownTop)).rotationY(fixer ? 180 : 0).addModel()).condition((Property)SixWayBlock.field_196492_c, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)(fixer ? brownTop : brownBottom)).rotationY(fixer ? 180 : 0).addModel()).condition((Property)SixWayBlock.field_196488_a, (Comparable[])new Boolean[]{true}).end();
        ModelBuilder burnt = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.burnt_thorns.getId().func_110623_a(), TwilightForestMod.prefix("block/thorns_main"))).texture("side", TwilightForestMod.prefix("block/burnt_thorns_side"))).texture("end", TwilightForestMod.prefix("block/burnt_thorns_top"));
        ModelBuilder burntBottom = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.burnt_thorns.getId().func_110623_a() + "_bottom", TwilightForestMod.prefix("block/thorns_section_bottom"))).texture("side", TwilightForestMod.prefix("block/burnt_thorns_side"))).texture("end", TwilightForestMod.prefix("block/burnt_thorns_top"));
        ModelBuilder burntTop = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.burnt_thorns.getId().func_110623_a() + "_top", TwilightForestMod.prefix("block/thorns_section_top"))).texture("side", TwilightForestMod.prefix("block/burnt_thorns_side"))).texture("end", TwilightForestMod.prefix("block/burnt_thorns_top"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)TFBlocks.burnt_thorns.get()).part().modelFile((ModelFile)burnt).addModel()).condition((Property)RotatedPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.Y}).end().part().modelFile((ModelFile)burnt).rotationX(90).addModel()).condition((Property)RotatedPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end().part().modelFile((ModelFile)burnt).rotationX(90).rotationY(90).addModel()).condition((Property)RotatedPillarBlock.field_176298_M, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile((ModelFile)burntTop).rotationX(90).addModel()).condition((Property)SixWayBlock.field_196496_z, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)burntBottom).rotationX(90).addModel()).condition((Property)SixWayBlock.field_196489_A, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)burntTop).rotationY(270).addModel()).condition((Property)SixWayBlock.field_196490_b, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)burntBottom).rotationY(270).addModel()).condition((Property)SixWayBlock.field_196495_y, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)(fixer ? burntBottom : burntTop)).rotationY(fixer ? 180 : 0).addModel()).condition((Property)SixWayBlock.field_196492_c, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)(fixer ? burntTop : burntBottom)).rotationY(fixer ? 180 : 0).addModel()).condition((Property)SixWayBlock.field_196488_a, (Comparable[])new Boolean[]{true}).end();
    }

    private void auroraBlocks() {
        int i;
        int variants = 16;
        ModelFile[] models = new ModelFile[variants];
        for (i = 0; i < variants; ++i) {
            models[i] = ((BlockModelBuilder)this.models().withExistingParent(TFBlocks.aurora_block.getId().func_110623_a() + "_" + i, TwilightForestMod.prefix("block/util/tinted_cube_all"))).texture("all", TwilightForestMod.prefix("block/" + TFBlocks.aurora_block.getId().func_110623_a() + "_" + i));
        }
        for (i = 0; i < variants; ++i) {
            this.getVariantBuilder((Block)TFBlocks.aurora_block.get()).partialState().with((Property)AuroraBrickBlock.VARIANT, (Comparable)Integer.valueOf(i)).setModels(ConfiguredModel.builder().weight(3).modelFile(models[i]).nextModel().weight(1).modelFile(models[(i + 1) % variants]).build());
        }
        ModelBuilder pillarModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.aurora_pillar.getId().func_110623_a(), TwilightForestMod.prefix("block/util/tinted_cube_column"))).texture("end", TwilightForestMod.prefix("block/" + TFBlocks.aurora_pillar.getId().func_110623_a() + "_top"))).texture("side", this.blockTexture((Block)TFBlocks.aurora_pillar.get()));
        this.axisBlock((RotatedPillarBlock)TFBlocks.aurora_pillar.get(), (ModelFile)pillarModel, (ModelFile)pillarModel);
        ModelBuilder slabModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.aurora_slab.getId().func_110623_a(), TwilightForestMod.prefix("block/util/tinted_slab"))).texture("bottom", TwilightForestMod.prefix("block/" + TFBlocks.aurora_pillar.getId().func_110623_a() + "_top"))).texture("top", TwilightForestMod.prefix("block/" + TFBlocks.aurora_pillar.getId().func_110623_a() + "_top"))).texture("side", TwilightForestMod.prefix("block/" + TFBlocks.aurora_slab.getId().func_110623_a() + "_side"));
        ModelBuilder doubleSlabModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(TFBlocks.aurora_slab.getId().func_110623_a() + "_double", TwilightForestMod.prefix("block/util/tinted_cube_column"))).texture("end", TwilightForestMod.prefix("block/" + TFBlocks.aurora_pillar.getId().func_110623_a() + "_top"))).texture("side", TwilightForestMod.prefix("block/" + TFBlocks.aurora_slab.getId().func_110623_a() + "_side"));
        this.getVariantBuilder((Block)TFBlocks.aurora_slab.get()).partialState().with((Property)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)slabModel)});
        this.getVariantBuilder((Block)TFBlocks.aurora_slab.get()).partialState().with((Property)SlabBlock.field_196505_a, (Comparable)SlabType.TOP).setModels(ConfiguredModel.builder().uvLock(true).rotationX(180).modelFile((ModelFile)slabModel).build());
        this.getVariantBuilder((Block)TFBlocks.aurora_slab.get()).partialState().with((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)doubleSlabModel)});
        ModelBuilder auroraGlass = ((BlockModelBuilder)this.models().withExistingParent(TFBlocks.auroralized_glass.getId().func_110623_a(), TwilightForestMod.prefix("block/util/tinted_cube_all"))).texture("all", this.blockTexture((Block)TFBlocks.auroralized_glass.get()));
        this.simpleBlock((Block)TFBlocks.auroralized_glass.get(), (ModelFile)auroraGlass);
    }

    private void mazestone() {
        ResourceLocation plainTex = this.blockTexture((Block)TFBlocks.maze_stone.get());
        ModelBuilder mazeStone = this.models().cubeAll(TFBlocks.maze_stone.getId().func_110623_a(), plainTex);
        this.simpleBlock((Block)TFBlocks.maze_stone.get(), ConfiguredModel.builder().rotationX(90).rotationY(90).modelFile((ModelFile)mazeStone).nextModel().rotationX(270).rotationY(270).modelFile((ModelFile)mazeStone).build());
        this.simpleBlock((Block)TFBlocks.maze_stone_brick.get());
        ModelBuilder chiseled = this.models().cubeColumn(TFBlocks.maze_stone_chiseled.getId().func_110623_a(), this.blockTexture((Block)TFBlocks.maze_stone_chiseled.get()), plainTex);
        this.simpleBlock((Block)TFBlocks.maze_stone_chiseled.get(), (ModelFile)chiseled);
        ModelBuilder decorative = this.models().cubeColumn(TFBlocks.maze_stone_decorative.getId().func_110623_a(), this.blockTexture((Block)TFBlocks.maze_stone_decorative.get()), plainTex);
        this.simpleBlock((Block)TFBlocks.maze_stone_decorative.get(), (ModelFile)decorative);
        this.simpleBlock((Block)TFBlocks.maze_stone_cracked.get());
        this.simpleBlock((Block)TFBlocks.maze_stone_mossy.get());
        ResourceLocation brickTex = this.blockTexture((Block)TFBlocks.maze_stone_brick.get());
        ModelBuilder mosaic = this.models().cubeColumn(TFBlocks.maze_stone_mosaic.getId().func_110623_a(), brickTex, this.blockTexture((Block)TFBlocks.maze_stone_mosaic.get()));
        this.simpleBlock((Block)TFBlocks.maze_stone_mosaic.get(), (ModelFile)mosaic);
        ModelBuilder border = this.models().cubeColumn(TFBlocks.maze_stone_border.getId().func_110623_a(), brickTex, this.blockTexture((Block)TFBlocks.maze_stone_border.get()));
        this.simpleBlock((Block)TFBlocks.maze_stone_border.get(), (ModelFile)border);
    }

    private void lilyPad(Block b) {
        String baseName = b.getRegistryName().func_110623_a();
        ResourceLocation parent = new ResourceLocation("block/lily_pad");
        ModelFile[] models = new ModelFile[4];
        for (int i = 0; i < models.length; ++i) {
            models[i] = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_" + i, parent)).texture("texture", TwilightForestMod.prefix("block/huge_lilypad_" + i))).texture("particle", "#texture");
        }
        ImmutableMap north = ImmutableMap.of((Object)((Object)HugeLilypadPiece.NW), (Object)models[1], (Object)((Object)HugeLilypadPiece.NE), (Object)models[0], (Object)((Object)HugeLilypadPiece.SE), (Object)models[3], (Object)((Object)HugeLilypadPiece.SW), (Object)models[2]);
        ImmutableMap south = ImmutableMap.of((Object)((Object)HugeLilypadPiece.NW), (Object)models[3], (Object)((Object)HugeLilypadPiece.NE), (Object)models[2], (Object)((Object)HugeLilypadPiece.SE), (Object)models[1], (Object)((Object)HugeLilypadPiece.SW), (Object)models[0]);
        ImmutableMap west = ImmutableMap.of((Object)((Object)HugeLilypadPiece.NW), (Object)models[0], (Object)((Object)HugeLilypadPiece.NE), (Object)models[3], (Object)((Object)HugeLilypadPiece.SE), (Object)models[2], (Object)((Object)HugeLilypadPiece.SW), (Object)models[1]);
        ImmutableMap east = ImmutableMap.of((Object)((Object)HugeLilypadPiece.NW), (Object)models[2], (Object)((Object)HugeLilypadPiece.NE), (Object)models[1], (Object)((Object)HugeLilypadPiece.SE), (Object)models[0], (Object)((Object)HugeLilypadPiece.SW), (Object)models[3]);
        this.getVariantBuilder(b).forAllStates(arg_0 -> BlockstateGenerator.lambda$lilyPad$21((Map)north, (Map)south, (Map)west, (Map)east, arg_0));
    }

    private void perFaceBlock(Block b, ResourceLocation inside, ResourceLocation outside) {
        ModelBuilder modelInside = ((BlockModelBuilder)this.models().withExistingParent(b.getRegistryName().func_110623_a() + "_inside", TwilightForestMod.prefix("block/util/north_face"))).texture("texture", inside);
        ModelBuilder modelOutside = ((BlockModelBuilder)this.models().withExistingParent(b.getRegistryName().func_110623_a() + "_outside", TwilightForestMod.prefix("block/util/north_face"))).texture("texture", outside);
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)modelInside).addModel()).condition((Property)HugeMushroomBlock.field_196459_a, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)modelOutside).addModel()).condition((Property)HugeMushroomBlock.field_196459_a, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)modelInside).uvLock(true).rotationY(180).addModel()).condition((Property)HugeMushroomBlock.field_196463_c, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)modelOutside).uvLock(true).rotationY(180).addModel()).condition((Property)HugeMushroomBlock.field_196463_c, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)modelInside).uvLock(true).rotationY(270).addModel()).condition((Property)HugeMushroomBlock.field_196464_y, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)modelOutside).uvLock(true).rotationY(270).addModel()).condition((Property)HugeMushroomBlock.field_196464_y, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)modelInside).uvLock(true).rotationY(90).addModel()).condition((Property)HugeMushroomBlock.field_196461_b, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)modelOutside).uvLock(true).rotationY(90).addModel()).condition((Property)HugeMushroomBlock.field_196461_b, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)modelInside).uvLock(true).rotationX(270).addModel()).condition((Property)HugeMushroomBlock.field_196465_z, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)modelOutside).uvLock(true).rotationX(270).addModel()).condition((Property)HugeMushroomBlock.field_196465_z, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)modelInside).uvLock(true).rotationX(90).addModel()).condition((Property)HugeMushroomBlock.field_196460_A, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(b).part().modelFile((ModelFile)modelOutside).uvLock(true).rotationX(90).addModel()).condition((Property)HugeMushroomBlock.field_196460_A, (Comparable[])new Boolean[]{true}).end();
    }

    @Nonnull
    public String func_200397_b() {
        return "TwilightForest blockstates and block models";
    }

    private static /* synthetic */ ConfiguredModel[] lambda$lilyPad$21(Map north, Map south, Map west, Map east, BlockState state) {
        Map m;
        int rotY;
        switch ((Direction)state.func_177229_b((Property)HugeLilyPadBlock.FACING)) {
            default: {
                rotY = 0;
                m = north;
                break;
            }
            case SOUTH: {
                rotY = 180;
                m = south;
                break;
            }
            case WEST: {
                rotY = 270;
                m = west;
                break;
            }
            case EAST: {
                rotY = 90;
                m = east;
            }
        }
        ModelFile model = (ModelFile)m.get(state.func_177229_b(HugeLilyPadBlock.PIECE));
        return ConfiguredModel.builder().rotationY(rotY).modelFile(model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$towerBlocks$20(ModelFile reappearVanishedActive, ModelFile reappearVanished, ModelFile reappearActive, ModelFile reappear, BlockState s) {
        ModelFile model = (Boolean)s.func_177229_b((Property)VanishingBlock.VANISHED) != false ? ((Boolean)s.func_177229_b((Property)VanishingBlock.ACTIVE) != false ? reappearVanishedActive : reappearVanished) : ((Boolean)s.func_177229_b((Property)VanishingBlock.ACTIVE) != false ? reappearActive : reappear);
        return ConfiguredModel.builder().modelFile(model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$slider$19(ModelFile horizSlider, ModelFile slider, BlockState state) {
        switch ((Direction.Axis)state.func_177229_b((Property)SliderBlock.field_176298_M)) {
            case X: {
                switch ((Integer)state.func_177229_b((Property)SliderBlock.DELAY)) {
                    default: 
                }
                return ConfiguredModel.builder().modelFile(horizSlider).rotationX(90).rotationY(90).build();
            }
            default: {
                switch ((Integer)state.func_177229_b((Property)SliderBlock.DELAY)) {
                    default: 
                }
                return ConfiguredModel.builder().modelFile(slider).build();
            }
            case Z: 
        }
        switch ((Integer)state.func_177229_b((Property)SliderBlock.DELAY)) {
            default: 
        }
        return ConfiguredModel.builder().modelFile(horizSlider).rotationX(90).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$woodStairs$18(ModelFile main0, ModelFile inner0, ModelFile outer0, ModelFile main1, ModelFile inner1, ModelFile outer1, ModelFile main2, ModelFile inner2, ModelFile outer2, ModelFile main3, ModelFile inner3, ModelFile outer3, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((Property)StairsBlock.field_176309_a);
        Half half = (Half)state.func_177229_b((Property)StairsBlock.field_176308_b);
        StairsShape shape = (StairsShape)state.func_177229_b((Property)StairsBlock.field_176310_M);
        int yRot = (int)facing.func_176746_e().func_185119_l();
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
            yRot += 270;
        }
        if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
            yRot += 90;
        }
        boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
        return ConfiguredModel.builder().weight(10).modelFile(shape == StairsShape.STRAIGHT ? main0 : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? inner0 : outer0)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).nextModel().weight(10).modelFile(shape == StairsShape.STRAIGHT ? main1 : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? inner1 : outer1)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).nextModel().weight(1).modelFile(shape == StairsShape.STRAIGHT ? main2 : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? inner2 : outer2)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).nextModel().weight(1).modelFile(shape == StairsShape.STRAIGHT ? main3 : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? inner3 : outer3)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$woodButton$17(ModelFile pressed0, ModelFile unpressed0, ModelFile pressed1, ModelFile unpressed1, ModelFile pressed2, ModelFile unpressed2, ModelFile pressed3, ModelFile unpressed3, BlockState state) {
        ModelFile model0 = (Boolean)state.func_177229_b((Property)AbstractButtonBlock.field_176584_b) != false ? pressed0 : unpressed0;
        ModelFile model1 = (Boolean)state.func_177229_b((Property)AbstractButtonBlock.field_176584_b) != false ? pressed1 : unpressed1;
        ModelFile model2 = (Boolean)state.func_177229_b((Property)AbstractButtonBlock.field_176584_b) != false ? pressed2 : unpressed2;
        ModelFile model3 = (Boolean)state.func_177229_b((Property)AbstractButtonBlock.field_176584_b) != false ? pressed3 : unpressed3;
        int rotX = 0;
        switch ((AttachFace)state.func_177229_b((Property)HorizontalFaceBlock.field_196366_M)) {
            case WALL: {
                rotX = 90;
                break;
            }
            case FLOOR: {
                rotX = 0;
                break;
            }
            case CEILING: {
                rotX = 180;
            }
        }
        int rotY = 0;
        if (state.func_177229_b((Property)HorizontalFaceBlock.field_196366_M) == AttachFace.CEILING) {
            switch ((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)) {
                case NORTH: {
                    rotY = 180;
                    break;
                }
                case SOUTH: {
                    rotY = 0;
                    break;
                }
                case WEST: {
                    rotY = 90;
                    break;
                }
                case EAST: {
                    rotY = 270;
                }
            }
        } else {
            switch ((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)) {
                case NORTH: {
                    rotY = 0;
                    break;
                }
                case SOUTH: {
                    rotY = 180;
                    break;
                }
                case WEST: {
                    rotY = 270;
                    break;
                }
                case EAST: {
                    rotY = 90;
                }
            }
        }
        boolean uvlock = state.func_177229_b((Property)HorizontalFaceBlock.field_196366_M) == AttachFace.WALL;
        return ConfiguredModel.builder().weight(10).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model0).nextModel().weight(10).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model1).nextModel().weight(1).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model2).nextModel().weight(1).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model3).build();
    }

    private static /* synthetic */ void lambda$woodFence$16(MultiPartBlockStateBuilder builder, ModelFile side0, ModelFile side1, ModelFile side2, ModelFile side3, Direction dir, BooleanProperty value) {
        if (dir.func_176740_k().func_176722_c()) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().weight(10).modelFile(side0).rotationY(((int)dir.func_185119_l() + 180) % 360).uvLock(true).nextModel().weight(10).modelFile(side1).rotationY(((int)dir.func_185119_l() + 180) % 360).uvLock(true).nextModel().weight(1).modelFile(side2).rotationY(((int)dir.func_185119_l() + 180) % 360).uvLock(true).nextModel().weight(1).modelFile(side3).rotationY(((int)dir.func_185119_l() + 180) % 360).uvLock(true).addModel()).condition((Property)value, (Comparable[])new Boolean[]{true});
        }
    }

    private static /* synthetic */ ConfiguredModel[] lambda$woodGate$15(ModelFile gate0, ModelFile gate1, ModelFile gate2, ModelFile gate3, ModelFile wall0, ModelFile wall1, ModelFile wall2, ModelFile wall3, ModelFile wallOpen0, ModelFile open0, ModelFile wallOpen1, ModelFile open1, ModelFile wallOpen2, ModelFile open2, ModelFile wallOpen3, ModelFile open3, BlockState state) {
        ModelFile model0 = gate0;
        ModelFile model1 = gate1;
        ModelFile model2 = gate2;
        ModelFile model3 = gate3;
        if (((Boolean)state.func_177229_b((Property)FenceGateBlock.field_176467_M)).booleanValue()) {
            model0 = wall0;
            model1 = wall1;
            model2 = wall2;
            model3 = wall3;
        }
        if (((Boolean)state.func_177229_b((Property)FenceGateBlock.field_176466_a)).booleanValue()) {
            model0 = model0 == wall0 ? wallOpen0 : open0;
            model1 = model1 == wall1 ? wallOpen1 : open1;
            model2 = model2 == wall2 ? wallOpen2 : open2;
            model3 = model3 == wall3 ? wallOpen3 : open3;
        }
        return ConfiguredModel.builder().weight(10).modelFile(model0).rotationY((int)((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_185119_l()).uvLock(true).nextModel().weight(10).modelFile(model1).rotationY((int)((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_185119_l()).uvLock(true).nextModel().weight(1).modelFile(model2).rotationY((int)((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_185119_l()).uvLock(true).nextModel().weight(1).modelFile(model3).rotationY((int)((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_185119_l()).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$magicLogCore$14(ModelFile on, ModelFile off, BlockState s) {
        ModelFile f = (Boolean)s.func_177229_b((Property)SpecialMagicLogBlock.ACTIVE) != false ? on : off;
        Direction.Axis axis = (Direction.Axis)s.func_177229_b((Property)RotatedPillarBlock.field_176298_M);
        int rotX = axis == Direction.Axis.X || axis == Direction.Axis.Z ? 90 : 0;
        int rotY = axis == Direction.Axis.X ? 90 : 0;
        return ConfiguredModel.builder().modelFile(f).rotationX(rotX).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$nagastonePillar$4(ModelFile reversed, ModelFile model, BlockState state) {
        int rotX = 0;
        int rotY = 0;
        switch ((Direction.Axis)state.func_177229_b((Property)RotatedPillarBlock.field_176298_M)) {
            default: {
                rotY = 270;
                rotX = 270;
                break;
            }
            case Y: {
                break;
            }
            case Z: {
                rotX = 270;
            }
        }
        ModelFile m = (Boolean)state.func_177229_b((Property)DirectionalRotatedPillarBlock.REVERSED) != false ? reversed : model;
        return ConfiguredModel.builder().rotationX(rotX).rotationY(rotY).modelFile(m).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerNagastone$3(ModelFile down, ModelFile up, ModelFile horizontal, ModelFile vertical, ModelFile solid, BlockState s) {
        switch ((NagastoneVariant)((Object)s.func_177229_b(NagastoneBlock.VARIANT))) {
            case NORTH_DOWN: {
                return ConfiguredModel.builder().modelFile(down).rotationY(270).build();
            }
            case SOUTH_DOWN: {
                return ConfiguredModel.builder().modelFile(down).rotationY(90).build();
            }
            case WEST_DOWN: {
                return ConfiguredModel.builder().modelFile(down).rotationY(180).build();
            }
            case EAST_DOWN: {
                return ConfiguredModel.builder().modelFile(down).build();
            }
            case NORTH_UP: {
                return ConfiguredModel.builder().modelFile(up).rotationY(270).build();
            }
            case SOUTH_UP: {
                return ConfiguredModel.builder().modelFile(up).rotationY(90).build();
            }
            case EAST_UP: {
                return ConfiguredModel.builder().modelFile(up).build();
            }
            case WEST_UP: {
                return ConfiguredModel.builder().modelFile(up).rotationY(180).build();
            }
            case AXIS_X: {
                return ConfiguredModel.builder().modelFile(horizontal).build();
            }
            case AXIS_Y: {
                return ConfiguredModel.builder().modelFile(vertical).build();
            }
            case AXIS_Z: {
                return ConfiguredModel.builder().modelFile(horizontal).rotationY(90).build();
            }
        }
        return ConfiguredModel.builder().modelFile(solid).build();
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$2(ModelFile furnaceOn, ModelFile furnaceOff, BlockState state) {
        return (Boolean)state.func_177229_b((Property)AbstractFurnaceBlock.field_220091_b) != false ? furnaceOn : furnaceOff;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$1(ModelFile shieldModel, BlockState state) {
        Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        return ConfiguredModel.builder().uvLock(true).modelFile(shieldModel).rotationX(dir == Direction.DOWN ? 180 : (dir.func_176740_k().func_176722_c() ? 90 : 0)).rotationY(dir.func_176740_k().func_200128_b() ? 0 : (int)dir.func_185119_l() % 360).build();
    }
}

