/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import java.util.Objects;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IWeatherRenderHandler;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import twilightforest.TFConfig;
import twilightforest.TFEventListener;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.client.BugModelAnimationHelper;
import twilightforest.client.RenderEffect;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.client.model.item.FullbrightBakedModel;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.client.renderer.entity.ShieldLayer;
import twilightforest.item.TFItems;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT})
public class TFClientEvents {
    public static int time = 0;
    private static int rotationTickerI = 0;
    private static int sineTickerI = 0;
    public static float rotationTicker = 0.0f;
    public static float sineTicker = 0.0f;
    public static final float PI = (float)Math.PI;
    private static final int SINE_TICKER_BOUND = 627;

    @SubscribeEvent
    public static void preOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTHMOUNT && TFEventListener.isRidingUnfriendly((LivingEntity)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderWorldLast(RenderWorldLastEvent event) {
        EntityRenderer renderer;
        if (!((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue()) {
            return;
        }
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        if (settings.func_243230_g() != PointOfView.FIRST_PERSON || settings.field_74319_N) {
            return;
        }
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity instanceof LivingEntity && (renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity)) instanceof LivingRenderer) {
            for (RenderEffect effect : RenderEffect.VALUES) {
                if (!effect.shouldRender((LivingEntity)entity, true)) continue;
                effect.render((LivingEntity)entity, (EntityModel<? extends LivingEntity>)((LivingRenderer)renderer).func_217764_d(), 0.0, 0.0, 0.0, event.getPartialTicks(), true);
            }
        }
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71441_e != null && "twilightforest".equals(minecraft.field_71441_e.func_234923_W_().func_240901_a_().func_110624_b()) && minecraft.field_71456_v != null) {
                minecraft.field_71456_v.field_73843_a = 0.0f;
            }
            if (minecraft.field_71439_g != null && TFEventListener.isRidingUnfriendly((LivingEntity)minecraft.field_71439_g) && minecraft.field_71456_v != null) {
                minecraft.field_71456_v.func_175188_a(StringTextComponent.field_240750_d_, false);
            }
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        IWeatherRenderHandler weatherRenderer;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ++time;
        Minecraft mc = Minecraft.func_71410_x();
        float partial = mc.func_184121_ak();
        rotationTickerI = rotationTickerI >= 359 ? 0 : rotationTickerI + 1;
        sineTickerI = sineTickerI >= 627 ? 0 : sineTickerI + 1;
        rotationTicker = (float)rotationTickerI + partial;
        sineTicker += partial;
        BugModelAnimationHelper.animate();
        DimensionRenderInfo info = (DimensionRenderInfo)DimensionRenderInfo.field_239208_a_.get((Object)TwilightForestMod.prefix("renderer"));
        if (!mc.func_147113_T() && mc.field_71441_e != null && info instanceof TwilightForestRenderInfo && (weatherRenderer = info.getWeatherRenderHandler()) instanceof TFWeatherRenderer) {
            ((TFWeatherRenderer)weatherRenderer).tick();
        }
    }

    @Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void modelBake(ModelBakeEvent event) {
            ModBusEvents.fullbrightItem(event, TFItems.fiery_ingot);
            ModBusEvents.fullbrightItem(event, TFItems.fiery_boots);
            ModBusEvents.fullbrightItem(event, TFItems.fiery_chestplate);
            ModBusEvents.fullbrightItem(event, TFItems.fiery_helmet);
            ModBusEvents.fullbrightItem(event, TFItems.fiery_leggings);
            ModBusEvents.fullbrightItem(event, TFItems.fiery_pickaxe);
            ModBusEvents.fullbrightItem(event, TFItems.fiery_sword);
            ModBusEvents.fullbright(event, TFBlocks.fiery_block.getId(), "");
        }

        private static void fullbrightItem(ModelBakeEvent event, RegistryObject<Item> item) {
            ModBusEvents.fullbright(event, Objects.requireNonNull(item.getId()), "inventory");
        }

        private static void fullbright(ModelBakeEvent event, ResourceLocation rl, String state) {
            ModelResourceLocation mrl = new ModelResourceLocation(rl, state);
            event.getModelRegistry().put(mrl, new FullbrightBakedModel((IBakedModel)event.getModelRegistry().get(mrl)));
        }

        @SubscribeEvent
        public static void texStitch(TextureStitchEvent.Pre evt) {
            AtlasTexture map = evt.getMap();
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            ModelLoader.addSpecialModel((ResourceLocation)ShieldLayer.LOC);
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(TwilightForestMod.prefix("trophy"), "inventory"));
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(TwilightForestMod.prefix("trophy_minor"), "inventory"));
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(TwilightForestMod.prefix("trophy_quest"), "inventory"));
            ModelLoader.addSpecialModel((ResourceLocation)TwilightForestMod.prefix("block/casket_obsidian"));
            ModelLoader.addSpecialModel((ResourceLocation)TwilightForestMod.prefix("block/casket_stone"));
            ModelLoader.addSpecialModel((ResourceLocation)TwilightForestMod.prefix("block/casket_basalt"));
        }
    }
}

