/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import twilightforest.block.AbstractTrophyBlock;
import twilightforest.enums.BossVariant;

public class TrophyBlock
extends AbstractTrophyBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.field_208138_am;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    public static final VoxelShape GHAST_SHAPE = Block.func_208617_a((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape YETI_X_SHAPE = Block.func_208617_a((double)3.25, (double)0.0, (double)4.5, (double)12.75, (double)10.0, (double)11.5);
    protected static final VoxelShape YETI_Z_SHAPE = Block.func_208617_a((double)4.5, (double)0.0, (double)3.25, (double)11.5, (double)10.0, (double)12.75);
    protected static final VoxelShape YETI_CORNER_SHAPE = Block.func_208617_a((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)10.0, (double)11.5);

    public TrophyBlock(BossVariant variant, int value) {
        super(variant, value, AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200946_b());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((AbstractTrophyBlock)state.func_177230_c()).getVariant() == BossVariant.UR_GHAST) {
            return GHAST_SHAPE;
        }
        if (((AbstractTrophyBlock)state.func_177230_c()).getVariant() == BossVariant.ALPHA_YETI) {
            switch ((Integer)state.func_177229_b((Property)ROTATION)) {
                default: {
                    return YETI_X_SHAPE;
                }
                case 3: 
                case 4: 
                case 5: 
                case 11: 
                case 12: 
                case 13: {
                    return YETI_Z_SHAPE;
                }
                case 2: 
                case 6: 
                case 10: 
                case 14: 
            }
            return YETI_CORNER_SHAPE;
        }
        return SHAPE;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(MathHelper.func_76128_c((double)((double)(context.func_195990_h() * 16.0f / 360.0f) + 0.5)) & 0xF));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot.func_185833_a(((Integer)state.func_177229_b((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(mirrorIn.func_185802_a(((Integer)state.func_177229_b((Property)ROTATION)).intValue(), 16)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ROTATION, POWERED});
    }
}

