/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.mutable.MutableInt;
import twilightforest.TFConfig;
import twilightforest.TFSounds;
import twilightforest.block.TFBlocks;
import twilightforest.data.BlockTagGenerator;
import twilightforest.world.TFGenerationSettings;
import twilightforest.world.TFTeleporter;

public class TFPortalBlock
extends BreakableBlock
implements ILiquidContainer {
    public static final BooleanProperty DISALLOW_RETURN = BooleanProperty.func_177716_a((String)"is_one_way");
    private static final VoxelShape AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0));
    private static final int MIN_PORTAL_SIZE = 4;
    private static final int MAX_PORTAL_SIZE = 64;

    public TFPortalBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DISALLOW_RETURN, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{DISALLOW_RETURN});
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)DISALLOW_RETURN) != false ? AABB : VoxelShapes.func_197880_a();
    }

    public FluidState func_204507_t(BlockState state) {
        return Fluids.field_204546_a.func_207207_a(1, false);
    }

    public boolean tryToCreatePortal(World world, BlockPos pos, ItemEntity catalyst, @Nullable PlayerEntity player) {
        BlockState state = world.func_180495_p(pos);
        if (this.canFormPortal(state) && world.func_180495_p(pos.func_177977_b()).func_200132_m()) {
            HashMap<BlockPos, Boolean> blocksChecked = new HashMap<BlockPos, Boolean>();
            blocksChecked.put(pos, true);
            MutableInt size = new MutableInt(0);
            if (TFPortalBlock.recursivelyValidatePortal(world, pos, blocksChecked, size, state) && size.intValue() >= 4) {
                boolean checkProgression;
                if (((Boolean)TFConfig.COMMON_CONFIG.checkPortalDestination.get()).booleanValue() && !TFTeleporter.isSafeAround(world, pos, (Entity)catalyst, checkProgression = TFGenerationSettings.isProgressionEnforced(catalyst.field_70170_p))) {
                    if (player != null) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("twilightforest.twilight_portal.unsafe"), true);
                    }
                    return false;
                }
                catalyst.func_92059_d().func_190918_g(1);
                TFPortalBlock.causeLightning(world, pos, (Boolean)TFConfig.COMMON_CONFIG.portalLightning.get());
                for (Map.Entry checkedPos : blocksChecked.entrySet()) {
                    if (!((Boolean)checkedPos.getValue()).booleanValue()) continue;
                    world.func_180501_a((BlockPos)checkedPos.getKey(), ((TFPortalBlock)TFBlocks.twilight_portal.get()).func_176223_P(), 2);
                }
                return true;
            }
        }
        return false;
    }

    public boolean canFormPortal(BlockState state) {
        return state.func_177230_c().func_203417_a(BlockTagGenerator.PORTAL_POOL) || state.func_177230_c() == this && (Boolean)state.func_177229_b((Property)DISALLOW_RETURN) != false;
    }

    private static void causeLightning(World world, BlockPos pos, boolean fake) {
        LightningBoltEntity bolt = new LightningBoltEntity(EntityType.field_200728_aG, world);
        bolt.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        bolt.func_233623_a_(fake);
        world.func_217376_c((Entity)bolt);
        if (fake && world instanceof ServerWorld) {
            double range = 3.0;
            List list = world.func_217357_a(Entity.class, new AxisAlignedBB(pos).func_186662_g(range));
            for (Entity victim : list) {
                if (ForgeEventFactory.onEntityStruckByLightning((Entity)victim, (LightningBoltEntity)bolt)) continue;
                victim.func_241841_a((ServerWorld)world, bolt);
            }
        }
    }

    private static boolean recursivelyValidatePortal(World world, BlockPos pos, Map<BlockPos, Boolean> blocksChecked, MutableInt portalSize, BlockState poolBlock) {
        if (portalSize.incrementAndGet() > 64) {
            return false;
        }
        boolean isPoolProbablyEnclosed = true;
        for (int i = 0; i < 4 && portalSize.intValue() <= 64; ++i) {
            BlockPos positionCheck = pos.func_177972_a(Direction.func_176731_b((int)i));
            if (blocksChecked.containsKey(positionCheck)) continue;
            BlockState state = world.func_180495_p(positionCheck);
            if (state == poolBlock && world.func_180495_p(positionCheck.func_177977_b()).func_200132_m()) {
                blocksChecked.put(positionCheck, true);
                if (!isPoolProbablyEnclosed) continue;
                isPoolProbablyEnclosed = TFPortalBlock.recursivelyValidatePortal(world, positionCheck, blocksChecked, portalSize, poolBlock);
                continue;
            }
            if (TFPortalBlock.isGrassOrDirt(state) && TFPortalBlock.isNatureBlock(world.func_180495_p(positionCheck.func_177984_a()))) {
                blocksChecked.put(positionCheck, false);
                continue;
            }
            return false;
        }
        return isPoolProbablyEnclosed;
    }

    private static boolean isNatureBlock(BlockState state) {
        return BlockTagGenerator.PORTAL_DECO.func_230235_a_((Object)state.func_177230_c());
    }

    private static boolean isGrassOrDirt(BlockState state) {
        return BlockTagGenerator.PORTAL_EDGE.func_230235_a_((Object)state.func_177230_c());
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean good = world.func_180495_p(pos.func_177977_b()).func_200132_m();
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (!good) break;
            BlockState neighboringState = world.func_180495_p(pos.func_177972_a(facing));
            good = TFPortalBlock.isGrassOrDirt(neighboringState) || neighboringState == state;
        }
        if (!good) {
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 3);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (state == this.func_176223_P()) {
            TFPortalBlock.attemptSendPlayer(entity, false);
        }
    }

    private static RegistryKey<World> getDestination(Entity entity) {
        RegistryKey twilightForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation((String)TFConfig.COMMON_CONFIG.DIMENSION.twilightForestID.get()));
        return !entity.func_130014_f_().func_234923_W_().func_240901_a_().equals((Object)twilightForest.func_240901_a_()) ? twilightForest : RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation((String)TFConfig.COMMON_CONFIG.originDimension.get()));
    }

    public static void attemptSendPlayer(Entity entity, boolean forcedEntry) {
        if (!entity.func_70089_S() || entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.func_184218_aH() || entity.func_184207_aI() || !entity.func_184222_aU()) {
            return;
        }
        if (!forcedEntry && entity.field_82153_h > 0) {
            return;
        }
        entity.field_82153_h = 10;
        RegistryKey<World> destination = TFPortalBlock.getDestination(entity);
        ServerWorld serverWorld = entity.func_130014_f_().func_73046_m().func_71218_a(destination);
        if (serverWorld == null) {
            return;
        }
        entity.changeDimension(serverWorld, (ITeleporter)new TFTeleporter(forcedEntry));
        if (destination == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation((String)TFConfig.COMMON_CONFIG.DIMENSION.twilightForestID.get())) && entity instanceof ServerPlayerEntity && forcedEntry) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)entity;
            playerMP.func_242111_a(destination, playerMP.func_233580_cy_(), playerMP.field_70177_z, true, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int random = rand.nextInt(100);
        if (((Boolean)stateIn.func_177229_b((Property)DISALLOW_RETURN)).booleanValue() && random < 80) {
            return;
        }
        if (random == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, TFSounds.PORTAL_WOOSH, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double xPos = (float)pos.func_177958_n() + rand.nextFloat();
            double yPos = (double)pos.func_177956_o() + 1.0;
            double zPos = (float)pos.func_177952_p() + rand.nextFloat();
            double xSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double ySpeed = rand.nextFloat();
            double zSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed);
        }
    }

    public boolean func_204510_a(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return false;
    }

    public boolean func_204509_a(IWorld iWorld, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        return false;
    }
}

