/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import twilightforest.world.feature.TFGenCaveStalactite;

@Mod.EventBusSubscriber(modid="twilightforest", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IMCHandler {
    private static final ImmutableList.Builder<BlockState> ORE_BLOCKS_BUILDER = ImmutableList.builder();
    private static final ImmutableList.Builder<ItemStack> LOADING_ICONS_BUILDER = ImmutableList.builder();
    private static final ImmutableMultimap.Builder<BlockState, BlockState> CRUMBLE_BLOCKS_BUILDER = ImmutableMultimap.builder();
    private static final ImmutableMultimap.Builder<Integer, TFGenCaveStalactite.StalactiteEntry> STALACTITE_BUILDER = ImmutableMultimap.builder();

    @SubscribeEvent
    public static void onIMC(InterModProcessEvent event) {
        InterModComms.getMessages((String)"twilightforest").forEach(message -> {
            Object thing = message.getMessageSupplier().get();
            if (thing instanceof CompoundNBT) {
                CompoundNBT imcCompound = (CompoundNBT)thing;
                IMCHandler.readFromTagList(imcCompound.func_150295_c("Ore_Blocks", 10), IMCHandler::handleOre);
                IMCHandler.readFromTagList(imcCompound.func_150295_c("Crumbling", 10), IMCHandler::handleCrumble);
            }
            if (thing instanceof ItemStack && message.getMethod().equals("Loading_Icon")) {
                LOADING_ICONS_BUILDER.add((Object)((ItemStack)thing));
            }
        });
    }

    private static void readFromTagList(ListNBT list, Consumer<CompoundNBT> consumer) {
        for (int i = 0; i < list.size(); ++i) {
            consumer.accept(list.func_150305_b(i));
        }
    }

    private static void readStatesFromTagList(ListNBT list, Consumer<BlockState> consumer) {
        for (int i = 0; i < list.size(); ++i) {
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)list.func_150305_b(i));
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            consumer.accept(state);
        }
    }

    private static void handleCrumble(CompoundNBT nbt) {
        BlockState key = NBTUtil.func_190008_d((CompoundNBT)nbt);
        if (key.func_177230_c() != Blocks.field_150350_a) {
            IMCHandler.readStatesFromTagList(nbt.func_150295_c("Crumbling", 10), value -> CRUMBLE_BLOCKS_BUILDER.put((Object)key, value));
        }
    }

    private static void handleOre(CompoundNBT nbt) {
        BlockState nbtState = NBTUtil.func_190008_d((CompoundNBT)nbt);
        if (nbtState.func_177230_c() != Blocks.field_150350_a) {
            ORE_BLOCKS_BUILDER.add((Object)nbtState);
            if (nbt.func_150297_b("Stalactite_Settings", 10)) {
                CompoundNBT settings = nbt.func_74775_l("Stalactite_Settings");
                int weight = IMCHandler.readInt(settings, "Weight", 15);
                int hillSize = IMCHandler.readInt(settings, "Hill_Size", 3);
                float size = IMCHandler.readFloat(settings, "Size", 0.7f);
                int maxLength = IMCHandler.readInt(settings, "Max_Length", 8);
                int minHeight = IMCHandler.readInt(settings, "Min_Height", 1);
                STALACTITE_BUILDER.put((Object)hillSize, (Object)new TFGenCaveStalactite.StalactiteEntry(nbtState, size, maxLength, minHeight, weight));
            }
        }
    }

    private static int readInt(CompoundNBT tag, String key, int defaultValue) {
        return tag.func_150297_b(key, 99) ? tag.func_74762_e(key) : defaultValue;
    }

    private static float readFloat(CompoundNBT tag, String key, float defaultValue) {
        return tag.func_150297_b(key, 99) ? tag.func_74760_g(key) : defaultValue;
    }

    public static ImmutableList<ItemStack> getLoadingIconStacks() {
        return LOADING_ICONS_BUILDER.build();
    }

    public static ImmutableMultimap<Integer, TFGenCaveStalactite.StalactiteEntry> getStalactites() {
        return STALACTITE_BUILDER.build();
    }
}

